/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.opensaml.xml.util.Base64;
import org.w3c.dom.Document;
import wsattacker.library.xmlencryptionattack.attackengine.CryptoAttackException;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.util.CryptoConstants;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class Utility {
    private static Logger LOG = Logger.getLogger(Utility.class);
    private static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String bytesToHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            builder.append(HEXCHARS[(bytes[i] & 0xFF) >>> 4]);
            builder.append(HEXCHARS[bytes[i] & 0xF]);
            builder.append(' ');
        }
        return builder.toString();
    }

    public static byte[] encryptSymmetricData(byte[] plaintext, byte[] key, CryptoConstants.Algorithm algorithm) throws CryptoAttackException {
        int blocks = plaintext.length / algorithm.BLOCK_SIZE + 1;
        byte[] paddedText = new byte[blocks * algorithm.BLOCK_SIZE];
        Random r = new Random();
        r.nextBytes(paddedText);
        System.arraycopy(plaintext, 0, paddedText, 0, plaintext.length);
        int paddingByte = paddedText.length - plaintext.length;
        paddedText[paddedText.length - 1] = (byte)paddingByte;
        LOG.debug((Object)("padding byte: " + paddingByte));
        SecretKeySpec skeySpec = new SecretKeySpec(key, algorithm.KEY_SPEC_NAME);
        try {
            Cipher encryptor = Cipher.getInstance(algorithm.JAVA_NAME);
            byte[] iv = new byte[encryptor.getBlockSize()];
            r.nextBytes(iv);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            encryptor.init(1, (Key)skeySpec, ivParameterSpec);
            byte[] result = new byte[iv.length + paddedText.length];
            byte[] encrypted = encryptor.doFinal(paddedText);
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(encrypted, 0, result, iv.length, encrypted.length);
            return result;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoAttackException(ex);
        }
    }

    public static final String[] getAttackStringPartsFromDoc(int dataSize, AbstractEncryptionElement tmpEncData, Document attackDocument) {
        String[] attackParts = new String[2];
        Random r = new Random();
        byte[] b = new byte[dataSize * 2];
        r.nextBytes(b);
        String rndPay = Base64.encodeBytes((byte[])b);
        tmpEncData.getCipherDataChild().setEncryptedData(rndPay);
        String attackString = DomUtilities.domToString((Document)attackDocument);
        int indexOfPay = attackString.indexOf(rndPay);
        attackParts[0] = attackString.subSequence(0, indexOfPay).toString();
        attackParts[1] = attackString.subSequence(indexOfPay + rndPay.length(), attackString.length()).toString();
        return attackParts;
    }

    public static PublicKey getPubKeyFromCert(File certFile) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, CertificateException, FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(certFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
        return cert.getPublicKey();
    }

    public static PublicKey getPubKeyFromKeyFile(File pubKeyFile) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, CertificateException, FileNotFoundException, IOException {
        byte[] keyBytes;
        FileInputStream fis = new FileInputStream(pubKeyFile);
        try (DataInputStream dis = new DataInputStream(fis);){
            keyBytes = new byte[(int)pubKeyFile.length()];
            dis.readFully(keyBytes);
            dis.close();
        }
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }
}

