/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.tokenisers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.wordhandlers.DummyStopTermHandler;
import uk.ac.shef.wit.simmetrics.wordhandlers.InterfaceTermHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokeniserCSVBasic
implements InterfaceTokeniser,
Serializable {
    private InterfaceTermHandler stopWordHandler = new DummyStopTermHandler();
    private final String delimiters = ",";

    @Override
    public final String getShortDescriptionString() {
        return "TokeniserCSVBasic";
    }

    @Override
    public final String getDelimiters() {
        return ",";
    }

    @Override
    public InterfaceTermHandler getStopWordHandler() {
        return this.stopWordHandler;
    }

    @Override
    public void setStopWordHandler(InterfaceTermHandler stopWordHandler) {
        this.stopWordHandler = stopWordHandler;
    }

    @Override
    public final ArrayList<String> tokenizeToArrayList(String input) {
        ArrayList<String> returnArrayList = new ArrayList<String>();
        int curPos = 0;
        while (curPos < input.length()) {
            char ch = input.charAt(curPos);
            if (Character.isWhitespace(ch)) {
                ++curPos;
            }
            int nextGapPos = input.length();
            for (int i = 0; i < ",".length(); ++i) {
                int testPos = input.indexOf(",".charAt(i), curPos);
                if (testPos >= nextGapPos || testPos == -1) continue;
                nextGapPos = testPos;
            }
            String term = input.substring(curPos, nextGapPos);
            if (!this.stopWordHandler.isWord(term) && !term.equals(" ")) {
                returnArrayList.add(term);
            }
            curPos = nextGapPos;
        }
        return returnArrayList;
    }

    @Override
    public Set<String> tokenizeToSet(String input) {
        HashSet<String> returnSet = new HashSet<String>();
        returnSet.addAll(this.tokenizeToArrayList(input));
        return returnSet;
    }
}

