/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaroWinkler;

public final class Soundex
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 5.2E-4f;
    private final AbstractStringMetric internalStringMetric;
    private static final int SOUNDEXLENGTH = 6;

    public Soundex() {
        this.internalStringMetric = new JaroWinkler();
    }

    public Soundex(AbstractStringMetric internalComparisonMetric) {
        this.internalStringMetric = internalComparisonMetric;
    }

    public String getShortDescriptionString() {
        return "Soundex";
    }

    public String getLongDescriptionString() {
        return "Implements the Soundex algorithm providing a similarity measure between two soundex codes";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        String testString = "abcdefghijklmnopq";
        return (str1Length + str2Length) * 5.2E-4f + this.internalStringMetric.getSimilarityTimingEstimated("abcdefghijklmnopq".substring(0, 6), "abcdefghijklmnopq".substring(0, 6));
    }

    public float getSimilarity(String string1, String string2) {
        String soundex1 = Soundex.calcSoundEx(string1, 6);
        String soundex2 = Soundex.calcSoundEx(string2, 6);
        return this.internalStringMetric.getSimilarity(soundex1, soundex2);
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        return this.internalStringMetric.getUnNormalisedSimilarity(string1, string2);
    }

    private static String calcSoundEx(String wordString, int soundExLen) {
        if (soundExLen > 10) {
            soundExLen = 10;
        }
        if (soundExLen < 4) {
            soundExLen = 4;
        }
        if (wordString.length() == 0) {
            return "";
        }
        String wordStr = wordString = wordString.toUpperCase();
        wordStr = wordStr.replaceAll("[^A-Z]", " ");
        if ((wordStr = wordStr.replaceAll("\\s+", "")).length() == 0) {
            return "";
        }
        char firstLetter = wordStr.charAt(0);
        wordStr = wordStr.length() > 25 ? "-" + wordStr.substring(1, 24) : "-" + wordStr.substring(1);
        wordStr = wordStr.replaceAll("[AEIOUWH]", "0");
        wordStr = wordStr.replaceAll("[BPFV]", "1");
        wordStr = wordStr.replaceAll("[CSKGJQXZ]", "2");
        wordStr = wordStr.replaceAll("[DT]", "3");
        wordStr = wordStr.replaceAll("[L]", "4");
        wordStr = wordStr.replaceAll("[MN]", "5");
        wordStr = wordStr.replaceAll("[R]", "6");
        int wsLen = wordStr.length();
        char lastChar = '-';
        String tmpStr = "-";
        for (int i = 1; i < wsLen; ++i) {
            char curChar = wordStr.charAt(i);
            if (curChar == lastChar) continue;
            tmpStr = tmpStr + curChar;
            lastChar = curChar;
        }
        wordStr = tmpStr;
        wordStr = wordStr.substring(1);
        wordStr = wordStr.replaceAll("0", "");
        wordStr = wordStr + "000000000000000000";
        wordStr = firstLetter + "-" + wordStr;
        wordStr = wordStr.substring(0, soundExLen);
        return wordStr;
    }
}

