/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.maven2;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.tools.SoapUISecurityTestRunner;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class SecurityTestMojo
extends AbstractMojo {
    private String projectFile;
    private String testSuite;
    private String testCase;
    private String username;
    private String password;
    private String wssPasswordType;
    private String domain;
    private String host;
    private String endpoint;
    private String outputFolder;
    private boolean printReport;
    private boolean interactive;
    private boolean exportAll;
    private boolean junitReport;
    private String settingsFile;
    private boolean skip;
    private String projectPassword;
    private String settingsPassword;
    private boolean testFailIgnore;
    private String[] globalProperties;
    private String[] projectProperties;
    private boolean saveAfterRun;
    private Properties soapuiProperties;
    private String securityTest;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || System.getProperty("maven.test.skip", "false").equals("true")) {
            return;
        }
        if (this.projectFile == null) {
            throw new MojoExecutionException("soapui-project-file setting is required");
        }
        SoapUISecurityTestRunner runner = new SoapUISecurityTestRunner("SoapUI " + SoapUI.SOAPUI_VERSION + " Maven2 Security Test Runner");
        runner.setProjectFile(this.projectFile);
        if (this.endpoint != null) {
            runner.setEndpoint(this.endpoint);
        }
        if (this.testSuite != null) {
            runner.setTestSuite(this.testSuite);
        }
        if (this.testCase != null) {
            runner.setTestCase(this.testCase);
        }
        if (this.username != null) {
            runner.setUsername(this.username);
        }
        if (this.password != null) {
            runner.setPassword(this.password);
        }
        if (this.wssPasswordType != null) {
            runner.setWssPasswordType(this.wssPasswordType);
        }
        if (this.domain != null) {
            runner.setDomain(this.domain);
        }
        if (this.host != null) {
            runner.setHost(this.host);
        }
        if (this.outputFolder != null) {
            runner.setOutputFolder(this.outputFolder);
        }
        runner.setPrintReport(this.printReport);
        runner.setExportAll(this.exportAll);
        runner.setJUnitReport(this.junitReport);
        runner.setEnableUI(this.interactive);
        runner.setIgnoreError(this.testFailIgnore);
        runner.setSaveAfterRun(this.saveAfterRun);
        if (this.settingsFile != null) {
            runner.setSettingsFile(this.settingsFile);
        }
        if (this.projectPassword != null) {
            runner.setProjectPassword(this.projectPassword);
        }
        if (this.settingsPassword != null) {
            runner.setSoapUISettingsPassword(this.settingsPassword);
        }
        if (this.globalProperties != null) {
            runner.setGlobalProperties(this.globalProperties);
        }
        if (this.projectProperties != null) {
            runner.setProjectProperties(this.projectProperties);
        }
        if (this.soapuiProperties != null && this.soapuiProperties.size() > 0) {
            for (Object key : this.soapuiProperties.keySet()) {
                System.setProperty((String)key, this.soapuiProperties.getProperty((String)key));
            }
        }
        if (this.securityTest != null && this.securityTest.length() > 0) {
            runner.setSecurityTestName(this.securityTest);
        }
        try {
            runner.run();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.toString());
            throw new MojoFailureException((Object)this, "SoapUI Test(s) failed", e.getMessage());
        }
    }
}

