/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.maven2;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.tools.SoapUIMockServiceRunner;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class MockServiceMojo
extends AbstractMojo {
    private String projectFile;
    private String mockService;
    private String path;
    private String port;
    private String settingsFile;
    private boolean noBlock;
    private boolean skip;
    private String projectPassword;
    private String settingsPassword;
    private String[] globalProperties;
    private String[] projectProperties;
    private boolean saveAfterRun;
    private Properties soapuiProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || System.getProperty("maven.test.skip", "false").equals("true")) {
            return;
        }
        if (this.projectFile == null) {
            throw new MojoExecutionException("soapui-project-file setting is required");
        }
        SoapUIMockServiceRunner runner = new SoapUIMockServiceRunner("SoapUI " + SoapUI.SOAPUI_VERSION + " Maven2 MockService Runner");
        runner.setProjectFile(this.projectFile);
        if (this.mockService != null) {
            runner.setMockService(this.mockService);
        }
        if (this.path != null) {
            runner.setPath(this.path);
        }
        if (this.port != null) {
            runner.setPort(this.port);
        }
        if (this.settingsFile != null) {
            runner.setSettingsFile(this.settingsFile);
        }
        runner.setBlock(!this.noBlock);
        runner.setSaveAfterRun(this.saveAfterRun);
        if (this.projectPassword != null) {
            runner.setProjectPassword(this.projectPassword);
        }
        if (this.settingsPassword != null) {
            runner.setSoapUISettingsPassword(this.settingsPassword);
        }
        if (this.globalProperties != null) {
            runner.setGlobalProperties(this.globalProperties);
        }
        if (this.projectProperties != null) {
            runner.setProjectProperties(this.projectProperties);
        }
        if (this.soapuiProperties != null && this.soapuiProperties.size() > 0) {
            for (Object key : this.soapuiProperties.keySet()) {
                System.out.println("Setting " + (String)key + " value " + this.soapuiProperties.getProperty((String)key));
                System.setProperty((String)key, this.soapuiProperties.getProperty((String)key));
            }
        }
        try {
            runner.run();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.toString());
            throw new MojoFailureException((Object)this, "SoapUI MockService(s) failed", e.getMessage());
        }
    }
}

