/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.xmlencryptionattack.serverbehaviour.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.library.xmlencryptionattack.attackengine.CryptoAttackException;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.util.XMLEncryptionConstants;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.plugin.xmlencryptionattack.XMLEncryptionAttack;
import wsattacker.plugin.xmlencryptionattack.option.OptionServerErrorBehaviour;
import wsattacker.plugin.xmlencryptionattack.serverbehaviour.gui.MultiLinesCellRenderer;
import wsattacker.plugin.xmlencryptionattack.serverbehaviour.gui.OracleResponseTableModel;
import wsattacker.plugin.xmlencryptionattack.serverbehaviour.gui.ResultTableCellRenderer;

public class ServerBehaviourGUI
extends OptionGUI {
    private static final Logger LOG = Logger.getLogger(ServerBehaviourGUI.class);
    private final OptionServerErrorBehaviour m_Option;
    private final XMLEncryptionAttack m_EncryptionPlugin;
    private JProgressBar ServErrMsgProgressBar;
    private JButton btnAbort;
    private JButton btnLoadFile;
    private JButton btnLoadPubKey;
    private JButton btnLoadServerKey;
    private JButton btnNewMsgs;
    private JButton btnSaveFile;
    private JCheckBox cbIgnorePayResponse;
    private JCheckBox cbPKCS1GenWithEncData;
    private JFileChooser chooseLoad;
    private JFileChooser chooseLoadCert;
    private JFileChooser chooseLoadPubKey;
    private JFileChooser chooseSaveFile;
    private JScrollPane jScrollPane1;
    private JLabel lbServerError;
    private JLabel lbTableRows;
    private RTextScrollPane rTextScrollPane1;
    private RTextScrollPane rTextScrollPane2;
    private JSplitPane requestResponseSplitPane;
    private RSyntaxTextArea requestViewer;
    private RSyntaxTextArea responseViewer;
    private JTable tableOracleResponse;
    private JTextField tbRowCount;

    public ServerBehaviourGUI(AbstractPlugin plugin, OptionServerErrorBehaviour option) {
        this.m_EncryptionPlugin = (XMLEncryptionAttack)plugin;
        this.m_Option = option;
        this.initComponents();
        this.initTable();
        this.cbPKCS1GenWithEncData.setEnabled(false);
    }

    private void initComponents() {
        this.chooseLoad = new JFileChooser();
        this.chooseSaveFile = new JFileChooser();
        this.chooseLoadCert = new JFileChooser();
        this.chooseLoadPubKey = new JFileChooser();
        this.jScrollPane1 = new JScrollPane();
        this.tableOracleResponse = new JTable();
        this.tableOracleResponse.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = ServerBehaviourGUI.this.tableOracleResponse.getSelectedRow();
                List<OracleResponse> responseData = ServerBehaviourGUI.this.m_Option.getResponseData();
                if (selectedRow >= 0 && selectedRow < responseData.size()) {
                    String response = responseData.get(selectedRow).getResponse();
                    String request = responseData.get(selectedRow).getRequest();
                    ServerBehaviourGUI.this.requestViewer.setText(request);
                    ServerBehaviourGUI.this.responseViewer.setText(response);
                } else {
                    ServerBehaviourGUI.this.requestViewer.setText("");
                    ServerBehaviourGUI.this.responseViewer.setText("");
                }
            }
        });
        this.btnLoadFile = new JButton();
        this.btnSaveFile = new JButton();
        this.btnNewMsgs = new JButton();
        this.btnLoadServerKey = new JButton();
        this.ServErrMsgProgressBar = new JProgressBar();
        this.lbServerError = new JLabel();
        this.lbTableRows = new JLabel();
        this.tbRowCount = new JTextField();
        this.btnAbort = new JButton();
        this.btnLoadPubKey = new JButton();
        this.cbPKCS1GenWithEncData = new JCheckBox();
        this.cbIgnorePayResponse = new JCheckBox();
        this.requestResponseSplitPane = new JSplitPane();
        this.rTextScrollPane1 = new RTextScrollPane();
        this.requestViewer = new RSyntaxTextArea();
        this.requestViewer.setLineWrap(true);
        this.rTextScrollPane2 = new RTextScrollPane();
        this.responseViewer = new RSyntaxTextArea();
        this.responseViewer.setLineWrap(true);
        this.chooseLoad.setDialogTitle("Load Server Responses");
        FileNameExtensionFilter loadfilter = new FileNameExtensionFilter("XML File", "xml");
        this.chooseLoad.addChoosableFileFilter(loadfilter);
        this.chooseLoad.setFileFilter(loadfilter);
        this.chooseLoad.setFileHidingEnabled(false);
        this.chooseLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.chooseLoadActionPerformed(evt);
            }
        });
        this.chooseSaveFile.setDialogType(1);
        this.chooseSaveFile.setDialogTitle("Save File");
        FileNameExtensionFilter saveFilter = new FileNameExtensionFilter("XML File", "xml");
        this.chooseSaveFile.addChoosableFileFilter(saveFilter);
        this.chooseSaveFile.setFileFilter(saveFilter);
        this.chooseSaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.chooseSaveFileActionPerformed(evt);
            }
        });
        this.chooseLoadCert.setDialogTitle("Load Server Certificate");
        this.chooseLoadCert.setFileHidingEnabled(false);
        this.chooseLoadCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.chooseLoadCertActionPerformed(evt);
            }
        });
        this.chooseLoadPubKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.chooseLoadPubKeyActionPerformed(evt);
            }
        });
        this.tableOracleResponse.setAutoResizeMode(4);
        this.tableOracleResponse.setCellSelectionEnabled(true);
        this.tableOracleResponse.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.tableOracleResponse);
        this.tableOracleResponse.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.btnLoadFile.setText("Load File");
        this.btnLoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.btnLoadFileActionPerformed(evt);
            }
        });
        this.btnSaveFile.setText("Save File");
        this.btnSaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.btnSaveFileActionPerformed(evt);
            }
        });
        this.btnNewMsgs.setText("New Messages");
        this.btnNewMsgs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.btnNewMsgsActionPerformed(evt);
            }
        });
        this.btnLoadServerKey.setText("Load Cert");
        this.btnLoadServerKey.setToolTipText("DER-encoded-binary X.509 or Base-64-encoded X.509 (.CER)");
        this.btnLoadServerKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.btnLoadServerKeyActionPerformed(evt);
            }
        });
        this.lbServerError.setFont(new Font("Tahoma", 1, 18));
        this.lbServerError.setText("Server Error Table:");
        this.lbTableRows.setText("Table Rows:");
        this.tbRowCount.setHorizontalAlignment(0);
        this.btnAbort.setText("Abort");
        this.btnAbort.setEnabled(false);
        this.btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.btnAbortActionPerformed(evt);
            }
        });
        this.btnLoadPubKey.setText("Load Key");
        this.btnLoadPubKey.setEnabled(false);
        this.btnLoadPubKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.btnLoadPubKeyActionPerformed(evt);
            }
        });
        this.cbPKCS1GenWithEncData.setText("<html><p>With EncryptedData</p></html>");
        this.cbPKCS1GenWithEncData.setEnabled(false);
        this.cbPKCS1GenWithEncData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.cbPKCS1GenWithEncDataActionPerformed(evt);
            }
        });
        this.cbIgnorePayResponse.setText("<html><p>Ignore Payload <br>Response</p></html>");
        this.cbIgnorePayResponse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerBehaviourGUI.this.cbIgnorePayResponseActionPerformed(evt);
            }
        });
        this.requestResponseSplitPane.setDividerLocation(150);
        this.requestResponseSplitPane.setOrientation(0);
        this.rTextScrollPane1.setHorizontalScrollBarPolicy(31);
        this.rTextScrollPane1.setFoldIndicatorEnabled(true);
        this.rTextScrollPane1.setHorizontalScrollBar(null);
        this.requestViewer.setEditable(false);
        this.requestViewer.setColumns(20);
        this.requestViewer.setRows(5);
        this.requestViewer.setSyntaxEditingStyle("text/xml");
        this.rTextScrollPane1.setViewportView((Component)this.requestViewer);
        this.requestResponseSplitPane.setTopComponent((Component)this.rTextScrollPane1);
        this.rTextScrollPane2.setHorizontalScrollBarPolicy(31);
        this.rTextScrollPane2.setFoldIndicatorEnabled(true);
        this.rTextScrollPane2.setHorizontalScrollBar(null);
        this.responseViewer.setEditable(false);
        this.responseViewer.setColumns(20);
        this.responseViewer.setRows(5);
        this.responseViewer.setSyntaxEditingStyle("text/xml");
        this.rTextScrollPane2.setViewportView((Component)this.responseViewer);
        this.requestResponseSplitPane.setRightComponent((Component)this.rTextScrollPane2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbServerError).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnNewMsgs, -2, 0, Short.MAX_VALUE).addComponent(this.btnSaveFile, -1, -1, Short.MAX_VALUE).addComponent(this.btnLoadServerKey, -1, -1, Short.MAX_VALUE).addComponent(this.btnLoadPubKey, -1, -1, Short.MAX_VALUE).addComponent(this.cbPKCS1GenWithEncData, -2, 0, Short.MAX_VALUE).addComponent(this.cbIgnorePayResponse).addGroup(layout.createSequentialGroup().addComponent(this.lbTableRows).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbRowCount)).addComponent(this.ServErrMsgProgressBar, -2, 0, Short.MAX_VALUE).addComponent(this.btnAbort, -1, -1, Short.MAX_VALUE)).addComponent(this.btnLoadFile, -2, 145, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 145, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.requestResponseSplitPane, -1, 146, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.btnLoadFile, this.btnSaveFile);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.lbServerError).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.requestResponseSplitPane).addGroup(layout.createSequentialGroup().addComponent(this.btnLoadFile).addGap(7, 7, 7).addComponent(this.btnSaveFile).addGap(7, 7, 7).addComponent(this.btnLoadServerKey).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoadPubKey).addGap(3, 3, 3).addComponent(this.cbIgnorePayResponse, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPKCS1GenWithEncData, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNewMsgs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ServErrMsgProgressBar, -2, 6, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbTableRows).addComponent(this.tbRowCount, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnAbort).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 512, Short.MAX_VALUE)).addGap(20, 20, 20)));
        this.cbIgnorePayResponse.getAccessibleContext().setAccessibleName("<html><p>Ignore Payload Response</p></html>");
    }

    private void btnSaveFileActionPerformed(ActionEvent evt) {
        this.chooseSaveFile.showSaveDialog((Component)((Object)this));
    }

    private void btnNewMsgsActionPerformed(ActionEvent evt) {
        if (this.btnNewMsgs.isEnabled()) {
            if (this.isErrorUserAttackConfiguration()) {
                return;
            }
            this.m_Option.deleteAllErrorTabDatas();
            try {
                this.m_Option.getServerBehaviour();
            }
            catch (IOException | AbstractMethodError | JAXBException | CryptoAttackException ex) {
                LOG.error((Object)ex);
            }
        }
    }

    public boolean isErrorUserAttackConfiguration() throws HeadlessException {
        if (null == this.m_Option.getAttackCfg().getChosenAttackPayload()) {
            JOptionPane.showMessageDialog(null, "Please choose an attack payload.", "No attack payload", 0);
            return true;
        }
        if (this.m_Option.getAttackCfg().getChosenAttackPayload() instanceof EncryptedKeyElement) {
            if (XMLEncryptionConstants.XMLEncryptionAttackMode.PKCS1_ATTACK != this.m_Option.getAttackCfg().getXMLEncryptionAttack()) {
                JOptionPane.showMessageDialog(null, "EncryptedKey attack element but cbc attack mode", "Wrong attack mode", 0);
                return true;
            }
            if (null == this.m_Option.getAttackCfg().getPKCS1AttackCfg().getServerRSAPubKey()) {
                JOptionPane.showMessageDialog(null, "Please set the public key of server!", "Public Key not set", 0);
                return true;
            }
        } else if (this.m_Option.getAttackCfg().getChosenAttackPayload() instanceof EncryptedDataElement && XMLEncryptionConstants.XMLEncryptionAttackMode.CBC_ATTACK != this.m_Option.getAttackCfg().getXMLEncryptionAttack()) {
            JOptionPane.showMessageDialog(null, "EncryptedData attack element but pkcs1 attack mode", "Wrong attack mode", 0);
            return true;
        }
        return false;
    }

    private void btnLoadFileActionPerformed(ActionEvent evt) {
        this.chooseLoad.showOpenDialog((Component)((Object)this));
    }

    private void btnLoadServerKeyActionPerformed(ActionEvent evt) {
        this.chooseLoadCert.showOpenDialog((Component)((Object)this));
    }

    private void chooseLoadActionPerformed(ActionEvent evt) {
        int returnVal = this.chooseLoad.getApproveButtonMnemonic();
        File file = this.chooseLoad.getSelectedFile();
        if (returnVal == 0 && null != file) {
            this.m_Option.LoadDataFromFile(new File(file.getAbsolutePath()));
            this.m_EncryptionPlugin.checkState();
        }
    }

    private void chooseSaveFileActionPerformed(ActionEvent evt) {
        int returnVal = this.chooseSaveFile.getApproveButtonMnemonic();
        File file = this.chooseSaveFile.getSelectedFile();
        if (returnVal == 0 && null != file) {
            try {
                this.m_Option.SaveDataToFile(file);
            }
            catch (IOException | JAXBException ex) {
                LOG.error((Object)ex);
            }
            this.initTable();
        }
    }

    private void chooseLoadCertActionPerformed(ActionEvent evt) {
        int returnVal = this.chooseLoadCert.getApproveButtonMnemonic();
        File file = this.chooseLoadCert.getSelectedFile();
        if (returnVal == 0 && null != file) {
            try {
                this.m_Option.setCertServer(file);
                this.cbPKCS1GenWithEncData.setEnabled(true);
            }
            catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException | InvalidKeySpecException ex) {
                LOG.error((Object)ex);
            }
        }
    }

    private void btnAbortActionPerformed(ActionEvent evt) {
        this.m_Option.stopSendingMessages();
    }

    private void btnLoadPubKeyActionPerformed(ActionEvent evt) {
        this.chooseLoadPubKey.showOpenDialog((Component)((Object)this));
    }

    private void chooseLoadPubKeyActionPerformed(ActionEvent evt) {
        int returnVal = this.chooseLoadPubKey.getApproveButtonMnemonic();
        File file = this.chooseLoadPubKey.getSelectedFile();
        if (returnVal == 0 && null != file) {
            try {
                this.m_Option.setPubKeyServer(file);
                this.cbPKCS1GenWithEncData.setEnabled(true);
            }
            catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException | InvalidKeySpecException ex) {
                LOG.error((Object)ex);
            }
        }
    }

    private void cbPKCS1GenWithEncDataActionPerformed(ActionEvent evt) {
        if (null != this.m_Option && null != this.m_EncryptionPlugin) {
            this.m_Option.setIsPKCS1WithEncData(this.cbPKCS1GenWithEncData.isSelected());
        }
    }

    private void cbIgnorePayResponseActionPerformed(ActionEvent evt) {
        if (null != this.m_Option && null != this.m_EncryptionPlugin) {
            this.m_Option.setIsIgnoreRequestResponse(this.cbIgnorePayResponse.isSelected());
        }
    }

    public void bindingDoUnbind() {
    }

    public AbstractOption getUsedOption() {
        return this.m_Option;
    }

    public void updateProgressBar(int progressStep) {
        this.ServErrMsgProgressBar.setValue(progressStep);
        this.ServErrMsgProgressBar.repaint();
    }

    private void updateRowHeights() {
        int rowCount = this.tableOracleResponse.getRowCount();
        int rowHeight = this.tableOracleResponse.getRowHeight();
        int columnCount = this.tableOracleResponse.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columnCount; ++column) {
                try {
                    Component comp = this.tableOracleResponse.prepareRenderer(this.tableOracleResponse.getCellRenderer(row, column), row, column);
                    rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
                }
                catch (Exception e) {
                    LOG.error((Object)("### Error: This should not happen, catched " + e.getMessage()));
                }
                this.tableOracleResponse.setRowHeight(row, rowHeight);
            }
        }
    }

    private void fixWidth(int columnIndex, int width) {
        TableColumn column = this.tableOracleResponse.getColumnModel().getColumn(columnIndex);
        column.setMinWidth(width);
        column.setMaxWidth(width);
        column.setPreferredWidth(width);
    }

    public void initTable() {
        OracleResponseTableModel oracleResponseTableModel = new OracleResponseTableModel(this.m_Option.getResponseData());
        this.tableOracleResponse.setModel(oracleResponseTableModel);
        this.tableOracleResponse.setDefaultRenderer(String.class, new MultiLinesCellRenderer());
        JComboBox<OracleResponse.Result> resultCombo = new JComboBox<OracleResponse.Result>(OracleResponse.Result.values());
        resultCombo.setRenderer(new ResultTableCellRenderer());
        this.tableOracleResponse.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(resultCombo));
        DefaultTableCellRenderer rend = new DefaultTableCellRenderer();
        this.tableOracleResponse.getColumnModel().getColumn(1).setCellRenderer(rend);
        this.tableOracleResponse.getTableHeader().setReorderingAllowed(false);
        this.fixWidth(0, 40);
        this.fixWidth(1, 100);
        this.tbRowCount.setText(String.valueOf(this.tableOracleResponse.getRowCount()));
        this.requestViewer.setText("");
        this.responseViewer.setText("");
    }

    public void updateTable(OracleResponse oracResp) {
        OracleResponseTableModel tabModel = (OracleResponseTableModel)this.tableOracleResponse.getModel();
        tabModel.update();
        this.tbRowCount.setText(String.valueOf(this.tableOracleResponse.getRowCount()));
        this.fixWidth(0, 40);
        this.fixWidth(1, 100);
    }

    public void setBtnsState(boolean state) {
        this.btnNewMsgs.setEnabled(state);
        this.btnLoadFile.setEnabled(state);
        this.btnSaveFile.setEnabled(state);
        this.btnLoadServerKey.setEnabled(state);
        this.btnAbort.setEnabled(!state);
        if (state) {
            this.m_EncryptionPlugin.checkState();
            this.ServErrMsgProgressBar.setValue(0);
        }
    }
}

