/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.xmlencryptionattack.serverbehaviour.gui;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;

public class OracleResponseTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Row", "Oracle Result"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Integer.TYPE, OracleResponse.Result.class};
    protected static final int COLUMN_IDX_ROW = 0;
    protected static final int COLUMN_IDX_ORACLERESULT = 1;
    private final List<OracleResponse> m_Responses;

    public OracleResponseTableModel(List<OracleResponse> responses) {
        this.m_Responses = responses;
    }

    @Override
    public int getRowCount() {
        return this.m_Responses.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OracleResponse response = this.m_Responses.get(rowIndex);
        if (0 == columnIndex) {
            return rowIndex + 1;
        }
        if (1 == columnIndex) {
            return response.getResult();
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        OracleResponse response = this.m_Responses.get(rowIndex);
        if (1 == columnIndex) {
            response.setResult((OracleResponse.Result)value);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return 1 == columnIndex;
    }

    public void addResponse(OracleResponse oracResp) {
        this.m_Responses.add(oracResp);
        this.fireTableDataChanged();
    }

    public void update() {
        this.fireTableRowsInserted(0, this.m_Responses.size());
    }
}

