/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.testsuite;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.Submit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdesktop.beans.AbstractBean;
import wsattacker.main.Preferences;
import wsattacker.main.composition.testsuite.CurrentRequestContentChangeObserver;
import wsattacker.main.composition.testsuite.CurrentRequestObserver;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.testsuite.CurrentOperation;

public class CurrentRequest
extends AbstractBean
implements PropertyChangeListener,
RequestResponsePair {
    private static final Logger LOG = Logger.getLogger(CurrentRequest.class);
    public static final String BASICREQUSTNAME = "Basic Request";
    public static final String PROP_WSDLREQUESTCONTENT = "wsdlRequestContent";
    public static final String PROP_WSDLRESPONSECONTENT = "wsdlResponseContent";
    public static final String PROP_WSDLREQUEST = "wsdlRequest";
    public static final String PROP_WSDLRESPONSE = "wsdlResponse";
    private static final String PROP_SOAPUI_REQUEST_CONTENT = "request";
    private WsdlRequest wsdlRequest;
    private WsdlResponse wsdlResponse;
    private CurrentOperation currentOperation;
    private final List<CurrentRequestObserver> requestObservers = new ArrayList<CurrentRequestObserver>();
    private final List<CurrentRequestContentChangeObserver> contentObservers = new ArrayList<CurrentRequestContentChangeObserver>();

    public CurrentOperation getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(CurrentOperation newCurrentOperation) {
        CurrentOperation oldOperation = this.currentOperation;
        if (oldOperation != null) {
            oldOperation.removePropertyChangeListener(this);
        }
        this.currentOperation = newCurrentOperation;
        if (newCurrentOperation != null) {
            newCurrentOperation.addPropertyChangeListener("wsdlOperation", this);
        }
    }

    @Override
    public WsdlRequest getWsdlRequest() {
        return this.wsdlRequest;
    }

    public void setWsdlRequest(WsdlRequest newWsdlRequest) {
        WsdlRequest oldWsdlRequest = this.wsdlRequest;
        String oldWsdlRequestContent = "";
        if (oldWsdlRequest != null) {
            oldWsdlRequest.removePropertyChangeListener(PROP_SOAPUI_REQUEST_CONTENT, this);
            oldWsdlRequestContent = oldWsdlRequest.getRequestContent();
        }
        if (newWsdlRequest != null) {
            newWsdlRequest.addPropertyChangeListener(PROP_SOAPUI_REQUEST_CONTENT, this);
        }
        this.wsdlRequest = newWsdlRequest;
        String newWsdlRequestContent = this.getWsdlRequestContent();
        this.firePropertyChange(PROP_WSDLREQUEST, oldWsdlRequest, newWsdlRequest);
        this.firePropertyChange(PROP_WSDLREQUESTCONTENT, oldWsdlRequestContent, newWsdlRequestContent);
        this.notifyCurrentRequestObservers(newWsdlRequest, oldWsdlRequest);
        this.notifyCurrentRequestContentObservers(newWsdlRequestContent, oldWsdlRequestContent);
    }

    @Override
    public WsdlResponse getWsdlResponse() {
        return this.wsdlResponse;
    }

    public void setWsdlResponse(WsdlResponse newWsdlResponse) {
        WsdlResponse oldWsdlResponse = this.wsdlResponse;
        String oldWsdlResponseContent = this.getWsdlResponseContent();
        this.wsdlResponse = newWsdlResponse;
        String newWsdlResponseContent = this.getWsdlResponseContent();
        this.firePropertyChange(PROP_WSDLRESPONSE, oldWsdlResponse, newWsdlResponse);
        this.firePropertyChange(PROP_WSDLRESPONSECONTENT, oldWsdlResponseContent, newWsdlResponseContent);
    }

    public String getWsdlResponseContent() {
        String wsdlResponseContent = this.wsdlResponse != null ? this.wsdlResponse.getContentAsString() : "";
        return wsdlResponseContent;
    }

    public String getWsdlRequestContent() {
        String wsdlRequestContent = this.wsdlRequest != null ? this.wsdlRequest.getRequestContent() : "";
        return wsdlRequestContent;
    }

    public void setWsdlRequestContent(String wsdlRequestContent) {
        if (this.wsdlRequest != null) {
            this.wsdlRequest.setRequestContent(wsdlRequestContent);
        }
    }

    public void submitRequest() throws Request.SubmitException, NullPointerException {
        if (this.wsdlRequest == null) {
            throw new NullPointerException("There is no request to submit");
        }
        WsdlSubmitContext c = new WsdlSubmitContext(this.wsdlRequest);
        Submit submit = this.wsdlRequest.submit(c, false);
        Response response = ((WsdlSubmit)submit).getResponse();
        if (response instanceof WsdlResponse) {
            this.setWsdlResponse((WsdlResponse)response);
            this.wsdlRequest.setResponse(this.wsdlResponse, c);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if ("wsdlOperation".equals(propName)) {
            LOG.info("Detected Operation change");
            WsdlOperation wsdlOperation = (WsdlOperation)pce.getNewValue();
            WsdlRequest request = null;
            if (wsdlOperation != null && (request = wsdlOperation.getRequestByName(BASICREQUSTNAME)) == null) {
                LOG.info("Creating basic request");
                request = wsdlOperation.addNewRequest(BASICREQUSTNAME);
                String content = wsdlOperation.createRequest(Preferences.getInstance().isCreateOptionalElements());
                LOG.trace("Content:\n" + content);
                request.setRequestContent(content);
            }
            this.setWsdlRequest(request);
        } else if (PROP_SOAPUI_REQUEST_CONTENT.equals(propName)) {
            LOG.info("Current Request Content chaged!");
            String newValue = (String)pce.getNewValue();
            String oldValue = (String)pce.getOldValue();
            this.firePropertyChange(PROP_WSDLREQUESTCONTENT, oldValue, newValue);
            this.notifyCurrentRequestContentObservers(newValue, oldValue);
        }
    }

    @Deprecated
    public void addCurrentRequestObserver(CurrentRequestObserver o) {
        this.requestObservers.add(o);
    }

    @Deprecated
    public void removeCurrentRequestObserver(CurrentRequestObserver o) {
        this.requestObservers.remove(o);
    }

    @Deprecated
    private void notifyCurrentRequestObservers(WsdlRequest newRequest, WsdlRequest oldRequest) {
        block4: {
            if (oldRequest == newRequest) break block4;
            if (newRequest == null) {
                for (CurrentRequestObserver o : this.requestObservers) {
                    o.noCurrentRequest();
                }
            } else {
                for (CurrentRequestObserver o : this.requestObservers) {
                    o.currentRequestChanged(newRequest, oldRequest);
                }
            }
        }
    }

    @Deprecated
    public void addCurrentRequestContentObserver(CurrentRequestContentChangeObserver o) {
        this.contentObservers.add(o);
    }

    @Deprecated
    public void removeCurrentRequestContentObserver(CurrentRequestContentChangeObserver o) {
        this.contentObservers.remove(o);
    }

    @Deprecated
    private void notifyCurrentRequestContentObservers(String newContent, String oldContent) {
        for (CurrentRequestContentChangeObserver o : this.contentObservers) {
            o.currentRequestContentChanged(newContent, oldContent);
        }
    }
}

