/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.plugin.option;

import wsattacker.main.composition.plugin.option.AbstractOptionVarchar;

public class OptionSimpleVarchar
extends AbstractOptionVarchar {
    private static final long serialVersionUID = 1L;
    public static final String PROP_MAXLENGTH = "maxLength";
    private int maxLength;

    public OptionSimpleVarchar(String name, String value) {
        super(name, value, 0);
        this.maxLength = 0;
    }

    public OptionSimpleVarchar(String name, String value, String description) {
        super(name, value, description, 0);
        this.maxLength = 0;
    }

    public OptionSimpleVarchar(String name, String value, int maxLength) {
        super(name, value, maxLength);
        this.maxLength = maxLength;
    }

    public OptionSimpleVarchar(String name, String value, String description, int maxLength) {
        super(name, value, description, maxLength);
        this.maxLength = maxLength;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public boolean isValid(String value) {
        boolean result = true;
        if (value.contains("\n")) {
            result = false;
        }
        if (this.maxLength > 0 && value.length() > this.maxLength) {
            result = false;
        }
        return result;
    }

    @Override
    public void setMaxLength(int maxLength) {
        int oldMaxLength = this.maxLength;
        this.maxLength = maxLength;
        this.firePropertyChange(PROP_MAXLENGTH, oldMaxLength, maxLength);
    }
}

