/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdesktop.beans.AbstractBean;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.option.AbstractOption;

public class PluginOptionContainer
extends AbstractBean
implements Iterable<AbstractOption>,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = Logger.getLogger(PluginOptionContainer.class);
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_OWNERPLUGIN = "ownerPlugin";
    private List<AbstractOption> options = new ArrayList<AbstractOption>();
    private AbstractPlugin ownerPlugin;

    public PluginOptionContainer() {
    }

    public PluginOptionContainer(AbstractPlugin ownerPlugin) {
        this();
        this.ownerPlugin = ownerPlugin;
    }

    public AbstractPlugin getOwnerPlugin() {
        return this.ownerPlugin;
    }

    public void setOwnerPlugin(AbstractPlugin ownerPlugin) {
        AbstractPlugin oldOwnerPlugin = this.ownerPlugin;
        this.ownerPlugin = ownerPlugin;
        this.firePropertyChange(PROP_OWNERPLUGIN, oldOwnerPlugin, ownerPlugin);
    }

    public List<AbstractOption> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public synchronized void setOptions(List<AbstractOption> options) {
        this.synchronizeCollectionForAllPlugins(options);
        ArrayList<AbstractOption> oldOptions = new ArrayList<AbstractOption>(this.options);
        this.options = new ArrayList<AbstractOption>(options);
        List<AbstractOption> newOptions = this.getOptions();
        this.fireIndexedPropertyChange(PROP_OPTIONS, 0, oldOptions, newOptions);
    }

    public AbstractOption getOptions(int index) {
        return this.options.get(index);
    }

    public synchronized void setOptions(int index, AbstractOption newOption) {
        AbstractOption oldOption = this.options.set(index, newOption);
        this.fireIndexedPropertyChange(PROP_OPTIONS, index, oldOption, newOption);
    }

    public void add(AbstractOption option) {
        this.add(this.options.size(), option);
    }

    public synchronized void add(int position, AbstractOption option) {
        AbstractOption search = this.getByName(option.getName());
        if (search != null) {
            LOG.warn("Trying to add an option with an existing name... option not added! Please consult the plugin maintainer!");
        } else {
            ArrayList<AbstractOption> oldOptions = new ArrayList<AbstractOption>(this.options);
            this.options.add(position, option);
            option.setCollection(this);
            List<AbstractOption> newOptions = this.getOptions();
            this.fireIndexedPropertyChange(PROP_OPTIONS, position, oldOptions, newOptions);
        }
    }

    public synchronized void remove(AbstractOption option) {
        if (this.options.contains(option)) {
            int position = this.indexOf(option);
            ArrayList<AbstractOption> oldOptions = new ArrayList<AbstractOption>(this.options);
            this.options.remove(option);
            List<AbstractOption> newOptions = this.getOptions();
            option.setCollection(null);
            this.fireIndexedPropertyChange(PROP_OPTIONS, position, oldOptions, newOptions);
        }
    }

    public boolean contains(AbstractOption o) {
        return this.options.contains(o);
    }

    public synchronized void clear() {
        ArrayList<AbstractOption> oldOptions = new ArrayList<AbstractOption>(this.options);
        this.options.clear();
        List<AbstractOption> newOptions = this.getOptions();
        this.fireIndexedPropertyChange(PROP_OPTIONS, 0, oldOptions, newOptions);
    }

    public AbstractOption getByIndex(int index) {
        return this.getOptions(index);
    }

    public AbstractOption getByName(String name) {
        AbstractOption result = null;
        for (AbstractOption option : this.options) {
            if (!option.getName().equals(name)) continue;
            result = option;
        }
        return result;
    }

    public int indexOf(AbstractOption option) {
        return this.options.indexOf(option);
    }

    public int size() {
        return this.options.size();
    }

    @Override
    public Iterator<AbstractOption> iterator() {
        return this.options.iterator();
    }

    public AbstractOption[] getOptionArray() {
        return this.options.toArray(new AbstractOption[0]);
    }

    private void synchronizeCollectionForAllPlugins(List<AbstractOption> newOptions) {
        for (AbstractOption o : newOptions) {
            if (this.options.contains(o)) continue;
            o.setCollection(this);
        }
        for (AbstractOption o : this.options) {
            if (newOptions.contains(o)) continue;
            o.setCollection(null);
        }
    }
}

