/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.composition.plugin.option;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.gui.component.pluginconfiguration.option.OptionMultiFileGUI_NB;
import wsattacker.main.composition.plugin.option.AbstractOption;

public abstract class AbstractOptionMultiFiles
extends AbstractOption {
    public static final String PROP_FILES = "files";
    List<File> files = new ArrayList<File>();

    protected AbstractOptionMultiFiles(String name, String description) {
        super(name, description);
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public String getShortValueAsString() {
        StringBuilder buf = new StringBuilder();
        for (File f : this.files) {
            buf.append(f.getName()).append(", ");
        }
        if (buf.length() > 2) {
            buf.delete(buf.length() - 2, buf.length());
        }
        return buf.toString();
    }

    @Override
    public String getValueAsString() {
        StringBuilder buf = new StringBuilder();
        for (File f : this.files) {
            buf.append(f.toString()).append(", ");
        }
        if (buf.length() > 2) {
            buf.delete(buf.length() - 2, buf.length());
        }
        return buf.toString();
    }

    public abstract boolean isValid(File var1);

    public boolean isValid(File[] files) {
        boolean valid = true;
        for (File f : files) {
            if (this.isValid(f)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Override
    public boolean isValid(String value) {
        String[] values;
        boolean valid = true;
        for (String name : values = value.split(", ")) {
            try {
                new File(name);
            }
            catch (Exception e) {
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public void parseValue(String value) {
        String[] values = value.split(", ");
        this.files = new ArrayList<File>();
        for (String name : values) {
            try {
                this.files.add(new File(name));
            }
            catch (Exception e) {
                this.files.clear();
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void setFiles(List<File> files) {
        List<File> oldFiles = this.files;
        this.files = files;
        this.firePropertyChange(PROP_FILES, oldFiles, files);
    }

    public void setFilesAsArray(File[] files) {
        this.setFiles(Arrays.asList(files));
    }

    @Override
    public OptionGUI createOptionGUI() {
        return new OptionMultiFileGUI_NB(this);
    }
}

