/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.composition.plugin;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jdesktop.beans.AbstractBean;
import wsattacker.main.composition.plugin.PluginFunctionInterface;
import wsattacker.main.composition.plugin.PluginObserver;
import wsattacker.main.composition.plugin.SuccessInterface;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.plugin.PluginOptionContainer;
import wsattacker.main.plugin.PluginState;
import wsattacker.main.plugin.result.Result;
import wsattacker.main.plugin.result.ResultEntry;
import wsattacker.main.plugin.result.ResultLevel;
import wsattacker.main.testsuite.CurrentRequest;
import wsattacker.main.testsuite.TestSuite;

public abstract class AbstractPlugin
extends AbstractBean
implements SuccessInterface,
Comparable<AbstractPlugin>,
Serializable {
    private static final long serialVersionUID = 3L;
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_CATEGORY = "category";
    public static final String PROP_CURRENT_POINTS = "currentPoints";
    public static final String PROP_MAXPOINTS = "maxPoints";
    public static final String PROP_STATE = "state";
    public static final String PROP_VERSION = "version";
    public static final String PROP_AUTHOR = "author";
    public static final String PROP_PLUGINFUNCTIONS = "pluginFunctions";
    public static final String PROP_ICON = "icon";
    private final PluginOptionContainer options;
    private final transient Set<PluginObserver> observers;
    private final transient Logger LOG;
    private String name = "Default Abstract Plugin Name";
    private String description = "";
    private ImageIcon icon = null;
    private String[] category = new String[]{"Uncategorized"};
    private int currentPoints = 0;
    private int maxPoints = 100;
    private PluginState state;
    private String version = "1.0";
    private String author = "Author Name";
    private PluginFunctionInterface[] pluginFunctions = new PluginFunctionInterface[0];

    public AbstractPlugin() {
        this.state = PluginState.Not_Configured;
        this.options = new PluginOptionContainer(this);
        this.observers = new HashSet<PluginObserver>();
        this.LOG = Logger.getLogger(this.getClass());
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        ImageIcon oldIcon = this.icon;
        this.icon = icon;
        this.firePropertyChange(PROP_ICON, oldIcon, icon);
    }

    public void setMaxPoints(int maxPoints) {
        int oldMaxPoints = this.maxPoints;
        this.maxPoints = maxPoints;
        this.firePropertyChange(PROP_MAXPOINTS, oldMaxPoints, maxPoints);
    }

    public abstract void initializePlugin();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(PROP_NAME, oldName, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldDescription = this.description;
        this.description = description;
        this.firePropertyChange(PROP_DESCRIPTION, oldDescription, description);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        String oldAuthor = this.author;
        this.author = author;
        this.firePropertyChange(PROP_AUTHOR, oldAuthor, author);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        String oldVersion = this.version;
        this.version = version;
        this.firePropertyChange(PROP_VERSION, oldVersion, version);
    }

    public final PluginOptionContainer getPluginOptions() {
        return this.options;
    }

    @Override
    public int getMaxPoints() {
        return this.maxPoints;
    }

    @Override
    public final int getCurrentPoints() {
        return this.currentPoints;
    }

    protected final void setCurrentPoints(int currentPoints) {
        if (currentPoints <= this.getMaxPoints()) {
            int oldCurrentPoints = this.currentPoints;
            this.currentPoints = currentPoints;
            this.firePropertyChange(PROP_CURRENT_POINTS, oldCurrentPoints, currentPoints);
            this.notifyCurrentPointsChanged(currentPoints);
        }
    }

    protected final void addOnePoint() {
        this.setCurrentPoints(this.getCurrentPoints() + 1);
    }

    public final PluginState getState() {
        return this.state;
    }

    protected final void setState(PluginState state) {
        if (this.state != state) {
            PluginState oldState = this.state;
            this.state = state;
            this.firePropertyChange(PROP_STATE, (Object)oldState, (Object)state);
            this.notifyPluginStateChagend(state, oldState);
        }
    }

    protected final Logger log() {
        return this.LOG;
    }

    protected final void result(ResultLevel level, String content) {
        Result.getGlobalResult().add(new ResultEntry(level, this.getName(), content));
        this.LOG.log(Level.INFO, content);
    }

    protected final void critical(String content) {
        this.result(ResultLevel.Critical, content);
    }

    protected final void important(String content) {
        this.result(ResultLevel.Important, content);
    }

    protected final void info(String content) {
        this.result(ResultLevel.Info, content);
    }

    protected final void trace(String content) {
        this.result(ResultLevel.Trace, content);
    }

    public final boolean isRunning() {
        return this.state == PluginState.Running;
    }

    public final boolean isReady() {
        return this.state == PluginState.Ready;
    }

    public final boolean isFinished() {
        return this.state == PluginState.Finished;
    }

    public final boolean isFailed() {
        return this.state == PluginState.Failed;
    }

    public final boolean isAborting() {
        return this.state == PluginState.Aborting;
    }

    public final boolean isStopped() {
        return this.state == PluginState.Stopped;
    }

    public final boolean startAttack() {
        Logger log = Logger.getLogger(this.getClass());
        CurrentRequest original = TestSuite.getInstance().getCurrentRequest();
        if (!this.isReady()) {
            log.warn(this.getName() + " is not READY");
            return false;
        }
        if (original.getWsdlRequest() == null) {
            log.warn("There is no current request!");
            return false;
        }
        if (original.getWsdlResponse() == null) {
            log.warn("There is no current response!");
            return false;
        }
        this.clean();
        this.setState(PluginState.Running);
        this.attackImplementationHook(original);
        if (this.isRunning()) {
            this.setState(PluginState.Finished);
        }
        return this.wasSuccessful();
    }

    protected abstract void attackImplementationHook(RequestResponsePair var1);

    public abstract void clean();

    public final void abortAttack() {
        this.setState(PluginState.Aborting);
    }

    public final void stopAttack() {
        this.stopHook();
        this.setState(PluginState.Stopped);
    }

    protected void stopHook() {
    }

    @Override
    public abstract boolean wasSuccessful();

    public PluginFunctionInterface[] getPluginFunctions() {
        return this.pluginFunctions;
    }

    public void setPluginFunctions(PluginFunctionInterface[] pluginFunctions) {
        PluginFunctionInterface[] oldPluginFunctions = this.pluginFunctions;
        this.pluginFunctions = pluginFunctions;
        this.firePropertyChange(PROP_PLUGINFUNCTIONS, oldPluginFunctions, pluginFunctions);
    }

    public PluginFunctionInterface getPluginFunctions(int index) {
        return this.pluginFunctions[index];
    }

    public void setPluginFunctions(int index, PluginFunctionInterface newPluginFunctions) {
        PluginFunctionInterface oldPluginFunctions = this.pluginFunctions[index];
        this.pluginFunctions[index] = newPluginFunctions;
        this.fireIndexedPropertyChange(PROP_PLUGINFUNCTIONS, index, oldPluginFunctions, newPluginFunctions);
    }

    public final void addPluginObserver(PluginObserver o) {
        this.observers.add(o);
    }

    public final void removePluginObserver(PluginObserver o) {
        this.observers.remove(o);
    }

    private void notifyCurrentPointsChanged(int points) {
        for (PluginObserver o : this.observers) {
            o.currentPointsChanged(this, points);
        }
    }

    private void notifyPluginStateChagend(PluginState newState, PluginState oldState) {
        for (PluginObserver o : this.observers) {
            o.pluginStateChanged(this, newState, oldState);
        }
    }

    public void restoreConfiguration(AbstractPlugin plugin) {
        for (AbstractOption savedOption : plugin.getPluginOptions()) {
            AbstractOption currentOption = this.getPluginOptions().getByName(savedOption.getName());
            String savedValue = savedOption.getValueAsString();
            if (currentOption != null) {
                if (currentOption.isValid(savedValue)) {
                    currentOption.parseValue(savedValue);
                    Logger.getLogger(this.getClass()).info(String.format("Restored option %s=%s", savedOption.getName(), savedOption.getValueAsString()));
                    continue;
                }
                Logger.getLogger(this.getClass()).info("Could not restore Value '" + savedValue + "' for Option '" + savedOption.getName() + "' - The value is not valid!");
                continue;
            }
            Logger.getLogger(this.getClass()).error("The Option '" + savedOption.getName() + "' is not present in this plugin. Contact the plugin author.");
        }
    }

    public String[] getCategory() {
        return this.category;
    }

    public void setCategory(String[] category) {
        String[] oldCategory = this.category;
        this.category = category;
        this.firePropertyChange(PROP_CATEGORY, oldCategory, category);
    }

    public String getCategory(int index) {
        return this.category[index];
    }

    public void setCategory(int index, String newCategory) {
        String oldCategory = this.category[index];
        this.category[index] = newCategory;
        this.fireIndexedPropertyChange(PROP_CATEGORY, index, oldCategory, newCategory);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof AbstractPlugin) {
            result = ((AbstractPlugin)o).getName().equals(this.getName());
        }
        return result;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(AbstractPlugin p) {
        return this.getName().compareTo(p.getName());
    }

    public String toString() {
        return this.getName();
    }
}

