/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.composition;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    protected EventListenerList listeners = new EventListenerList();

    protected AbstractTreeModel() {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;
        int count = this.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            result = i;
        }
        return result;
    }

    protected void fireNewRoot() {
        Object[] pairs = this.listeners.getListenerList();
        Object root = this.getRoot();
        TreePath path = root != null ? new TreePath(root) : null;
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, null, null);
            }
            ((TreeModelListener)pairs[i + 1]).treeStructureChanged(e);
        }
    }

    protected void fireStructureChanged() {
        this.fireTreeStructureChanged(new TreePath(this.getRoot()));
    }

    protected void firePathLeafStateChanged(TreePath path) {
        this.fireTreeStructureChanged(path);
    }

    protected void fireTreeStructureChanged(TreePath parentPath) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, parentPath, null, null);
            }
            ((TreeModelListener)pairs[i + 1]).treeStructureChanged(e);
        }
    }

    protected void firePathChanged(TreePath path) {
        Object node = path.getLastPathComponent();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            this.fireChildrenChanged(path, null, null);
        } else {
            Object parent = parentPath.getLastPathComponent();
            this.fireChildChanged(parentPath, this.getIndexOfChild(parent, node), node);
        }
    }

    protected void fireChildAdded(TreePath parentPath, int index, Object child) {
        this.fireChildrenAdded(parentPath, new int[]{index}, new Object[]{child});
    }

    protected void fireChildChanged(TreePath parentPath, int index, Object child) {
        this.fireChildrenChanged(parentPath, new int[]{index}, new Object[]{child});
    }

    protected void fireChildRemoved(TreePath parentPath, int index, Object child) {
        this.fireChildrenRemoved(parentPath, new int[]{index}, new Object[]{child});
    }

    protected void fireChildrenAdded(TreePath parentPath, int[] indices, Object[] children) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, parentPath, indices, children);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireChildrenChanged(TreePath parentPath, int[] indices, Object[] children) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, parentPath, indices, children);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireChildrenRemoved(TreePath parentPath, int[] indices, Object[] children) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, parentPath, indices, children);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesRemoved(e);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractTreeModel clone = (AbstractTreeModel)super.clone();
        clone.listeners = new EventListenerList();
        return clone;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }
}

