/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.subcomponent;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.apache.log4j.Logger;
import wsattacker.gui.component.pluginconfiguration.subcomponent.PluginTreeCellRenderer;
import wsattacker.gui.component.pluginconfiguration.subcomponent.PluginTreeModel;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.util.Category;

public class PluginTree
extends CheckboxTree {
    private static final Logger LOG = Logger.getLogger(PluginTree.class);
    private static final long serialVersionUID = 1L;
    public static final String PROP_CONTROLLER = "controller";
    private ControllerInterface controller;
    private final PluginTreeModel model;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public PluginTree(ControllerInterface controller) {
        this.controller = controller;
        this.model = new PluginTreeModel();
        this.setRootVisible(false);
        PluginTreeCellRenderer cellRenderer = new PluginTreeCellRenderer();
        cellRenderer.setPluginTree(this);
        this.setCellRenderer(cellRenderer);
        this.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_CHECK);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeCheckingListener(new TreeCheckingListener(){

            @Override
            public void valueChanged(TreeCheckingEvent e) {
                LOG.info(String.format("PluginTree value changed: " + e.toString(), new Object[0]));
                Object o = e.getPath().getLastPathComponent();
                if (o instanceof AbstractPlugin) {
                    PluginTree.this.getController().setPluginActive(((AbstractPlugin)o).getName(), e.isCheckedPath());
                } else if (o.getClass().isAssignableFrom(PluginTree.this.getModel().getRoot().getClass())) {
                    Object node = PluginTree.this.getModel().getRoot();
                    Object[] path = e.getPath().getPath();
                    for (int i = 1; i < path.length; ++i) {
                        node = PluginTree.this.getModel().getChild(node, PluginTree.this.getModel().getIndexOfChild(node, path[i]));
                    }
                    if (node instanceof Category) {
                        Category category = (Category)node;
                        List list = category.getLeafsRecursive();
                        for (AbstractPlugin plugin : list) {
                            PluginTree.this.getController().setPluginActive(plugin.getName(), e.isCheckedPath());
                        }
                    }
                }
                PluginTree.this.repaint();
            }
        });
    }

    public ControllerInterface getController() {
        return this.controller;
    }

    public void setController(ControllerInterface controller) {
        ControllerInterface oldController = this.controller;
        this.controller = controller;
        this.propertyChangeSupport.firePropertyChange(PROP_CONTROLLER, oldController, controller);
    }

    @Override
    public PluginTreeModel getModel() {
        return this.model;
    }
}

