/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.option;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionFile;
import wsattacker.main.plugin.option.OptionSimpleFile;

public class OptionFileGUI_NB
extends OptionGUI {
    private AbstractOptionFile option = new OptionSimpleFile("Sample File Option", "Sample File Description");
    public static final String PROP_OPTION = "option";
    private JLabel currentFileLabel;
    private JLabel currentFileValue;
    private JLabel description;
    private JButton fileButton;
    private JFileChooser fileChooser;
    private JLabel name;
    private JLabel typeLabel;
    private JLabel typeValue;
    private BindingGroup bindingGroup;

    public AbstractOptionFile getOption() {
        return this.option;
    }

    public void setOption(AbstractOptionFile option) {
        AbstractOptionFile oldOption = this.option;
        this.option = option;
        this.firePropertyChange(PROP_OPTION, oldOption, option);
    }

    public OptionFileGUI_NB() {
        this.initComponents();
    }

    public OptionFileGUI_NB(AbstractOptionFile option) {
        this.option = option;
        this.initComponents();
    }

    private void setValueBackgroundIfError(boolean error) {
        if (error) {
            this.fileButton.setBackground(COLOR_ERROR);
        } else {
            this.fileButton.setBackground(COLOR_OK);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.fileChooser = new JFileChooser();
        this.name = new JLabel();
        this.description = new JLabel();
        this.currentFileLabel = new JLabel();
        this.currentFileValue = new JLabel();
        this.typeLabel = new JLabel();
        this.typeValue = new JLabel();
        this.fileButton = new JButton();
        this.fileChooser.setDialogTitle("Select the File");
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return OptionFileGUI_NB.this.getOption().getDescription();
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return OptionFileGUI_NB.this.getOption().isValid(f);
            }
        });
        this.name.setFont(new Font("Dialog", 1, 18));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.name}"), this.name, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Name");
        binding.setSourceUnreadableValue("Option Name");
        this.bindingGroup.addBinding(binding);
        this.description.setFont(new Font("Dialog", 0, 12));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.description}"), this.description, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Description");
        binding.setSourceUnreadableValue("Option Description");
        this.bindingGroup.addBinding(binding);
        this.currentFileLabel.setFont(new Font("Dialog", 0, 12));
        this.currentFileLabel.setText("Current File:");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${option.file}"), this.currentFileValue, BeanProperty.create("text"), this.option.getName());
        binding.setConverter(new Converter<File, String>(){

            @Override
            public String convertForward(File value) {
                return String.format("%s", value.getName());
            }

            @Override
            public File convertReverse(String value) {
                return new File(value);
            }
        });
        this.bindingGroup.addBinding(binding);
        this.typeLabel.setFont(new Font("Dialog", 0, 12));
        this.typeLabel.setText("Type:");
        this.typeValue.setText("File");
        this.fileButton.setText("Select a File");
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFileGUI_NB.this.fileButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name).addComponent(this.description).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentFileValue)).addComponent(this.fileButton)).addContainerGap(132, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.name).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.currentFileLabel).addComponent(this.currentFileValue).addComponent(this.typeLabel).addComponent(this.typeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.description).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            boolean valid = this.option.isValid(file);
            this.setValueBackgroundIfError(!valid);
            if (valid) {
                this.option.setFile(file);
            }
        }
    }

    @Override
    public void bindingDoUnbind() {
        this.bindingGroup.unbind();
    }

    @Override
    public AbstractOption getUsedOption() {
        return this.option;
    }
}

