/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.attackoverview.subcomponent;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import wsattacker.gui.util.CenteredTableCellRenderer;
import wsattacker.gui.util.ColoredResultTableCellRenderer;
import wsattacker.gui.util.MultiLineTableCellRenderer;
import wsattacker.main.composition.ResultObserver;
import wsattacker.main.plugin.result.Result;
import wsattacker.main.plugin.result.ResultEntry;
import wsattacker.main.plugin.result.ResultLevel;
import wsattacker.util.DateFormater;

public class ResultTable
extends JTable {
    private static final long serialVersionUID = 1L;
    ResultTableModel model;
    JTable table = this;

    public ResultTable() {
        this.model = new ResultTableModel();
        this.setModel(this.model);
        this.setAutoscrolls(true);
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.getColumnModel().getColumn(3).setPreferredWidth(500);
        this.getColumnModel().getColumn(0).setCellRenderer(new CenteredTableCellRenderer());
        this.getColumnModel().getColumn(1).setCellRenderer(new ColoredResultTableCellRenderer());
        this.getColumnModel().getColumn(2).setCellRenderer(new CenteredTableCellRenderer());
        this.getColumnModel().getColumn(3).setCellRenderer(new MultiLineTableCellRenderer());
    }

    public void filterSources(List<String> sources) {
        this.model.filterSources(sources);
    }

    public void setLevel(ResultLevel level) {
        this.model.setLevel(level);
    }

    public class ResultTableModel
    extends AbstractTableModel
    implements ResultObserver {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{"Time", "Level", "Source", "Content"};
        Result global;
        Result result = new Result();
        ResultLevel level;
        List<String> sources;

        public ResultTableModel() {
            this.global = Result.getGlobalResult();
            this.global.registerObserver(this);
            this.level = ResultLevel.Important;
            this.global.setObserverLevel(this, this.level);
            this.sources = new ArrayList<String>();
        }

        public void setLevel(ResultLevel level) {
            this.level = level;
            this.result = this.global.filterOnly(level);
            if (this.sources.size() > 0) {
                this.result = this.result.filterOnly(this.sources);
            }
            this.global.setObserverLevel(this, level);
            this.fireTableDataChanged();
        }

        public void filterSources(List<String> sources) {
            this.sources = sources;
            this.result = this.global.filterOnly(this.level);
            if (sources.size() > 0) {
                this.result = this.result.filterOnly(sources);
            }
            this.global.setSources(this, sources);
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int num) {
            return this.columnNames[num];
        }

        @Override
        public boolean isCellEditable(int y, int x) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.result.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ResultEntry entry = this.result.get(row);
            switch (col) {
                case 0: {
                    return DateFormater.timeonly(entry.getDate());
                }
                case 1: {
                    return entry.getLevel().toString();
                }
                case 2: {
                    return entry.getSource();
                }
                case 3: {
                    return entry.getContent();
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void logUpdate(ResultEntry log) {
            this.result.add(log);
            this.fireTableDataChanged();
        }

        @Override
        public void logClear() {
            this.result.clear();
            this.fireTableRowsDeleted(0, this.getRowCount());
        }
    }
}

