/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.attackoverview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import wsattacker.gui.GuiController;
import wsattacker.gui.component.attackoverview.subcomponent.EnabledPluginTable;
import wsattacker.gui.component.attackoverview.subcomponent.ResultLevelSlider;
import wsattacker.gui.component.attackoverview.subcomponent.ResultTable;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.main.plugin.PluginManager;
import wsattacker.main.plugin.result.ResultLevel;

public class AttackOverview_NB
extends JPanel {
    ControllerInterface controller;
    private static final Logger LOG = Logger.getLogger(AttackOverview_NB.class);
    private JButton clean;
    private EnabledPluginTable enabledPluginTable;
    private JScrollPane enabledPluginTableScrollPane;
    private ResultLevelSlider resultLevelSlider;
    private ResultTable resultTable;
    private JScrollPane resultTableScrollPane;
    private JButton save;
    private JFileChooser saveResultsFileChooser;
    private JSplitPane splitviewPane;
    private JButton start;
    private JButton stop;
    private BindingGroup bindingGroup;

    public AttackOverview_NB() {
        this(GuiController.getInstance());
    }

    public AttackOverview_NB(ControllerInterface controller) {
        this.controller = controller;
        this.initComponents();
        this.addSelectionModelToEnabledPluginsTable();
        this.addAdjustmenListenerToResultsScrollbar();
    }

    private void addSelectionModelToEnabledPluginsTable() {
        this.enabledPluginTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int[] selected = AttackOverview_NB.this.enabledPluginTable.getSelectedRows();
                    ArrayList<String> sources = new ArrayList<String>();
                    for (int index : selected) {
                        sources.add(PluginManager.getInstance().getActive(index).getName());
                    }
                    AttackOverview_NB.this.resultTable.filterSources(sources);
                }
            }
        });
    }

    private void addAdjustmenListenerToResultsScrollbar() {
        this.resultTableScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                int THRESHOLD;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JScrollBar bar = AttackOverview_NB.this.resultTableScrollPane.getVerticalScrollBar();
                int max = bar.getMaximum();
                int current = bar.getValue();
                if (current > max - (THRESHOLD = bar.getVisibleAmount() * 2)) {
                    e.getAdjustable().setValue(max);
                }
            }
        });
    }

    public void enableStartButton(boolean enable) {
        this.start.setEnabled(enable);
    }

    public void enableStopButton(boolean enable) {
        this.stop.setEnabled(enable);
    }

    public void enableCleanButton(boolean enable) {
        this.clean.setEnabled(enable);
    }

    public void enableSaveButton(boolean enable) {
        this.save.setEnabled(enable);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.saveResultsFileChooser = new JFileChooser();
        this.start = new JButton();
        this.stop = new JButton();
        this.clean = new JButton();
        this.save = new JButton();
        this.splitviewPane = new JSplitPane();
        this.enabledPluginTableScrollPane = new JScrollPane();
        this.enabledPluginTable = new EnabledPluginTable();
        this.resultTableScrollPane = new JScrollPane();
        this.resultTable = new ResultTable();
        this.resultLevelSlider = new ResultLevelSlider();
        this.saveResultsFileChooser.setDialogType(1);
        this.saveResultsFileChooser.setDialogTitle("Save Results to...");
        this.saveResultsFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getAbsolutePath().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Text documents (*.txt)";
            }
        });
        this.setName("Attack Overview");
        this.start.setText("Start");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.stop, ELProperty.create("${enabled}"), this.start, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttackOverview_NB.this.startAction(evt);
            }
        });
        this.stop.setText("Stop");
        this.stop.setEnabled(false);
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttackOverview_NB.this.stopAction(evt);
            }
        });
        this.clean.setText("Clean");
        this.clean.setEnabled(false);
        this.clean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttackOverview_NB.this.cleanAction(evt);
            }
        });
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttackOverview_NB.this.saveAction(evt);
            }
        });
        this.splitviewPane.setDividerLocation((2 + PluginManager.getInstance().countPlugins()) * this.enabledPluginTable.getRowHeight());
        this.splitviewPane.setOrientation(0);
        this.enabledPluginTableScrollPane.setViewportView(this.enabledPluginTable);
        this.splitviewPane.setLeftComponent(this.enabledPluginTableScrollPane);
        this.resultTableScrollPane.setViewportView(this.resultTable);
        this.splitviewPane.setRightComponent(this.resultTableScrollPane);
        this.resultLevelSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AttackOverview_NB.this.resultLevelSliderStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitviewPane).addGroup(layout.createSequentialGroup().addComponent(this.start).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clean).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.save).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 58, Short.MAX_VALUE).addComponent(this.resultLevelSlider, -2, 305, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.start).addComponent(this.stop).addComponent(this.clean).addComponent(this.save)).addComponent(this.resultLevelSlider, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitviewPane, -1, 239, Short.MAX_VALUE).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void startAction(ActionEvent evt) {
        this.controller.startActivePlugins();
    }

    private void stopAction(ActionEvent evt) {
        this.controller.stopActivePlugins();
    }

    private void cleanAction(ActionEvent evt) {
        this.controller.cleanPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAction(ActionEvent evt) {
        int returnVal = this.saveResultsFileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.saveResultsFileChooser.getSelectedFile();
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(file));
                for (int row = 0; row < this.resultTable.getRowCount(); ++row) {
                    for (int col = 0; col < this.resultTable.getColumnCount(); ++col) {
                        out.write(this.resultTable.getValueAt(row, col).toString());
                        out.newLine();
                    }
                    out.newLine();
                }
            }
            catch (IOException ex) {
                LOG.warn(ex);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOG.warn(ex);
                }
            }
        } else {
            LOG.info("File access cancelled by user.");
        }
    }

    private void resultLevelSliderStateChanged(ChangeEvent evt) {
        int val = this.resultLevelSlider.getValue();
        String level = ((JLabel)this.resultLevelSlider.getLabelTable().get(val)).getText();
        this.resultTable.setLevel(ResultLevel.valueOf(level));
    }
}

