/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.support.SoapUIException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import wsattacker.gui.GuiView;
import wsattacker.gui.component.target.WsdlLoaderGUI_NB;
import wsattacker.main.Preferences;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.plugin.PluginManager;
import wsattacker.main.plugin.result.Result;
import wsattacker.main.testsuite.CurrentRequest;
import wsattacker.main.testsuite.TestSuite;

public class GuiController
implements ControllerInterface {
    private static final GuiController c = new GuiController();
    PluginManager pluginManager;
    TestSuite testSuite;
    Preferences prefs;
    Logger LOG = Logger.getLogger(GuiController.class);
    GuiView guiView;
    private boolean abortAttacks = false;
    Thread runThread;
    PluginRunner runner;

    private GuiController() {
        this.pluginManager = PluginManager.getInstance();
        this.reloadPlugins();
        this.testSuite = TestSuite.getInstance();
        this.prefs = Preferences.getInstance();
        this.runThread = new Thread();
        this.guiView = new GuiView(this);
        Thread viewThread = new Thread(this.guiView);
        viewThread.start();
    }

    public static GuiController getInstance() {
        return c;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public void reloadPlugins() {
        this.LOG.info("Adding Libraries from \"lib\" folder");
        this.getPluginManager().loadAvailablePlugins(new File("lib"));
        this.LOG.info("Reloading Plugins");
        this.getPluginManager().loadAvailablePlugins(new File("plugins"));
    }

    @Override
    public void setPluginActive(int index, boolean active) {
        AbstractPlugin plugin = this.getPluginManager().getByIndex(index);
        this.setPluginActive(plugin, active);
    }

    @Override
    public void setPluginActive(String pluginName, boolean active) {
        AbstractPlugin plugin = this.getPluginManager().getByName(pluginName);
        this.setPluginActive(plugin, active);
    }

    private void setPluginActive(AbstractPlugin plugin, boolean active) {
        if (plugin != null) {
            if (this.getPluginManager().isActive(plugin) != active) {
                this.LOG.info(String.format((active ? "(+) A" : "(-) Dea") + "ctivating Plugin %s", plugin.getName()));
                this.getPluginManager().setActive(plugin, active);
            }
        } else {
            this.LOG.warn(String.format("(!) Could not activate Plugin", new Object[0]));
        }
    }

    @Override
    public void setAllPluginActive(boolean active) {
        this.LOG.info((active ? "(+) A" : "(-) Dea") + "ctivating all Plugins");
        this.getPluginManager().setAllActive(active);
    }

    @Override
    public void setOptionValue(AbstractPlugin plugin, String optionName, String optionValue) {
        AbstractOption option = plugin.getPluginOptions().getByName(optionName);
        if (option == null) {
            throw new NullPointerException("Option is null");
        }
        if (option.isValid(optionValue)) {
            this.LOG.debug(String.format("Set PluginOption for '%s': {%s=%s}", plugin.getName(), optionName, optionValue));
            option.parseValue(optionValue);
        }
        this.LOG.debug(String.format("Value {%s=%s} for Plugin '%s' is INVALID!", optionName, optionValue, plugin.getName()));
    }

    @Override
    public void startActivePlugins() {
        if (this.runThread.isAlive()) {
            this.LOG.fatal("You can't start Attacks. Another process is running.");
            return;
        }
        this.runner = new PluginRunner(this.testSuite);
        this.runThread = new Thread(this.runner);
        this.runThread.setName("Run Plugins");
        this.guiView.getAttackOverview().enableStartButton(false);
        this.guiView.getAttackOverview().enableStopButton(true);
        this.guiView.getAttackOverview().enableCleanButton(false);
        this.guiView.getAttackOverview().enableSaveButton(false);
        this.runThread.start();
    }

    @Override
    public void stopActivePlugins() {
        Thread stopThread = new Thread(new PluginStopper());
        stopThread.run();
        this.runThread.setName("Run Plugins");
    }

    @Override
    public void cleanPlugins() {
        boolean noError = true;
        for (AbstractPlugin plugin : this.getPluginManager()) {
            plugin.clean();
            if (plugin.isFinished() || plugin.isRunning()) {
                this.LOG.error("Plugin " + plugin.getName() + " could not be cleaned, Status is still " + (Object)((Object)plugin.getState()));
                noError |= false;
            }
            if (plugin.getCurrentPoints() == 0) continue;
            this.LOG.error("Plugin " + plugin.getName() + "could not be cleaned, it has still " + plugin.getCurrentPoints() + " Points");
            noError |= false;
        }
        Result.getGlobalResult().clear();
        if (noError) {
            this.LOG.info("All Plugins successfully cleaned");
        }
        this.guiView.getAttackOverview().enableStartButton(true);
        this.guiView.getAttackOverview().enableStopButton(false);
        this.guiView.getAttackOverview().enableCleanButton(false);
        this.guiView.getAttackOverview().enableSaveButton(false);
    }

    @Override
    public void savePluginConfiguration(File file) {
        try {
            this.getPluginManager().savePlugins(file);
        }
        catch (IOException e) {
            this.LOG.error("IO Exception : " + e.getMessage());
        }
        catch (Exception e) {
            this.LOG.error("Unknown Error:" + e.getMessage());
        }
    }

    @Override
    public void loadPluginConfiguration(File file) {
        try {
            this.getPluginManager().loadPlugins(file);
        }
        catch (IOException e) {
            this.LOG.error("IO Exception : " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            this.LOG.error("Could not find all Plugin Classes");
        }
        catch (Exception e) {
            this.LOG.error("Unknown Error:" + e.getMessage());
        }
        this.LOG.info("Successfully loaded Configuration");
    }

    @Override
    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    @Override
    public void setWsdl(String uri) {
        if (this.runThread.isAlive()) {
            this.LOG.fatal("You can't start Attacks. Another process is running.");
            return;
        }
        this.LOG.info("Trying to load WSDL from '" + uri + "'");
        WsdlLoadRunner runner = new WsdlLoadRunner(uri);
        this.runThread = new Thread(runner);
        this.runThread.setName("Load WSDL");
        this.runThread.start();
    }

    @Override
    public boolean setCurrentService(String serviceName) {
        WsdlProject project = this.testSuite.getProject();
        if (project != null && project.getInterfaceByName(serviceName) != null) {
            WsdlInterface service = (WsdlInterface)project.getInterfaceByName(serviceName);
            this.setCurrentService(service);
            return true;
        }
        this.LOG.warn("No such service available");
        return false;
    }

    @Override
    public boolean setCurrentService(int index) {
        WsdlProject project = this.testSuite.getProject();
        if (project != null && index >= 0 && index < project.getInterfaceCount()) {
            WsdlInterface service = (WsdlInterface)project.getInterfaceAt(index);
            this.setCurrentService(service);
            return true;
        }
        this.LOG.warn("No such service available");
        return false;
    }

    private void setCurrentService(WsdlInterface service) {
        this.testSuite.getCurrentInterface().setWsdlInterface(service);
        this.LOG.info("Set current service to '" + service.getName() + "'");
    }

    @Override
    public boolean setCurrentOperation(String operationString) {
        WsdlOperation operation = this.testSuite.getCurrentInterface().getWsdlInterface().getOperationByName(operationString);
        return this.setCurrentOperation(operation);
    }

    @Override
    public boolean setCurrentOperation(int index) {
        WsdlOperation operation = this.testSuite.getCurrentInterface().getWsdlInterface().getOperationAt(index);
        return this.setCurrentOperation(operation);
    }

    private boolean setCurrentOperation(WsdlOperation operation) {
        if (operation == null) {
            this.LOG.warn("Unset current operatoin (null)");
            return false;
        }
        this.testSuite.getCurrentOperation().setWsdlOperation(operation);
        this.LOG.info("Set current operation to '" + operation.getName() + "'");
        return true;
    }

    @Override
    public void resetRequestContent() {
        WsdlRequest request = this.testSuite.getCurrentRequest().getWsdlRequest();
        if (request != null) {
            this.LOG.info("Resetting content for basic Request");
            request.setRequestContent(request.getOperation().createRequest(this.prefs.isCreateOptionalElements()));
        }
    }

    @Override
    public void setRequestContent(String content) {
        this.LOG.trace("Setting request content to:\n" + content);
        WsdlRequest request = this.testSuite.getCurrentRequest().getWsdlRequest();
        if (request != null) {
            request.setRequestContent(content);
        } else {
            this.LOG.warn("There is no current Request");
        }
    }

    @Override
    public void doTestRequest() {
        WsdlRequest request;
        if (this.runThread.isAlive()) {
            this.LOG.fatal("You can't do a Test Request. Another process is running.");
        }
        if ((request = this.testSuite.getCurrentRequest().getWsdlRequest()) == null) {
            this.LOG.warn("You have to load a WSDL first");
            return;
        }
        this.LOG.info("Doing a Test Request");
        TestRequest runner = new TestRequest(this.testSuite.getCurrentRequest());
        this.runThread = new Thread(runner);
        this.runThread.setName("Test Request");
        this.runThread.start();
    }

    private void setEnabledTabs(boolean enabled, int ... tabindex) {
        for (int i : tabindex) {
            this.guiView.getMainWindows().getTabs().setEnabledAt(i, enabled);
        }
    }

    public GuiView getGuiView() {
        return this.guiView;
    }

    class TestRequest
    implements Runnable {
        final CurrentRequest request;

        public TestRequest(CurrentRequest request) {
            this.request = request;
        }

        @Override
        public void run() {
            GuiController.this.LOG.info("Submitting Request...");
            try {
                this.request.submitRequest();
            }
            catch (NullPointerException e) {
                String error = "Error while doing Test Request" + e.getMessage();
                GuiController.this.LOG.error(error);
                return;
            }
            catch (Request.SubmitException e) {
                String error = "Error while doing Test Request. " + e.getMessage();
                GuiController.this.LOG.error(error);
                return;
            }
            catch (Exception e) {
                GuiController.this.LOG.error("Unknown Error:" + e.getMessage());
                return;
            }
            String responseContent = this.request.getWsdlResponse().getContentAsString();
            if (responseContent == null) {
                GuiController.this.LOG.warn("Got an empty response. Bad request?");
            } else {
                GuiController.this.LOG.info("Successfully received Response");
            }
        }
    }

    class WsdlLoadRunner
    implements Runnable {
        String uri;

        public WsdlLoadRunner(String uri) {
            this.uri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WsdlLoaderGUI_NB wsdlGui = GuiController.this.guiView.getWsdlLoader();
            wsdlGui.getUriField().setEnabled(false);
            wsdlGui.getLoadButton().setEnabled(false);
            wsdlGui.getServiceComboBox().setEnabled(false);
            wsdlGui.getOperationComboBox().setEnabled(false);
            wsdlGui.getNewRequestButtom().setEnabled(false);
            wsdlGui.updateUI();
            try {
                GuiController.this.testSuite.loadWsdl(this.uri);
                wsdlGui.getServiceComboBox().setEnabled(true);
                wsdlGui.getOperationComboBox().setEnabled(true);
                wsdlGui.getNewRequestButtom().setEnabled(true);
            }
            catch (SoapUIException e) {
                GuiController.this.LOG.error("SoapUIException while loading WSDL: " + e.getMessage());
            }
            catch (UnsupportedOperationException e) {
                GuiController.this.LOG.error("UnsupportedOperationException while loading WSDL: " + e.getMessage());
            }
            catch (Exception e) {
                GuiController.this.LOG.error("Wsdl File could not be loaded: " + e.getMessage());
            }
            finally {
                wsdlGui.getUriField().setEnabled(true);
                wsdlGui.getLoadButton().setEnabled(true);
            }
        }
    }

    class PluginRunner
    implements Runnable {
        TestSuite testSuite;
        AbstractPlugin active;

        public PluginRunner(TestSuite testSuite) {
            this.testSuite = testSuite;
            this.active = null;
        }

        @Override
        public void run() {
            AbstractPlugin plugin;
            if (this.testSuite.getCurrentRequest().getWsdlRequest() == null) {
                GuiController.this.LOG.warn("You have to load a WSDL first");
                return;
            }
            if (this.testSuite.getCurrentRequest().getWsdlResponse() == null) {
                GuiController.this.LOG.warn("You must submit a test request first.");
                return;
            }
            if (GuiController.this.getPluginManager().countActivePlugins() < 1) {
                GuiController.this.LOG.warn("You must enable at least one Plugin");
                return;
            }
            Iterator<AbstractPlugin> it = GuiController.this.getPluginManager().getActivePluginIterator();
            while (it.hasNext()) {
                plugin = it.next();
                if (plugin.isReady()) continue;
                GuiController.this.LOG.warn("Not all Plugins are Ready");
                return;
            }
            GuiController.this.LOG.info("Starting all active Plugins...");
            GuiController.this.setEnabledTabs(false, new int[]{0, 1, 2});
            it = GuiController.this.getPluginManager().getActivePluginIterator();
            while (it.hasNext() && !GuiController.this.abortAttacks) {
                this.active = plugin = it.next();
                GuiController.this.LOG.info("Starting plugin '" + plugin.getName() + "'");
                plugin.startAttack();
                GuiController.this.LOG.info("Plugin finished: " + plugin.getCurrentPoints() + "/" + plugin.getMaxPoints());
            }
            this.active = null;
            GuiController.this.setEnabledTabs(true, new int[]{0, 1, 2});
            GuiController.this.guiView.getAttackOverview().enableStartButton(false);
            GuiController.this.guiView.getAttackOverview().enableStopButton(false);
            GuiController.this.guiView.getAttackOverview().enableCleanButton(true);
            GuiController.this.guiView.getAttackOverview().enableSaveButton(true);
        }

        public AbstractPlugin getActive() {
            return this.active;
        }
    }

    class PluginStopper
    implements Runnable {
        PluginStopper() {
        }

        @Override
        public void run() {
            if (GuiController.this.runThread.isAlive() && GuiController.this.runThread.getName().equals("Run Plugins")) {
                GuiController.this.abortAttacks = true;
                GuiController.this.LOG.info("Stopping all active plugins");
                AbstractPlugin active = GuiController.this.runner.getActive();
                GuiController.this.LOG.warn("Gently aborting plugin '" + active.getName() + "' (Waiting for 3 sec)");
                active.abortAttack();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (GuiController.this.runThread.isAlive() && GuiController.this.runThread.getName().equals("Run Plugins")) {
                    GuiController.this.LOG.warn("Force to kill thread, since plugin is still running.");
                    GuiController.this.runThread.stop();
                }
                active.stopAttack();
                Iterator<AbstractPlugin> it = GuiController.this.getPluginManager().getActivePluginIterator();
                while (it.hasNext()) {
                    AbstractPlugin otherPlugin = it.next();
                    if (!otherPlugin.isReady()) continue;
                    otherPlugin.stopAttack();
                }
                GuiController.this.setEnabledTabs(true, new int[]{0, 1, 2});
                GuiController.this.abortAttacks = false;
            }
            GuiController.this.guiView.getAttackOverview().enableStartButton(false);
            GuiController.this.guiView.getAttackOverview().enableStopButton(false);
            GuiController.this.guiView.getAttackOverview().enableCleanButton(true);
            GuiController.this.guiView.getAttackOverview().enableSaveButton(true);
        }
    }
}

