/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureFaking.helper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;
import wsattacker.library.signatureFaking.exceptions.CertificateHandlerException;

public class CertificateHandler {
    private X509Certificate certificate;
    private PublicKey originalPublicKey;
    private X509CertImpl fakedCertificate;
    private KeyPair fakedKeyPair;
    private CertificateFactory certFactory;
    Logger log = Logger.getLogger(CertificateHandler.class);

    public CertificateHandler(String cert) throws CertificateHandlerException {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509");
            this.certificate = (X509Certificate)this.certFactory.generateCertificate(new ByteArrayInputStream(Base64.decodeBase64((String)cert)));
            this.originalPublicKey = this.certificate.getPublicKey();
        }
        catch (CertificateException e) {
            throw new CertificateHandlerException(e);
        }
    }

    public void createFakedCertificate() throws CertificateHandlerException {
        try {
            this.log.debug((Object)"Faking the found certificate");
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.originalPublicKey.getAlgorithm());
            kpg.initialize(((RSAPublicKey)this.certificate.getPublicKey()).getModulus().bitLength());
            this.fakedKeyPair = kpg.generateKeyPair();
            X509CertInfo info = new X509CertInfo();
            CertificateValidity interval = new CertificateValidity(this.certificate.getNotBefore(), this.certificate.getNotAfter());
            BigInteger sn = new BigInteger(64, new Random());
            X500Name owner = new X500Name(this.certificate.getSubjectDN().getName());
            X500Name issuer = new X500Name(this.certificate.getIssuerDN().getName());
            info.set("validity", interval);
            info.set("serialNumber", new CertificateSerialNumber(sn));
            info.set("subject", new CertificateSubjectName(owner));
            info.set("issuer", new CertificateIssuerName(issuer));
            info.set("key", new CertificateX509Key(this.fakedKeyPair.getPublic()));
            info.set("version", new CertificateVersion(2));
            AlgorithmId algo = new AlgorithmId(new ObjectIdentifier(this.certificate.getSigAlgOID()));
            info.set("algorithmID", new CertificateAlgorithmId(algo));
            this.fakedCertificate = new X509CertImpl(info);
            this.fakedCertificate.sign(this.fakedKeyPair.getPrivate(), this.certificate.getSigAlgName());
        }
        catch (CertificateException e) {
            throw new CertificateHandlerException(e);
        }
        catch (IOException e) {
            throw new CertificateHandlerException(e);
        }
        catch (InvalidKeyException e) {
            throw new CertificateHandlerException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateHandlerException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CertificateHandlerException(e);
        }
        catch (SignatureException e) {
            throw new CertificateHandlerException(e);
        }
    }

    public PublicKey getOriginalPublicKey() {
        return this.originalPublicKey;
    }

    public void setOriginalPublicKey(PublicKey originalPublicKey) {
        this.originalPublicKey = originalPublicKey;
    }

    public X509CertImpl getFakedCertificate() {
        return this.fakedCertificate;
    }

    public void setFakedCertificate(X509CertImpl fakedCertificate) {
        this.fakedCertificate = fakedCertificate;
    }

    public KeyPair getFakedKeyPair() {
        return this.fakedKeyPair;
    }

    public void setFakedKeyPair(KeyPair fakedKeyPair) {
        this.fakedKeyPair = fakedKeyPair;
    }

    public String getFakedCertificateString() throws CertificateHandlerException {
        try {
            return new String(Base64.encodeBase64((byte[])this.fakedCertificate.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            throw new CertificateHandlerException(e);
        }
    }
}

