/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos.dosExtension.mvc.model;

import java.util.List;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import wsattacker.plugin.dos.dosExtension.logEntry.LogEntryRequest;

public class AttackRoundtrip {
    private double medianUntampered;
    private double medianTampered;
    private long tsTamperedLastSend;
    private final int sampleCountAttackEffectivness = 10;

    public double getMedianUntampered() {
        return this.medianUntampered;
    }

    public void setMedianUntampered(double medianUntampered) {
        this.medianUntampered = medianUntampered;
    }

    public double getMedianTampered() {
        return this.medianTampered;
    }

    public void setMedianTampered(double medianTampered) {
        this.medianTampered = medianTampered;
    }

    public double getTimeRatio(List<LogEntryRequest> untampered, List<LogEntryRequest> tampered) {
        try {
            Median median = new Median();
            int sampleCountMax = untampered.size() < 10 ? untampered.size() : 10;
            this.medianUntampered = 0.0;
            double[] medianUntamperedArray = new double[sampleCountMax];
            for (int i = 1; i <= sampleCountMax; ++i) {
                medianUntamperedArray[i - 1] = untampered.get(untampered.size() - i).getDuration();
            }
            this.medianUntampered = median.evaluate(medianUntamperedArray);
            this.medianTampered = 0.0;
            double[] medianTamperedArray = new double[sampleCountMax];
            for (int i = 1; i <= sampleCountMax; ++i) {
                medianTamperedArray[i - 1] = tampered.get(tampered.size() - i).getDuration();
            }
            this.medianTampered = median.evaluate(medianTamperedArray);
            double timeDelta = (float)this.medianTampered / (float)this.medianUntampered;
            double result = timeDelta;
            if (result >= 0.0) {
                return (double)Math.round(result * 100.0) / 100.0;
            }
            return 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getTestProbeAttackRoundtripTime(List<LogEntryRequest> testProbe) {
        if (testProbe.size() > 0) {
            Median median = new Median();
            int sampleCountMaxTestProbes = 0;
            for (int i = 0; i < testProbe.size(); ++i) {
                if (testProbe.get(i).getTsSend() <= this.tsTamperedLastSend) continue;
                ++sampleCountMaxTestProbes;
            }
            double[] medianTestProbesArray = new double[sampleCountMaxTestProbes];
            int i = 0;
            int k = 0;
            while (i < testProbe.size()) {
                if (testProbe.get(i).getTsSend() > this.tsTamperedLastSend) {
                    medianTestProbesArray[k] = testProbe.get(i).getDuration();
                }
                ++i;
                ++k;
            }
            double medianTestProbes = median.evaluate(medianTestProbesArray);
            double result = medianTestProbes / 1.0E9;
            return (double)Math.round(result * 1000.0) / 1000.0;
        }
        return 0.0;
    }
}

