/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos.dosExtension.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import wsattacker.plugin.dos.dosExtension.attackRunnables.RedrawChartRunnable;
import wsattacker.plugin.dos.dosExtension.chart.ChartObject;
import wsattacker.plugin.dos.dosExtension.mvc.controller.CloseAttackFinishedController;
import wsattacker.plugin.dos.dosExtension.mvc.controller.HelpController;
import wsattacker.plugin.dos.dosExtension.mvc.controller.ReportController;
import wsattacker.plugin.dos.dosExtension.mvc.model.AttackModel;
import wsattacker.plugin.dos.dosExtension.result.ResultGenerator;

public class DosResultJFrame
extends JFrame {
    private final ResultGenerator resultGenerator;
    private final AttackModel model;
    private JButton jButtonCloseAll;
    private JButton jButtonExport;
    private JButton jButtonHelp;
    private JPanel jChartPanel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabelMetadata;
    private JLabel jLabelSuccess;
    private JPanel jPanel1;
    private JPanel jPanelMetadata;
    private JPanel jPanelSuccess;
    private JSpinner jSpinner1;

    public DosResultJFrame(AttackModel model) {
        this.model = model;
        this.resultGenerator = new ResultGenerator(model);
        this.initComponents();
    }

    private void initComponents() {
        ChartObject chartObject = new ChartObject(this.model);
        JFreeChart chart = chartObject.createOverlaidChart();
        this.jChartPanel = new ChartPanel(chart);
        this.jButtonCloseAll = new JButton();
        this.jButtonExport = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanelSuccess = new JPanel();
        this.jLabelSuccess = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jPanelMetadata = new JPanel();
        this.jLabelMetadata = new JLabel();
        this.jPanel1 = new JPanel();
        this.jSpinner1 = new JSpinner();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("WS-Attacker - DOS Attack Results");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DosResultJFrame.this.handlerCloseFinishedAttack(evt);
            }
        });
        this.jChartPanel.setBorder(new LineBorder(new Color(0, 0, 0), 0, false));
        this.resultGenerator.setJChartPanel((ChartPanel)this.jChartPanel);
        GroupLayout jChartPanelLayout = new GroupLayout(this.jChartPanel);
        this.jChartPanel.setLayout(jChartPanelLayout);
        jChartPanelLayout.setHorizontalGroup(jChartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 713, Short.MAX_VALUE));
        jChartPanelLayout.setVerticalGroup(jChartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 653, Short.MAX_VALUE));
        this.jButtonCloseAll.setText("Close");
        this.jButtonCloseAll.setToolTipText("Closes all open attack windows");
        this.jButtonCloseAll.addActionListener(new CloseAttackFinishedController(this));
        this.jButtonExport.setText("Export Results + Request Details");
        this.jButtonExport.setToolTipText("Save attack report");
        this.jButtonExport.addActionListener(new ReportController(this.resultGenerator));
        this.jButtonHelp.setText("Help Menu");
        this.jButtonHelp.setToolTipText("Open Help menu in web browser");
        this.jButtonHelp.addActionListener(new HelpController(this.resultGenerator));
        this.jPanelSuccess.setBorder(BorderFactory.createTitledBorder(null, "Attack Success Metric", 0, 0, null, Color.black));
        this.jLabelSuccess.setFont(new Font("Ubuntu", 0, 14));
        this.jLabelSuccess.setText("<html>Attack roundtrip time ratio:<br />" + this.model.getAttackRoundtripTimeRatio() + " Points - " + this.model.getAttackRoundtripTimeRatioDescription("text") + "</html>");
        this.jLabel7.setFont(new Font("Ubuntu", 0, 14));
        this.jLabel7.setText("<html>Testprobe roundtrip time after attack (" + this.model.getAttackLongevitySeconds() + " sec)<br />" + this.model.getTestProbeAttackRoundtripTime() + " sec - " + this.model.getTestProbeAttackRoundtripTimeDescription("text") + "</html>");
        GroupLayout jPanelSuccessLayout = new GroupLayout(this.jPanelSuccess);
        this.jPanelSuccess.setLayout(jPanelSuccessLayout);
        jPanelSuccessLayout.setHorizontalGroup(jPanelSuccessLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSuccessLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSuccessLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, -2, 30, -2).addComponent(this.jLabel4, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSuccessLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSuccess, -1, 279, Short.MAX_VALUE).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE))));
        jPanelSuccessLayout.setVerticalGroup(jPanelSuccessLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSuccessLayout.createSequentialGroup().addGroup(jPanelSuccessLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, -2, 36, -2).addComponent(this.jLabelSuccess, -2, 30, -2)).addGap(18, 18, 18).addGroup(jPanelSuccessLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -2, 30, -2).addComponent(this.jLabel4, -2, 30, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        URL imgURL1 = this.getClass().getResource(this.model.getAttackRoundtripTimeRatioDescription("image"));
        if (imgURL1 != null) {
            this.jLabel1.setIcon(new ImageIcon(imgURL1, "Status Attack Metric 1"));
        } else {
            System.err.println("Couldn't find file: /IMG/XX.png");
        }
        URL imgURL4 = this.getClass().getResource(this.model.getTestProbeAttackRoundtripTimeDescription("image"));
        if (imgURL4 != null) {
            this.jLabel4.setIcon(new ImageIcon(imgURL4, "Status Attack Metric 4"));
        } else {
            System.err.println("Couldn't find file: /IMG/ok.png");
        }
        this.jPanelMetadata.setBorder(BorderFactory.createTitledBorder(null, "Attack Metadata", 0, 0, null, Color.black));
        this.jLabelMetadata.setFont(new Font("Ubuntu", 0, 14));
        this.jLabelMetadata.setText("<html><table><tr><td>Attack start:</td><td>" + this.model.getStartDate() + "</td>" + "</tr>" + "<tr>" + "<td>Attack stop:</td>" + "<td>" + this.model.getStopDate() + "</td>" + "</tr>" + "<tr>" + "<td>Parallel threads:</td>" + "<td>" + this.model.getNumberThreads() + "</td>" + "</tr>" + "<tr>" + "<td>Requests per thread:</td>" + "<td>" + this.model.getNumberRequestsPerThread() + "</td>" + "</tr>" + "<tr>" + "<td>Request repeat interval</td>" + "<td>" + this.model.getSecondsBetweenRequests() + " ms</td>" + "</tr>" + "<tr>" + "<td>Server recovery time</td>" + "<td>" + this.model.getSecondsServerLoadRecovery() / 1000 + " sec</td>" + "</tr>" + "<tr>" + "<td>Send testprobes:</td>" + "<td>" + this.model.getCounterProbesSend() + "</td>" + "</tr>" + "<tr>" + "<td>Testprobe repeat interval</td>" + "<td>" + this.model.getSecondsBetweenProbes() + " ms</td>" + "</tr>" + "<tr>" + "<td>Size testprobe request:</td>" + "<td>" + this.model.getRequestSizeTestProbe() + " Bytes</td>" + "</tr>" + "<tr>" + "<td>Size untampered padded request:</td>" + "<td>" + this.model.getRequestSizePaddedUntampered() + " Bytes</td>" + "</tr>" + "<tr>" + "<td>Size tampered padded request:</td>" + "<td>" + this.model.getRequestSizePaddedTampered() + " Bytes</td>" + "</tr>" + "</table>" + "</html>");
        GroupLayout jPanelMetadataLayout = new GroupLayout(this.jPanelMetadata);
        this.jPanelMetadata.setLayout(jPanelMetadataLayout);
        jPanelMetadataLayout.setHorizontalGroup(jPanelMetadataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMetadataLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelMetadata, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelMetadataLayout.setVerticalGroup(jPanelMetadataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMetadataLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelMetadata, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Diagramm Settings", 0, 0, null, Color.black));
        this.jSpinner1.setFont(new Font("Ubuntu", 0, 14));
        this.jSpinner1.setModel(new SpinnerNumberModel(1, 1, 60, 1));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DosResultJFrame.this.jSpinner1StateChanged(evt);
            }
        });
        this.jLabel3.setFont(new Font("Ubuntu", 0, 14));
        this.jLabel3.setText("Interval length (default 1 sec)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jSpinner1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(24, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jChartPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelSuccess, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExport, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCloseAll, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelMetadata, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jChartPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanelMetadata, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanelSuccess, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp).addGap(18, 18, 18).addComponent(this.jButtonExport).addGap(18, 18, 18).addComponent(this.jButtonCloseAll))).addContainerGap()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 1110) / 2, (screenSize.height - 707) / 2, 1110, 707);
    }

    private void handlerCloseFinishedAttack(WindowEvent evt) {
        this.dispose();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        int spinnerValue = Integer.parseInt(this.jSpinner1.getValue().toString());
        EventQueue.invokeLater(new RedrawChartRunnable(this.resultGenerator, spinnerValue));
    }
}

