/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos.dosExtension.chart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import wsattacker.plugin.dos.dosExtension.logEntry.LogEntryInterval;
import wsattacker.plugin.dos.dosExtension.mvc.model.AttackModel;

public class ChartObject {
    AttackModel model;

    public ChartObject(AttackModel model) {
        this.model = model;
    }

    public JFreeChart createOverlaidChart() {
        DateAxis yAxis = new DateAxis("Time");
        yAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        NumberAxis xAxis0 = new NumberAxis("Response Time in ms");
        xAxis0.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        XYDataset dataResponseTimeProbes = this.createDatasetResponseTime("testprobe");
        XYLineAndShapeRenderer rendererResponseTimeProbes = new XYLineAndShapeRenderer();
        rendererResponseTimeProbes.setSeriesPaint(0, (Paint)Color.blue);
        rendererResponseTimeProbes.setSeriesShape(0, (Shape)new Ellipse2D.Double(-1.5, -1.5, 3.0, 3.0));
        rendererResponseTimeProbes.setSeriesLinesVisible(0, true);
        rendererResponseTimeProbes.setSeriesShapesVisible(0, true);
        rendererResponseTimeProbes.setUseOutlinePaint(false);
        rendererResponseTimeProbes.setSeriesOutlinePaint(0, (Paint)Color.black);
        rendererResponseTimeProbes.setUseFillPaint(true);
        rendererResponseTimeProbes.setSeriesFillPaint(0, (Paint)Color.blue);
        XYPlot plot = new XYPlot(dataResponseTimeProbes, (ValueAxis)yAxis, (ValueAxis)xAxis0, (XYItemRenderer)rendererResponseTimeProbes);
        XYDataset dataResponseTimeUntampered = this.createDatasetResponseTime("untampered");
        XYLineAndShapeRenderer rendererResponseTimeUntampered = new XYLineAndShapeRenderer();
        rendererResponseTimeUntampered.setSeriesPaint(0, (Paint)new Color(0, 161, 4));
        rendererResponseTimeUntampered.setSeriesShape(0, (Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        rendererResponseTimeUntampered.setUseFillPaint(true);
        rendererResponseTimeUntampered.setSeriesFillPaint(0, (Paint)Color.white);
        rendererResponseTimeUntampered.setUseOutlinePaint(false);
        rendererResponseTimeUntampered.setSeriesOutlinePaint(0, (Paint)Color.black);
        rendererResponseTimeUntampered.setSeriesToolTipGenerator(0, (XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00")));
        plot.setDataset(2, dataResponseTimeUntampered);
        plot.setRenderer(2, (XYItemRenderer)rendererResponseTimeUntampered);
        XYDataset dataResponseTimeTampered = this.createDatasetResponseTime("tampered");
        XYLineAndShapeRenderer rendererResponseTimeTampered = new XYLineAndShapeRenderer();
        rendererResponseTimeTampered.setSeriesPaint(0, (Paint)new Color(189, 0, 0));
        rendererResponseTimeTampered.setSeriesShape(0, (Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        rendererResponseTimeTampered.setUseFillPaint(true);
        rendererResponseTimeTampered.setSeriesFillPaint(0, (Paint)Color.white);
        rendererResponseTimeTampered.setUseOutlinePaint(false);
        rendererResponseTimeTampered.setSeriesOutlinePaint(0, (Paint)Color.black);
        plot.setDataset(3, dataResponseTimeTampered);
        plot.setRenderer(3, (XYItemRenderer)rendererResponseTimeTampered);
        NumberAxis xAxis1 = new NumberAxis("Number Requests Per Interval (" + this.model.getIntervalLengthReport() / 1000 + " sec)");
        xAxis1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setRangeAxis(1, (ValueAxis)xAxis1);
        IntervalXYDataset dataNumberRequestsUntampered = this.createDatasetNumberRequestsUntampered();
        XYBarRenderer rendererNumberRequestsUntampered = new XYBarRenderer(0.2);
        rendererNumberRequestsUntampered.setShadowVisible(false);
        rendererNumberRequestsUntampered.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        rendererNumberRequestsUntampered.setSeriesPaint(0, (Paint)new Color(128, 255, 128));
        plot.setDataset(4, (XYDataset)dataNumberRequestsUntampered);
        plot.setRenderer(4, (XYItemRenderer)rendererNumberRequestsUntampered);
        plot.mapDatasetToRangeAxis(4, 1);
        IntervalXYDataset dataNumberRequestsTampered = this.createDatasetNumberRequestsTampered();
        XYBarRenderer rendererBarNumberRequestsTampered = new XYBarRenderer(0.2);
        rendererBarNumberRequestsTampered.setShadowVisible(false);
        rendererBarNumberRequestsTampered.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        rendererBarNumberRequestsTampered.setSeriesPaint(0, (Paint)new Color(255, 148, 148));
        plot.setDataset(5, (XYDataset)dataNumberRequestsTampered);
        plot.setRenderer(5, (XYItemRenderer)rendererBarNumberRequestsTampered);
        plot.mapDatasetToRangeAxis(5, 1);
        LegendTitle legendL1 = new LegendTitle((LegendItemSource)plot.getRenderer(0));
        legendL1.setMargin(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        legendL1.setBorder(0.0, 0.0, 0.0, 0.0);
        LegendTitle legendR1 = new LegendTitle((LegendItemSource)plot.getRenderer(4));
        legendR1.setMargin(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        legendR1.setBorder(0.0, 0.0, 0.0, 0.0);
        BlockContainer blockcontainer = new BlockContainer((Arrangement)new BorderArrangement());
        blockcontainer.setBorder(0.0, 0.0, 0.0, 0.0);
        blockcontainer.add((Block)legendL1, (Object)RectangleEdge.LEFT);
        blockcontainer.add((Block)legendR1, (Object)RectangleEdge.RIGHT);
        blockcontainer.add((Block)new EmptyBlock(2000.0, 0.0));
        CompositeTitle compositetitle1 = new CompositeTitle(blockcontainer);
        compositetitle1.setPosition(RectangleEdge.BOTTOM);
        LegendTitle legendL2 = new LegendTitle((LegendItemSource)plot.getRenderer(2));
        legendL2.setMargin(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        legendL2.setBorder(0.0, 0.0, 0.0, 0.0);
        LegendTitle legendR2 = new LegendTitle((LegendItemSource)plot.getRenderer(5));
        legendR2.setMargin(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        legendR2.setBorder(0.0, 0.0, 0.0, 0.0);
        BlockContainer blockcontainer2 = new BlockContainer((Arrangement)new BorderArrangement());
        blockcontainer2.setBorder(0.0, 0.0, 0.0, 0.0);
        blockcontainer2.add((Block)legendL2, (Object)RectangleEdge.LEFT);
        blockcontainer2.add((Block)legendR2, (Object)RectangleEdge.RIGHT);
        blockcontainer2.add((Block)new EmptyBlock(2000.0, 0.0));
        CompositeTitle compositetitle2 = new CompositeTitle(blockcontainer2);
        compositetitle2.setPosition(RectangleEdge.BOTTOM);
        LegendTitle legendL3 = new LegendTitle((LegendItemSource)plot.getRenderer(3));
        legendL3.setMargin(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        legendL3.setBorder(0.0, 0.0, 0.0, 0.0);
        BlockContainer blockcontainer3 = new BlockContainer((Arrangement)new BorderArrangement());
        blockcontainer3.setBorder(0.0, 0.0, 0.0, 0.0);
        blockcontainer3.add((Block)legendL3, (Object)RectangleEdge.LEFT);
        blockcontainer3.add((Block)new EmptyBlock(2000.0, 0.0));
        CompositeTitle compositetitle3 = new CompositeTitle(blockcontainer3);
        compositetitle3.setPosition(RectangleEdge.BOTTOM);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart jFreeChart = new JFreeChart(this.model.getAttackName() + " - Response Time Plot", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        jFreeChart.addSubtitle((Title)compositetitle1);
        jFreeChart.addSubtitle((Title)compositetitle2);
        jFreeChart.addSubtitle((Title)compositetitle3);
        LegendTitle legendee2 = jFreeChart.getLegend(0);
        legendee2.setVisible(false);
        return jFreeChart;
    }

    private IntervalXYDataset createDatasetNumberRequestsUntampered() {
        TimeSeries series = new TimeSeries((Comparable)((Object)"Sent Untampered Requests per Second"));
        if (this.model.getMapLogEntryIntervalUntampered() != null) {
            for (Map.Entry<Integer, LogEntryInterval> log : this.model.getMapLogEntryIntervalUntampered().entrySet()) {
                long currentMsTs = this.model.getTsAttackStart() + (long)log.getValue().getIntervalNumber();
                Date currentDate = new Date(currentMsTs);
                series.add((RegularTimePeriod)new Second(currentDate), (double)log.getValue().getNumberRequests());
            }
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection(series);
        dataset.setXPosition(TimePeriodAnchor.MIDDLE);
        return dataset;
    }

    private IntervalXYDataset createDatasetNumberRequestsTampered() {
        TimeSeries series = new TimeSeries((Comparable)((Object)"Sent Tampered Requests per Second"));
        if (this.model.getMapLogEntryIntervalTampered() != null) {
            for (Map.Entry<Integer, LogEntryInterval> log : this.model.getMapLogEntryIntervalTampered().entrySet()) {
                long currentMsTs = this.model.getTsAttackStart() + (long)log.getValue().getIntervalNumber();
                Date currentDate = new Date(currentMsTs);
                series.add((RegularTimePeriod)new Second(currentDate), (double)log.getValue().getNumberRequests());
            }
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection(series);
        dataset.setXPosition(TimePeriodAnchor.MIDDLE);
        return dataset;
    }

    private synchronized XYDataset createDatasetResponseTime(String type) {
        Map<Integer, LogEntryInterval> currentMap = null;
        String name = null;
        if (type.equals("tampered")) {
            currentMap = this.model.getMapLogEntryIntervalTampered();
            name = "Mean Response Time Tampered Requests";
        } else if (type.equals("untampered")) {
            currentMap = this.model.getMapLogEntryIntervalUntampered();
            name = "Mean Response Time Untampered Requests";
        } else if (type.equals("testprobe")) {
            currentMap = this.model.getMapLogEntryIntervalTestProbe();
            name = "Mean Response Time Simulated 3rd Party Requests";
        } else {
            System.out.println("Invalid type");
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        if (currentMap != null) {
            for (Map.Entry<Integer, LogEntryInterval> log : currentMap.entrySet()) {
                long currentMsTs = this.model.getTsAttackStart() + (long)log.getValue().getIntervalNumber();
                Date currentDate = new Date(currentMsTs);
                series.add((RegularTimePeriod)new Second(currentDate), (double)log.getValue().getMeanResponseTime());
            }
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection(series);
        dataset.setXPosition(TimePeriodAnchor.MIDDLE);
        return dataset;
    }
}

