/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.position.MatcherPosition;
import wsattacker.library.intelligentdos.position.Position;
import wsattacker.library.intelligentdos.position.PositionIterator;

public class MatcherPositionIterator
implements PositionIterator {
    private final String xmlWithPlaceholder;
    private final Map<DoSAttack.PayloadPosition, List<Finding>> findingsMap = Maps.newHashMap();
    private final Map<DoSAttack.PayloadPosition, Iterator<Finding>> findingsIteratorMap = Maps.newHashMap();

    public MatcherPositionIterator(String xmlWithPlaceholder) {
        if (StringUtils.isEmpty((CharSequence)xmlWithPlaceholder)) {
            throw new IllegalArgumentException("xmlWithPlaceholder cannot be null or empty!");
        }
        this.xmlWithPlaceholder = xmlWithPlaceholder;
        this.initialize();
    }

    private void initialize() {
        for (DoSAttack.PayloadPosition payloadPosition : DoSAttack.PayloadPosition.values()) {
            Matcher matcher = Pattern.compile(Pattern.quote(payloadPosition.placeholder())).matcher(this.xmlWithPlaceholder);
            ArrayList findings = Lists.newArrayList();
            int position = 1;
            while (matcher.find()) {
                Finding finding = new Finding();
                finding.placeholder = matcher.group();
                finding.start = matcher.start();
                finding.end = matcher.end();
                finding.position = position++;
                findings.add(finding);
            }
            for (Finding finding : findings) {
                finding.count = findings.size();
            }
            this.findingsMap.put(payloadPosition, findings);
            this.findingsIteratorMap.put(payloadPosition, findings.iterator());
        }
    }

    @Override
    public boolean hasNext(DoSAttack.PayloadPosition payloadPosition) {
        Iterator<Finding> iterator = this.findingsIteratorMap.get((Object)payloadPosition);
        if (iterator != null) {
            return iterator.hasNext();
        }
        return false;
    }

    @Override
    public Position next(DoSAttack.PayloadPosition payloadPosition) {
        Iterator<Finding> iterator = this.findingsIteratorMap.get((Object)payloadPosition);
        if (iterator != null) {
            return new MatcherPosition(this.xmlWithPlaceholder, iterator.next());
        }
        throw new NoSuchElementException();
    }

    @Override
    public void reset() {
        for (Map.Entry<DoSAttack.PayloadPosition, List<Finding>> entry : this.findingsMap.entrySet()) {
            this.findingsIteratorMap.put(entry.getKey(), entry.getValue().iterator());
        }
    }

    public static class Finding {
        String placeholder;
        int start;
        int end;
        int count;
        int position;

        public int hashCode() {
            int result = 31 + this.start;
            result = 31 * result + (this.placeholder == null ? 0 : this.placeholder.hashCode());
            long temp = Double.doubleToLongBits(this.end);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            Finding that = (Finding)obj;
            return this.start == that.start && this.end == that.end && this.placeholder.equals(that.placeholder);
        }
    }
}

