/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos;

import wsattacker.library.intelligentdos.AbstractDoSState;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.PossibleState;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.success.SuccessDecider;

public class TamperedState
extends AbstractDoSState {
    @Override
    public String getName() {
        return "tampered state";
    }

    @Override
    public void update(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        if (!attackModel.wasAttackExecutionSuccessful()) {
            STATE_CONTEXT.setDoSState(new PossibleState());
            STATE_CONTEXT.update(attackModel);
        } else {
            SuccessDecider successDecider = STATE_CONTEXT.getSuccessDecider();
            Long[] currentTampered = attackModel.getDurationArray();
            Long[] currentUntampered = STATE_CONTEXT.getCurrentUntampered();
            boolean successful = successDecider.wasSuccessful(currentUntampered, currentTampered);
            if (successful) {
                double calculateRatio = successDecider.calculateRatio(currentUntampered, currentTampered);
                double d = (double)Math.round(calculateRatio * 100.0) / 100.0;
                String dName = attackModel.getDoSAttack() != null ? attackModel.getDoSAttack().getName() : "???";
                String msg = String.format("First execution of %s was successful (ratio: %s).", dName, d);
                this.logger.info((Object)msg);
                this.setSuccessfulState(STATE_CONTEXT);
            } else {
                this.continueAttacks(STATE_CONTEXT);
            }
        }
    }

    @Override
    public void updateTestProbes(Metric metric) {
    }
}

