/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;
import wsattacker.library.intelligentdos.DoSState;
import wsattacker.library.intelligentdos.FinishState;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.SuspiciousState;
import wsattacker.library.intelligentdos.TamperedState;
import wsattacker.library.intelligentdos.UntamperedState;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.RequestType;
import wsattacker.library.intelligentdos.common.SuccessfulAttack;
import wsattacker.library.intelligentdos.success.Efficiency;
import wsattacker.library.intelligentdos.success.SuccessDecider;

public class SuccessfulState
implements DoSState {
    private final Logger logger = Logger.getLogger(this.getClass());
    private AttackModel untampered;
    private final List<Metric> list = Lists.newArrayList();

    @Override
    public String getName() {
        return "successful state";
    }

    @Override
    public void update(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        SuccessDecider successDecider = STATE_CONTEXT.getSuccessDecider();
        if (this.untampered == null) {
            this.untampered = attackModel;
            double ratio = successDecider.calculateRatio(STATE_CONTEXT.getCurrentUntampered(), attackModel.getDurationArray());
            if (SuspiciousState.isSuspicious(ratio)) {
                STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createNewUntampered(false));
                STATE_CONTEXT.setHasFurtherAttack(true);
                STATE_CONTEXT.setDoSState(new SuspiciousState());
            } else {
                STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createNewTampered(false));
                STATE_CONTEXT.setHasFurtherAttack(true);
            }
        } else {
            Long[] currentUntampered = this.untampered.getDurationArray();
            Long[] currentTampered = attackModel.getDurationArray();
            boolean successful = successDecider.wasSuccessful(currentUntampered, currentTampered);
            Efficiency efficency = successDecider.getEfficency(currentUntampered, currentTampered);
            double ratio = successDecider.calculateRatio(currentUntampered, currentTampered);
            double ratioFormated = (double)Math.round(ratio * 100.0) / 100.0;
            if (successful) {
                String dName = attackModel.getDoSAttack() != null ? attackModel.getDoSAttack().getName() : "???";
                String msg = String.format("%s was successful (ratio: %s)", dName, ratioFormated);
                this.logger.info((Object)msg);
                SuccessfulAttack successfulAttack = this.createSuccessfulAttack(attackModel);
                successfulAttack.setEfficiency(efficency);
                successfulAttack.setRatio(ratio);
                STATE_CONTEXT.addSuccessful(successfulAttack);
                AttackModel createNextAttack = STATE_CONTEXT.createNextAttack(true);
                STATE_CONTEXT.setCurrentAttack(createNextAttack);
                STATE_CONTEXT.setHasFurtherAttack(createNextAttack != null);
                if (createNextAttack != null) {
                    if (createNextAttack.getRequestType() == RequestType.UNTAMPERED) {
                        STATE_CONTEXT.setDoSState(new UntamperedState());
                    } else {
                        STATE_CONTEXT.setDoSState(new TamperedState());
                    }
                } else {
                    STATE_CONTEXT.setDoSState(new FinishState());
                }
            } else {
                String dName = attackModel.getDoSAttack() != null ? attackModel.getDoSAttack().getName() : "???";
                String msg = String.format("%s was not successful (ratio: %s).", dName, ratioFormated);
                this.logger.info((Object)msg);
                STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createNewUntampered(true));
                STATE_CONTEXT.setHasFurtherAttack(true);
                STATE_CONTEXT.setDoSState(new UntamperedState());
            }
        }
    }

    private SuccessfulAttack createSuccessfulAttack(AttackModel attackModel) {
        SuccessfulAttack successfulAttack = new SuccessfulAttack(attackModel.getDoSAttack(), attackModel.getParamItem());
        successfulAttack.setPosition(attackModel.getPosition());
        successfulAttack.setPayloadPosition(attackModel.getPayloadPosition());
        if (attackModel.getPosition() != null && attackModel.getPayloadPosition() != null) {
            successfulAttack.setXmlWithPlaceholder(attackModel.getPosition().createPlaceholder(attackModel.getPayloadPosition()));
        }
        successfulAttack.setUntamperedContent(this.untampered.getRequestContent());
        successfulAttack.setUntamperedMetrics(this.untampered.getMetrics());
        successfulAttack.setTamperedContent(attackModel.getRequestContent());
        successfulAttack.setTamperedMetrics(attackModel.getMetrics());
        successfulAttack.setTestProbes((List<Metric>)ImmutableList.copyOf(this.list));
        return successfulAttack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTestProbes(Metric metric) {
        List<Metric> list = this.list;
        synchronized (list) {
            this.list.add(metric);
        }
    }
}

