/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos;

import wsattacker.library.intelligentdos.AbstractDoSState;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.TamperedState;
import wsattacker.library.intelligentdos.ThresholdState;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.helper.CommonParamItem;

public class PossibleState
extends AbstractDoSState {
    private static final int RESENDS = 1;
    private final CommonParamItem minParamItem = new CommonParamItem(1, 1, 1000);
    private NPS verify = NPS.NONE;
    private int count = 0;
    private AttackModel reference = null;

    @Override
    public String getName() {
        return "possible state";
    }

    @Override
    public void update(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        switch (this.verify) {
            case NONE: {
                this.reference = attackModel;
                if (attackModel.isAllSOAPFault()) {
                    AttackModel min = this.createMinimalUntampered(STATE_CONTEXT);
                    PossibleState.setAttack(STATE_CONTEXT, min);
                } else {
                    PossibleState.createUTR(STATE_CONTEXT);
                }
                ++this.count;
                this.verify = NPS.SERVICE_DOWN;
                break;
            }
            case SERVICE_DOWN: {
                this.verifyServiceDown(STATE_CONTEXT, attackModel);
                break;
            }
            case REVALIDATE: {
                this.revalidateAttackFails(STATE_CONTEXT, attackModel);
                break;
            }
            case PARAM: {
                if (attackModel.isAllFail()) {
                    AttackModel minimalAttack = this.createMinimalDoSAttack(STATE_CONTEXT);
                    this.switchTo(NPS.POSSIBLE, STATE_CONTEXT, minimalAttack);
                    break;
                }
                ThresholdState thresholdState = new ThresholdState(attackModel.getParamItem(), this.reference.getParamItem());
                STATE_CONTEXT.setDoSState(thresholdState);
                STATE_CONTEXT.update(attackModel);
                break;
            }
            case POSSIBLE: {
                if (attackModel.isAllFail()) {
                    STATE_CONTEXT.addNotPossible(attackModel.getDoSAttack());
                    this.continueAttacks(STATE_CONTEXT);
                    break;
                }
                if (!attackModel.wasAttackExecutionSuccessful()) {
                    if (this.count > 1) {
                        this.logger.warn((Object)("Further investigation is not possible! " + attackModel.getErrorCount() + " requests has not been send successfully. Abort execution."));
                        PossibleState.switchToFinishState(STATE_CONTEXT);
                        break;
                    }
                    AttackModel minimalAttack = this.createMinimalDoSAttack(STATE_CONTEXT);
                    PossibleState.setAttack(STATE_CONTEXT, minimalAttack);
                    ++this.count;
                    break;
                }
                ThresholdState thresholdState = new ThresholdState(attackModel, this.reference);
                STATE_CONTEXT.setDoSState(thresholdState);
                STATE_CONTEXT.update(attackModel);
                break;
            }
        }
    }

    private void verifyServiceDown(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        if (attackModel.isAllFail()) {
            if (attackModel.isAllSOAPFault()) {
                this.logger.warn((Object)"The SOAP request seems to be malformed! No request was send successfully. Abort execution.");
            } else {
                this.logger.warn((Object)"Service seems to be down! No request was send successfully. Abort execution.");
            }
            PossibleState.switchToFinishState(STATE_CONTEXT);
        } else if (!attackModel.wasAttackExecutionSuccessful()) {
            if (this.count > 1) {
                this.logger.warn((Object)("Further investigation is not possible! " + attackModel.getErrorCount() + " requests has not been send successfully. Abort execution."));
                PossibleState.switchToFinishState(STATE_CONTEXT);
            } else {
                PossibleState.createUTR(STATE_CONTEXT);
                ++this.count;
            }
        } else {
            this.count = 0;
            AttackModel tampered = STATE_CONTEXT.createNewTampered(true);
            PossibleState.setAttack(STATE_CONTEXT, tampered);
            this.verify = NPS.REVALIDATE;
        }
    }

    private void revalidateAttackFails(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        if (attackModel.isAllFail()) {
            AttackModel minimalAttack = PossibleState.createTRWithParam(STATE_CONTEXT, this.minParamItem);
            ++this.count;
            this.switchTo(NPS.PARAM, STATE_CONTEXT, minimalAttack);
        } else if (attackModel.wasAttackExecutionSuccessful()) {
            if (this.count >= 1) {
                STATE_CONTEXT.setDoSState(new TamperedState());
                STATE_CONTEXT.update(attackModel);
            } else {
                AttackModel tampered = STATE_CONTEXT.createNewTampered(true);
                PossibleState.setAttack(STATE_CONTEXT, tampered);
                ++this.count;
            }
        } else {
            AttackModel minimalAttack = PossibleState.createTRWithParam(STATE_CONTEXT, this.minParamItem);
            ++this.count;
            this.switchTo(NPS.PARAM, STATE_CONTEXT, minimalAttack);
        }
    }

    private void switchTo(NPS verify, IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        this.count = 0;
        PossibleState.setAttack(STATE_CONTEXT, attackModel);
        this.verify = verify;
    }

    private AttackModel createMinimalDoSAttack(IntelligentDoSLibraryImpl STATE_CONTEXT) {
        DoSAttack minimal = this.reference.getDoSAttack().minimal();
        AttackModel tampered = STATE_CONTEXT.createNewTampered(minimal);
        return tampered;
    }

    private AttackModel createMinimalUntampered(IntelligentDoSLibraryImpl STATE_CONTEXT) {
        DoSAttack minimal = this.reference.getDoSAttack().minimal();
        AttackModel untampered = STATE_CONTEXT.createNewUntampered(minimal);
        return untampered;
    }

    @Override
    public void updateTestProbes(Metric metric) {
    }

    private static enum NPS {
        NONE,
        SERVICE_DOWN,
        REVALIDATE,
        PARAM,
        POSSIBLE;

    }
}

