/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.schemaanalyzer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wsattacker.library.schemaanalyzer.AnyElementProperties;
import wsattacker.library.schemaanalyzer.AnyElementPropertiesImpl;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class SchemaAnalyzerImpl
implements SchemaAnalyzer {
    private static final Logger LOG = Logger.getLogger(SchemaAnalyzerImpl.class);
    Document analyzingDocument = null;
    Document expandedAnalyzingDocument = null;
    Map<String, Document> schemaMap = new HashMap<String, Document>();
    List<QName> filterList = new ArrayList<QName>();

    public Document getExpandedAnalyzingDocument() {
        return this.expandedAnalyzingDocument;
    }

    public Document getAnalyzingDocument() {
        return this.analyzingDocument;
    }

    @Override
    public List<QName> getFilterList() {
        return this.filterList;
    }

    @Override
    public void setFilterList(List<QName> filterList) {
        this.filterList = filterList;
    }

    @Override
    public void appendSchema(Document newSchema) {
        Element newSchemaRoot = newSchema.getDocumentElement();
        if (newSchema != null && "http://www.w3.org/2001/XMLSchema".equals(newSchemaRoot.getNamespaceURI()) && "schema".equals(newSchemaRoot.getLocalName())) {
            String targetNamespace = newSchema.getDocumentElement().getAttribute("targetNamespace");
            this.schemaMap.put(targetNamespace, newSchema);
        }
    }

    public void clearSchemas() {
        this.schemaMap.clear();
    }

    public boolean isInCurrentAnalysis(Node n) {
        boolean result = this.analyzingDocument != null && n.getOwnerDocument().getDocumentElement().isEqualNode(this.analyzingDocument.getDocumentElement());
        LOG.trace((Object)String.format("isInCurrent: %b", result));
        return result;
    }

    @Override
    public Set<AnyElementProperties> findExpansionPoint(Element fromHere) {
        if (!this.isInCurrentAnalysis(fromHere)) {
            LOG.trace((Object)"New Document to analyze!");
            this.expandedAnalyzingDocument = DomUtilities.createNewDomFromNode((Node)fromHere.getOwnerDocument().getDocumentElement());
            this.analyzingDocument = fromHere.getOwnerDocument();
        }
        Document expandedDoc = this.expandedAnalyzingDocument;
        Element start = DomUtilities.findCorrespondingElement((Document)expandedDoc, (Element)fromHere);
        TreeSet<AnyElementProperties> result = new TreeSet<AnyElementProperties>();
        this.findExpansionPoint(result, start);
        return result;
    }

    private void findExpansionPoint(Set<AnyElementProperties> result, Element start) {
        LOG.trace((Object)("Find expansion point of Element '" + start.getNodeName() + "'"));
        if (this.filterList.contains(new QName(start.getNamespaceURI(), start.getLocalName()))) {
            LOG.trace((Object)"\tFound in filterList -> Abort");
            return;
        }
        List<Element> possibleChildElementList = this.findPossibleChildElements(start);
        boolean hasAny = false;
        for (Element possibleChild : possibleChildElementList) {
            if ("any".equals(possibleChild.getLocalName())) {
                if (hasAny) continue;
                hasAny = true;
                result.add(new AnyElementPropertiesImpl(possibleChild, start));
                LOG.trace((Object)"\t-> xs:any <- allowed!");
                continue;
            }
            String localName = possibleChild.getAttribute("name");
            String[] prefixNamespacePair = this.getTargetNamespace(possibleChild);
            LOG.trace((Object)("\tAllowed Child: '" + prefixNamespacePair[1] + ":" + localName + "'"));
            if (!DomUtilities.findChildren((Node)start, (String)localName, (String)prefixNamespacePair[1], (boolean)false).isEmpty()) continue;
            if (this.elementHasSpecificAncestor(start, localName, prefixNamespacePair[1])) {
                LOG.trace((Object)"\t\tAncestor with same name already exists -> *NOT* Created");
                continue;
            }
            this.createChildElementForElement(start, localName, prefixNamespacePair[1], prefixNamespacePair[0]);
            LOG.trace((Object)"\t\tDoes not exist -> Created");
        }
        NodeList theChildren = start.getChildNodes();
        for (int i = 0; i < theChildren.getLength(); ++i) {
            if (theChildren.item(i).getNodeType() != 1) continue;
            this.findExpansionPoint(result, (Element)theChildren.item(i));
        }
    }

    public boolean elementHasSpecificAncestor(Element theElement, String ancestorLocalName, String ancestorNamespaceURI) {
        boolean ret = false;
        for (Node up = theElement.getParentNode(); up != null && up.getNodeType() == 1; up = up.getParentNode()) {
            if (!up.getNamespaceURI().equals(ancestorNamespaceURI) || !up.getLocalName().equals(ancestorLocalName)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void createChildElementForElement(Element theElement, String localName, String namespaceURI, String fallbackPrefix) {
        String prefix = DomUtilities.getPrefix((Node)theElement, (String)namespaceURI);
        if (prefix == null) {
            prefix = fallbackPrefix;
            if (prefix == null) {
                prefix = "";
            }
        } else if (!prefix.isEmpty()) {
            prefix = prefix + ':';
        }
        LOG.info((Object)String.format("\t-> Creating element %s:%s%s", namespaceURI, prefix, localName));
        theElement.appendChild(theElement.getOwnerDocument().createElementNS(theElement.getNamespaceURI(), prefix + localName));
    }

    public List<Element> findPossibleChildElements(Element element) {
        return this.findPossibleChildElements(element.getNamespaceURI(), element.getLocalName());
    }

    public List<Element> findPossibleChildElements(String namespaceURI, String localName) {
        Element elementSchema = this.findElementInSchema(namespaceURI, localName);
        if (elementSchema == null) {
            LOG.info((Object)String.format("Could not find any child elements for element '%s:%s'", namespaceURI, localName));
            return new ArrayList<Element>();
        }
        Element complexType = this.findComplexTypeForElement(elementSchema);
        if (complexType == null) {
            LOG.info((Object)String.format("Element '%s:%s' seems to not to have a complex declaration.", namespaceURI, localName));
            return new ArrayList<Element>();
        }
        List refferingElementList = DomUtilities.findChildren((Node)complexType, (String)"element", (String)"http://www.w3.org/2001/XMLSchema", (boolean)true);
        List possibleChildElementList = DomUtilities.findChildren((Node)complexType, (String)"any", (String)"http://www.w3.org/2001/XMLSchema", (boolean)true);
        for (Element referringElement : refferingElementList) {
            Element schemaElement = this.dereferenceElement(referringElement);
            if (schemaElement == null) continue;
            possibleChildElementList.add(schemaElement);
        }
        return possibleChildElementList;
    }

    public Element findComplexTypeInSchema(String namespaceURI, String elementTypeLocalName) {
        return this.findXInSchema("complexType", namespaceURI, elementTypeLocalName);
    }

    public Element findElementInSchema(String namespaceURI, String localName) {
        return this.findXInSchema("element", namespaceURI, localName);
    }

    private Element findXInSchema(String x, String namespaceURI, String localName) {
        List complexTypeList;
        Document theSchema = this.schemaMap.get(namespaceURI);
        if (theSchema == null) {
            return null;
        }
        String xpath = "//*[local-name()='" + x + "' and namespace-uri()='" + "http://www.w3.org/2001/XMLSchema" + "' and @name='" + localName + "']";
        try {
            complexTypeList = DomUtilities.evaluateXPath((Document)theSchema, (String)xpath);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid XPath. This should never happen.", e);
        }
        if (complexTypeList.size() == 0) {
            return null;
        }
        if (complexTypeList.size() > 1) {
            LOG.warn((Object)String.format("More than one possible schema definition found for %s:%s", namespaceURI, localName));
        }
        return (Element)complexTypeList.get(0);
    }

    public Element dereferenceElement(Element referringElement) {
        Element elementSchema = null;
        String ref = referringElement.getAttribute("ref");
        int colonPosition = ref.indexOf(58);
        if (colonPosition > 0) {
            String elementTypeLocalName = ref.substring(colonPosition + 1);
            String elementPrefix = ref.substring(0, colonPosition);
            String elementNamespaceURI = DomUtilities.getNamespaceURI((Node)referringElement, (String)elementPrefix);
            elementSchema = this.findElementInSchema(elementNamespaceURI, elementTypeLocalName);
        }
        return elementSchema;
    }

    public Element findComplexTypeForElement(Element elementSchema) {
        Element compexTypeSchema = null;
        String type = elementSchema.getAttribute("type");
        if (type.isEmpty()) {
            List complexChildElementList = DomUtilities.findChildren((Node)elementSchema, (String)"complexType", (String)"http://www.w3.org/2001/XMLSchema", (boolean)true);
            if (!complexChildElementList.isEmpty()) {
                compexTypeSchema = (Element)complexChildElementList.get(0);
            }
        } else {
            int colonPosition = type.indexOf(58);
            if (colonPosition > 0) {
                String elementTypeLocalName = type.substring(colonPosition + 1);
                String elementPrefix = type.substring(0, colonPosition);
                String elementNamespaceURI = DomUtilities.getNamespaceURI((Node)elementSchema, (String)elementPrefix);
                compexTypeSchema = this.findComplexTypeInSchema(elementNamespaceURI, elementTypeLocalName);
            }
        }
        return compexTypeSchema;
    }

    public String[] getTargetNamespace(Element x) {
        Node parent = x;
        while (!((parent = parent.getParentNode()) != null && "schema".equals(parent.getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(parent.getNamespaceURI()) || parent == null)) {
        }
        if (!(parent instanceof Element)) {
            return new String[]{"", ""};
        }
        Element p = (Element)parent;
        String targetNS = p.getAttribute("targetNamespace");
        String prefix = "";
        if (targetNS.isEmpty()) {
            return new String[]{prefix, targetNS};
        }
        NamedNodeMap attributes = parent.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getPrefix() == null || !attribute.getPrefix().equals("xmlns") || !attribute.getTextContent().equals(targetNS)) continue;
            prefix = attribute.getLocalName();
            break;
        }
        return new String[]{prefix, targetNS};
    }
}

