/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.schemaanalyzer;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import wsattacker.library.schemaanalyzer.NullSchemaAnalyzer;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.schemaanalyzer.SchemaAnalyzerImpl;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public final class SchemaAnalyzerFactory {
    public static final String SCHEMA_DIRECTORY = "/XML Schema/";
    public static final String NULL = "NULL";
    public static final String EMPTY = "EMPTY";
    public static final String ALL = "ALL";
    public static final String MINIMAL = "MINIMAL";
    public static final String SAML = "SAML";
    public static final String SAML11 = "SAML11";
    public static final String SAML20 = "SAML20";
    public static final String WEBSERVICE = "Web Service";
    private static final String[] SCHEMAFILES_MINIMAL = new String[]{"xmldsig-core-schema.xsd", "xmldsig11-schema.xsd", "xmldsig-filter2.xsd"};
    private static final String[] SCHEMAFILES_WEBVSERVICE = new String[]{"soap11.xsd", "soap12.xsd", "wsa.xsd", "wssec-1.0.xsd", "wssec-1.1.xsd", "wsu.xsd"};
    private static final String[] SCHEMAFILES_SAML11 = new String[]{"saml11.xsd", "saml11p.xsd"};
    private static final String[] SCHEMAFILES_SAML20 = new String[]{"saml20.xsd", "saml20p.xsd", "saml-metadata-ext-query.xsd", "saml-metadata-ui-v1.0.xsd", "saml-schema-authn-context-types-2.0.xsd", "saml-schema-metadata-2.0.xsd"};

    public static SchemaAnalyzer getInstance() {
        return new SchemaAnalyzerImpl();
    }

    public static SchemaAnalyzer getInstance(String IDENTIFIER) {
        SchemaAnalyzer schemaAnalyzer = null;
        if (IDENTIFIER == null || IDENTIFIER.equals(NULL)) {
            schemaAnalyzer = new NullSchemaAnalyzer();
        } else {
            schemaAnalyzer = SchemaAnalyzerFactory.getInstance();
            if (!IDENTIFIER.equals(EMPTY)) {
                SchemaAnalyzerFactory.addSchemasToAnalyzer(schemaAnalyzer, SCHEMAFILES_MINIMAL);
            }
            if (IDENTIFIER.equals(WEBSERVICE) || IDENTIFIER.equals(ALL)) {
                SchemaAnalyzerFactory.addSchemasToAnalyzer(schemaAnalyzer, SCHEMAFILES_WEBVSERVICE);
            }
            if (IDENTIFIER.equals(SAML11) || IDENTIFIER.equals(SAML) || IDENTIFIER.equals(ALL)) {
                SchemaAnalyzerFactory.addSchemasToAnalyzer(schemaAnalyzer, SCHEMAFILES_SAML11);
            }
            if (IDENTIFIER.equals(SAML20) || IDENTIFIER.equals(SAML) || IDENTIFIER.equals(ALL)) {
                SchemaAnalyzerFactory.addSchemasToAnalyzer(schemaAnalyzer, SCHEMAFILES_SAML20);
            }
        }
        return schemaAnalyzer;
    }

    public static Document getSchemaDocument(String identifier) throws SAXException, IOException {
        String filename = SCHEMA_DIRECTORY + identifier;
        try {
            return DomUtilities.readDocument((InputStream)SchemaAnalyzerFactory.class.getResourceAsStream(filename));
        }
        catch (SAXException ex) {
            Logger.getLogger(SchemaAnalyzerFactory.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IOException ex) {
            Logger.getLogger(SchemaAnalyzerFactory.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
    }

    private static void addSchemasToAnalyzer(SchemaAnalyzer schemaAnalyzer, String[] schemaFiles) {
        for (String cur : schemaFiles) {
            Document xsd;
            try {
                xsd = SchemaAnalyzerFactory.getSchemaDocument(cur);
            }
            catch (SAXException ex) {
                continue;
            }
            catch (IOException ex) {
                continue;
            }
            schemaAnalyzer.appendSchema(xsd);
        }
    }

    private SchemaAnalyzerFactory() {
    }
}

