/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.internal.filter.eval.ExpressionEvaluator;
import com.jayway.jsonpath.spi.JsonProvider;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArrayEvalFilter
extends PathTokenFilter {
    private static final Pattern CONDITION_STATEMENT_PATTERN = Pattern.compile("\\[\\s?\\?\\(.*?[!=<>]+.*?\\)\\s?]");
    private static final Pattern PATTERN = Pattern.compile("\\s?(@.*?)\\s?([!=<>]+)\\s?(.*?)\\s?");
    private ConditionStatement[] conditionStatements;

    public ArrayEvalFilter(String condition) {
        super(condition);
        condition = condition.trim();
        condition = condition.substring(3, condition.length() - 2);
        String[] split = condition.split("&&");
        this.conditionStatements = new ConditionStatement[split.length];
        for (int i = 0; i < split.length; ++i) {
            this.conditionStatements[i] = ArrayEvalFilter.createConditionStatement(split[i]);
        }
    }

    @Override
    public Object filter(Object obj, Configuration configuration) {
        JsonProvider jsonProvider = configuration.getProvider();
        Iterable<Object> src = null;
        try {
            src = jsonProvider.toIterable(obj);
        }
        catch (ClassCastException e) {
            throw new PathNotFoundException("The path fragment '" + this.condition + "' can not be applied to a JSON object only a JSON array.", e);
        }
        Iterable result = jsonProvider.createArray();
        for (Object item : src) {
            if (!this.isMatch(item, configuration, this.conditionStatements)) continue;
            jsonProvider.setProperty(result, jsonProvider.length(result), item);
        }
        return result;
    }

    @Override
    public Object getRef(Object obj, Configuration configuration) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public boolean isArrayFilter() {
        return true;
    }

    private boolean isMatch(Object check, Configuration configuration, ConditionStatement ... conditionStatements) {
        try {
            for (ConditionStatement conditionStatement : conditionStatements) {
                Object value = conditionStatement.path.read(check, configuration.options(Option.THROW_ON_MISSING_PROPERTY));
                boolean match = ExpressionEvaluator.eval(value, conditionStatement.getOperator(), conditionStatement.getExpected());
                if (match) continue;
                return false;
            }
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    static boolean isConditionStatement(String condition) {
        return CONDITION_STATEMENT_PATTERN.matcher(condition).matches();
    }

    static ConditionStatement createConditionStatement(String condition) {
        Matcher matcher = PATTERN.matcher(condition);
        if (matcher.matches()) {
            String property = matcher.group(1).trim();
            String operator = matcher.group(2).trim();
            String expected = matcher.group(3).trim();
            return new ConditionStatement(condition, property, operator, expected);
        }
        return null;
    }

    static class ConditionStatement {
        private final String condition;
        private final String field;
        private final String operator;
        private final String expected;
        private final JsonPath path;

        ConditionStatement(String condition, String field, String operator, String expected) {
            this.condition = condition;
            this.field = field;
            this.operator = operator;
            this.expected = expected.startsWith("'") ? PathTokenFilter.trim(expected, 1, 1) : expected;
            this.path = field.startsWith("@.") ? JsonPath.compile(this.field.replace("@.", "$."), new Filter[0]) : JsonPath.compile(this.field.replace("@", "$"), new Filter[0]);
        }

        ConditionStatement(String field, String operator, String expected) {
            this(null, field, operator, expected);
        }

        String getCondition() {
            return this.condition;
        }

        public JsonPath getJsonPath() {
            return this.path;
        }

        public String getField() {
            return this.field;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getExpected() {
            return this.expected;
        }

        public String toString() {
            return "ConditionStatement{field='" + this.field + '\'' + ", operator='" + this.operator + '\'' + ", expected='" + this.expected + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionStatement that = (ConditionStatement)o;
            if (this.expected != null ? !this.expected.equals(that.expected) : that.expected != null) {
                return false;
            }
            if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
                return false;
            }
            return !(this.operator != null ? !this.operator.equals(that.operator) : that.operator != null);
        }

        public int hashCode() {
            int result = this.field != null ? this.field.hashCode() : 0;
            result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
            result = 31 * result + (this.expected != null ? this.expected.hashCode() : 0);
            return result;
        }
    }
}

