/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.easymock.CaptureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Capture<T>
implements Serializable {
    private static final long serialVersionUID = -4214363692271370781L;
    private CaptureType type;
    private final List<T> values = new ArrayList<T>(2);

    @Deprecated
    public Capture() {
        this(CaptureType.LAST);
    }

    @Deprecated
    public Capture(CaptureType type) {
        this.type = type;
    }

    public static <T> Capture<T> newInstance() {
        return new Capture<T>();
    }

    public static <T> Capture<T> newInstance(CaptureType type) {
        return new Capture<T>(type);
    }

    public void reset() {
        this.values.clear();
    }

    public boolean hasCaptured() {
        return !this.values.isEmpty();
    }

    public T getValue() {
        if (this.values.isEmpty()) {
            throw new AssertionError((Object)"Nothing captured yet");
        }
        if (this.values.size() > 1) {
            throw new AssertionError((Object)("More than one value captured: " + this.getValues()));
        }
        return this.values.get(0);
    }

    public List<T> getValues() {
        return this.values;
    }

    public void setValue(T value) {
        switch (this.type) {
            case NONE: {
                break;
            }
            case ALL: {
                this.values.add(value);
                break;
            }
            case FIRST: {
                if (this.hasCaptured()) break;
                this.values.add(value);
                break;
            }
            case LAST: {
                if (this.hasCaptured()) {
                    this.reset();
                }
                this.values.add(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown capture type: " + (Object)((Object)this.type));
            }
        }
    }

    public String toString() {
        if (this.values.isEmpty()) {
            return "Nothing captured yet";
        }
        if (this.values.size() == 1) {
            return String.valueOf(this.values.get(0));
        }
        return this.values.toString();
    }
}

