/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.desktop;

import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.ui.desktop.DesktopFactory;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import java.util.HashMap;
import java.util.Map;

public class DesktopRegistry {
    private static DesktopRegistry instance;
    private Map<String, DesktopFactory> factories = new HashMap<String, DesktopFactory>();

    public static DesktopRegistry getInstance() {
        if (instance == null) {
            instance = new DesktopRegistry();
        }
        return instance;
    }

    public void addDesktop(String name, DesktopFactory factory) {
        this.factories.put(name, factory);
    }

    public String[] getNames() {
        return this.factories.keySet().toArray(new String[this.factories.size()]);
    }

    public SoapUIDesktop createDesktop(String desktopType, Workspace workspace) {
        if (this.factories.containsKey(desktopType)) {
            return this.factories.get(desktopType).createDesktop(workspace);
        }
        return null;
    }
}

