/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.propertyexpansion;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.support.propertyexpansion.AbstractPropertyExpansionTarget;
import java.awt.Point;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class RSyntaxTextAreaPropertyExpansionTarget
extends AbstractPropertyExpansionTarget {
    private final RSyntaxTextArea textField;

    public RSyntaxTextAreaPropertyExpansionTarget(RSyntaxTextArea textField, ModelItem modelItem) {
        super(modelItem);
        this.textField = textField;
    }

    @Override
    public void insertPropertyExpansion(PropertyExpansion expansion, Point pt) {
        int pos;
        int n = pos = pt == null ? -1 : this.textField.viewToModel(pt);
        if (pos == -1) {
            pos = this.textField.getCaretPosition();
        }
        try {
            this.textField.setText(this.textField.getText(0, pos) + expansion.toString() + this.textField.getText(pos, this.textField.getText().length() - this.textField.getText(0, pos).length()));
        }
        catch (BadLocationException e) {
            SoapUI.logError(e, "Unable to insert property expansion");
        }
        if (pos >= 0) {
            this.textField.setCaretPosition(pos);
            this.textField.requestFocusInWindow();
        }
    }

    @Override
    public String getValueForCreation() {
        return this.textField.getSelectedText();
    }

    @Override
    public String getNameForCreation() {
        return this.textField.getName();
    }
}

