/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.model.security.SecurityParametersTableModel;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.security.actions.CloneParametersAction;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.scan.BoundarySecurityScan;
import com.eviware.soapui.security.scan.InvalidTypesSecurityScan;
import com.eviware.soapui.security.ui.XPathCellRender;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.JTableFactory;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JComboBoxFormField;
import com.eviware.x.impl.swing.JFormDialog;
import com.eviware.x.impl.swing.JTextFieldFormField;
import com.eviware.x.impl.swing.SwingXFormDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;

public class SecurityCheckedParametersTablePanel
extends JPanel
implements ListSelectionListener {
    protected static final int LABEL_NAME_COLUMN_WIDTH = 120;
    protected static final int ENABLE_COLUMN_WIDTH = 70;
    static final String CHOOSE_TEST_PROPERTY = "Choose Test Property";
    protected SecurityParametersTableModel model;
    protected JXToolBar toolbar;
    protected JXTable table;
    protected Map<String, TestProperty> properties;
    protected DefaultActionList actionList;
    protected JUndoableTextArea pathPane;
    protected XFormDialog dialog;
    protected AbstractSecurityScanWithProperties securityScan;

    public SecurityCheckedParametersTablePanel(SecurityParametersTableModel model, Map<String, TestProperty> properties, AbstractSecurityScanWithProperties securityCheck) {
        this.securityScan = securityCheck;
        this.model = model;
        this.initRequestPartProperties(properties);
        this.init();
        this.defineColumnWidth();
        this.setPreferredSize(new Dimension(100, 100));
    }

    private void initRequestPartProperties(Map<String, TestProperty> properties) {
        this.properties = new HashMap<String, TestProperty>();
        for (Map.Entry<String, TestProperty> entry : properties.entrySet()) {
            if (!properties.get(entry.getKey()).isRequestPart()) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.toolbar = UISupport.createToolbar();
        this.toolbar.add(UISupport.createToolbarButton(new AddNewParameterAction()));
        this.toolbar.add(UISupport.createToolbarButton(new RemoveParameterAction()));
        this.toolbar.add(UISupport.createToolbarButton(new CopyParameterAction()));
        this.toolbar.add(UISupport.createToolbarButton(new CloneParametersAction(this.securityScan)));
        this.toolbar.addGlue();
        this.add((Component)this.toolbar, "North");
        this.table = JTableFactory.getInstance().makeJXTable(this.model);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.defineColumnWidth();
        this.table.setDefaultEditor(String.class, this.getDefaultCellEditor());
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.add((Component)scrollPane, "Center");
        this.pathPane = new JUndoableTextArea();
        if (this.securityScan instanceof BoundarySecurityScan) {
            ((BoundarySecurityScan)this.securityScan).refreshRestrictionLabel(-1);
        }
        if (this.securityScan instanceof InvalidTypesSecurityScan) {
            ((InvalidTypesSecurityScan)this.securityScan).refreshRestrictionLabel(-1);
        }
    }

    protected void defineColumnWidth() {
        TableColumn col = this.table.getColumnModel().getColumn(3);
        col.setMaxWidth(70);
        col.setPreferredWidth(70);
        col.setMinWidth(70);
        col = this.table.getColumnModel().getColumn(0);
        col.setMaxWidth(120);
        col.setPreferredWidth(120);
        col.setMinWidth(120);
        col = this.table.getColumnModel().getColumn(1);
        col.setMaxWidth(120);
        col.setPreferredWidth(120);
        col.setMinWidth(120);
    }

    protected TableCellEditor getDefaultCellEditor() {
        return new XPathCellRender();
    }

    public XFormDialog getDialog() {
        return this.dialog;
    }

    protected XFormDialog createAddParameterDialog() {
        this.actionList = new DefaultActionList();
        AddAction addAction = new AddAction();
        this.actionList.addAction(addAction, true);
        AddAndCopy addAndCopy = new AddAndCopy();
        this.actionList.addAction(addAndCopy);
        Close closeAction = new Close();
        this.actionList.addAction(closeAction);
        this.dialog = ADialogBuilder.buildDialog(AddParameterDialog.class, (ActionList)this.actionList, false);
        this.dialog.getFormField("XPath").setProperty("component", this.buildPathSelector());
        closeAction.setDialog(this.dialog);
        addAction.setDialog(this.dialog);
        addAndCopy.setDialog(this.dialog);
        final JTextFieldFormField labelField = (JTextFieldFormField)this.dialog.getFormField("Parameter Label");
        ((JUndoableTextField)labelField.getComponent()).setColumns(30);
        labelField.setEnabled(false);
        JComboBoxFormField nameField = (JComboBoxFormField)this.dialog.getFormField("Parameter Name");
        this.enablePathField(false);
        nameField.addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                if (!newValue.equals(SecurityCheckedParametersTablePanel.CHOOSE_TEST_PROPERTY)) {
                    labelField.setEnabled(true);
                    SecurityCheckedParametersTablePanel.this.enablePathField(true);
                } else {
                    labelField.setEnabled(false);
                    SecurityCheckedParametersTablePanel.this.enablePathField(false);
                }
            }
        });
        ArrayList<String> options = new ArrayList<String>();
        options.add(CHOOSE_TEST_PROPERTY);
        options.addAll(this.properties.keySet());
        nameField.setOptions(options.toArray(new String[0]));
        ((JFormDialog)this.dialog).getDialog().setResizable(false);
        return this.dialog;
    }

    protected JPanel buildPathSelector() {
        JPanel sourcePanel = new JPanel(new BorderLayout());
        sourcePanel.add((Component)new JScrollPane(this.pathPane), "Center");
        sourcePanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        return sourcePanel;
    }

    protected void enablePathField(boolean enable) {
        this.pathPane.setEnabled(enable);
    }

    private void initDialogForCopy(XFormDialog dialog, int row) {
        dialog.setValue("Parameter Label", (String)this.model.getValueAt(row, 0));
        dialog.setValue("Parameter Name", (String)this.model.getValueAt(row, 1));
        this.pathPane.setText((String)this.model.getValueAt(row, 2));
    }

    public JUndoableTextArea getPathPane() {
        return this.pathPane;
    }

    public JUndoableTextField getLabel() {
        return (JUndoableTextField)((JTextFieldFormField)this.dialog.getFormField("Parameter Label")).getComponent();
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)lse.getSource();
        if (this.securityScan instanceof BoundarySecurityScan) {
            ((BoundarySecurityScan)this.securityScan).refreshRestrictionLabel(dlsm.getAnchorSelectionIndex());
        }
        if (this.securityScan instanceof InvalidTypesSecurityScan) {
            ((InvalidTypesSecurityScan)this.securityScan).refreshRestrictionLabel(dlsm.getAnchorSelectionIndex());
        }
    }

    @AForm(description="Add New Security Test Step Parameter", name="Configure Security Test Step Parameters", helpUrl="http://www.soapui.org/Security/security-scans-overview.html")
    static interface AddParameterDialog {
        @AField(description="Parameter Name", name="Parameter Name", type=AField.AFieldType.ENUMERATION)
        public static final String NAME = "Parameter Name";
        @AField(description="Parameter Label", name="Parameter Label", type=AField.AFieldType.STRING)
        public static final String LABEL = "Parameter Label";
        @AField(description="Parameter XPath", name="XPath", type=AField.AFieldType.COMPONENT)
        public static final String PATH = "XPath";
    }

    private class AddAction
    extends AbstractAction {
        private XFormDialog dialog;

        public AddAction() {
            super("Add");
        }

        public void setDialog(XFormDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.dialog.getValue("Parameter Label") == null || this.dialog.getValue("Parameter Label").trim().length() == 0) {
                UISupport.showErrorMessage("Label is required!");
            } else if (SecurityCheckedParametersTablePanel.this.model.addParameter(this.dialog.getValue("Parameter Label"), this.dialog.getValue("Parameter Name"), SecurityCheckedParametersTablePanel.this.pathPane.getText())) {
                JComboBoxFormField nameField = (JComboBoxFormField)this.dialog.getFormField("Parameter Name");
                nameField.setSelectedOptions(new Object[]{nameField.getOptions()[0]});
                this.dialog.setValue("Parameter Label", "");
                SecurityCheckedParametersTablePanel.this.pathPane.setText("");
            } else {
                UISupport.showErrorMessage("Label have to be unique!");
            }
        }
    }

    class CopyParameterAction
    extends AbstractAction {
        public CopyParameterAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/copy_parameters.gif"));
            this.putValue("ShortDescription", "Copies parameter");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SecurityCheckedParametersTablePanel.this.table.getSelectedRow() > -1) {
                XFormDialog dialog = SecurityCheckedParametersTablePanel.this.createAddParameterDialog();
                int row = SecurityCheckedParametersTablePanel.this.table.getSelectedRow();
                SecurityCheckedParametersTablePanel.this.initDialogForCopy(dialog, row);
                dialog.show();
                SecurityCheckedParametersTablePanel.this.model.fireTableDataChanged();
            }
        }
    }

    private class Close
    extends AbstractAction {
        private XFormDialog dialog;

        public Close() {
            super("Close");
        }

        public void setDialog(XFormDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog != null) {
                ((SwingXFormDialog)this.dialog).setReturnValue(2);
                JComboBoxFormField nameField = (JComboBoxFormField)this.dialog.getFormField("Parameter Name");
                nameField.setSelectedOptions(new Object[]{nameField.getOptions()[0]});
                this.dialog.setValue("Parameter Label", "");
                SecurityCheckedParametersTablePanel.this.pathPane.setText("");
                this.dialog.setVisible(false);
            }
        }
    }

    public class AddAndCopy
    extends AbstractAction {
        private XFormDialog dialog;

        public AddAndCopy() {
            super("Add&Copy");
        }

        public void setDialog(XFormDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog.getValue("Parameter Label") == null || this.dialog.getValue("Parameter Label").trim().length() == 0) {
                UISupport.showErrorMessage("Label is required!");
            } else if (!SecurityCheckedParametersTablePanel.this.model.addParameter(this.dialog.getValue("Parameter Label"), this.dialog.getValue("Parameter Name"), SecurityCheckedParametersTablePanel.this.pathPane.getText())) {
                UISupport.showErrorMessage("Label have to be unique!");
            }
        }
    }

    class RemoveParameterAction
    extends AbstractAction {
        public RemoveParameterAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes parameter from security scan");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityCheckedParametersTablePanel.this.model.removeRows(SecurityCheckedParametersTablePanel.this.table.getSelectedRows());
            SecurityCheckedParametersTablePanel.this.model.fireTableDataChanged();
        }
    }

    class AddNewParameterAction
    extends AbstractAction {
        public AddNewParameterAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a parameter to security scan");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XFormDialog dialog = SecurityCheckedParametersTablePanel.this.createAddParameterDialog();
            dialog.show();
            SecurityCheckedParametersTablePanel.this.model.fireTableDataChanged();
        }
    }
}

