/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.panels;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuiteListener;
import com.eviware.soapui.security.Securable;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestListener;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.actions.CloneParametersAction;
import com.eviware.soapui.security.log.JSecurityTestRunLog;
import com.eviware.soapui.security.panels.SecurityScanNode;
import com.eviware.soapui.security.panels.SecurityScanTree;
import com.eviware.soapui.security.panels.SecurityTreeCellRender;
import com.eviware.soapui.security.panels.SecurityTreeRootNode;
import com.eviware.soapui.security.panels.TestStepNode;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.support.SecurityTestRunListenerAdapter;
import com.eviware.soapui.security.ui.SecurityConfigurationDialog;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.TreePathUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTree;

public class JSecurityTestTestStepList
extends JPanel
implements TreeSelectionListener,
MouseListener,
SecurityTestListener {
    private SecurityTest securityTest;
    private final TestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private JXTree securityTestTree;
    private AddSecurityScanAction addSecurityScanAction;
    private ConfigureSecurityScanAction configureSecurityScanAction;
    private RemoveSecurityScanAction removeSecurityScanAction;
    private CloneParametersAction cloneParametersAction;
    private JSecurityTestRunLog securityTestLog;
    private JPopupMenu securityScanPopUp;
    private JPopupMenu securityScanWithPropertiesPopUp;
    private JPopupMenu testStepPopUp;
    private SecurityTreeCellRender cellRender;
    private SecurityScanTree treeModel;
    private InternalSecurityTestRunListener testRunListener;
    private JScrollPane scrollPane;
    private EnableDisableSecurityScan enableDisableSecurityScan;
    private JPopupMenu multySecurityScanPopUp;
    protected boolean multypopupvisible;
    private EnableSecurityScans enableSecurityScansAction;
    private DisableSecurityScans disableSecurityScansAction;
    private ShowOnlineHelpAction showOnlineHelpAction;
    private OpenTestStepEditorAction openTestStepEditorAction;

    public JSecurityTestTestStepList(SecurityTest securityTest, JSecurityTestRunLog securityTestLog) {
        this.securityTest = securityTest;
        this.setLayout(new BorderLayout());
        JXToolBar toolbar = this.initToolbar();
        this.securityScanPopUp = new JPopupMenu();
        this.enableDisableSecurityScan = new EnableDisableSecurityScan();
        this.securityScanPopUp.add(this.enableDisableSecurityScan);
        this.securityScanPopUp.add(this.configureSecurityScanAction);
        this.securityScanPopUp.addSeparator();
        this.securityScanPopUp.add(this.removeSecurityScanAction);
        this.showOnlineHelpAction = new ShowOnlineHelpAction("http://www.soapui.org/Functional-Testing/getting-started-with-assertions.html");
        this.securityScanPopUp.add(this.showOnlineHelpAction);
        this.securityScanWithPropertiesPopUp = new JPopupMenu();
        this.securityScanWithPropertiesPopUp.add(this.enableDisableSecurityScan);
        this.securityScanWithPropertiesPopUp.add(this.configureSecurityScanAction);
        this.securityScanWithPropertiesPopUp.add(this.cloneParametersAction);
        this.securityScanWithPropertiesPopUp.addSeparator();
        this.securityScanWithPropertiesPopUp.add(this.removeSecurityScanAction);
        this.securityScanWithPropertiesPopUp.add(this.showOnlineHelpAction);
        this.multySecurityScanPopUp = new JPopupMenu();
        this.enableSecurityScansAction = new EnableSecurityScans();
        this.disableSecurityScansAction = new DisableSecurityScans();
        this.populateMultySecurityScanPopup(true, true);
        this.multySecurityScanPopUp.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                JSecurityTestTestStepList.this.multypopupvisible = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }
        });
        this.testStepPopUp = new JPopupMenu();
        this.initTestStepPopUpActions();
        this.testStepPopUp.addSeparator();
        this.testStepPopUp.add(new ShowOnlineHelpAction("http://www.soapui.org/Functional-Testing/getting-started-with-assertions.html"));
        this.treeModel = new SecurityScanTree(securityTest, new SecurityTreeRootNode(securityTest));
        this.securityTestTree = new JXTree((TreeModel)this.treeModel);
        this.securityTestTree.putClientProperty((Object)"JTree.lineStyle", (Object)"None");
        this.securityTestTree.setUI((TreeUI)new CustomTreeUI());
        this.securityTestTree.setRootVisible(false);
        this.securityTestTree.setLargeModel(true);
        this.cellRender = new SecurityTreeCellRender();
        this.securityTestTree.setCellRenderer((TreeCellRenderer)this.cellRender);
        this.securityTestTree.getSelectionModel().setSelectionMode(2);
        this.securityTestTree.addTreeSelectionListener((TreeSelectionListener)this);
        this.securityTestTree.addMouseListener((MouseListener)this);
        this.securityTestTree.setRowHeight(30);
        this.securityTestTree.setToggleClickCount(0);
        this.securityTestTree.setBackground(new Color(240, 240, 240));
        this.securityTestTree.setScrollsOnExpand(true);
        this.add((Component)toolbar, "North");
        this.scrollPane = new JScrollPane((Component)this.securityTestTree);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrollPane, "Center");
        securityTest.getTestCase().getTestSuite().addTestSuiteListener(this.testSuiteListener);
        securityTest.addSecurityTestListener(this);
        this.testRunListener = new InternalSecurityTestRunListener();
        securityTest.addSecurityTestRunListener(this.testRunListener);
        for (int row = 0; row < this.securityTestTree.getRowCount(); ++row) {
            this.securityTestTree.expandRow(row);
        }
        this.securityTestLog = securityTestLog;
    }

    private void populateMultySecurityScanPopup(boolean addEnableAction, boolean addDisableAction) {
        this.multySecurityScanPopUp.removeAll();
        if (addEnableAction) {
            this.multySecurityScanPopUp.add(this.enableSecurityScansAction);
        }
        if (addDisableAction) {
            this.multySecurityScanPopUp.add(this.disableSecurityScansAction);
        }
        this.multySecurityScanPopUp.addSeparator();
        this.multySecurityScanPopUp.add(this.removeSecurityScanAction);
        this.multySecurityScanPopUp.add(this.showOnlineHelpAction);
    }

    protected SecurityTest getSecurityTest() {
        return this.securityTest;
    }

    protected void setSecurityTest(SecurityTest securityTest) {
        this.securityTest = securityTest;
    }

    protected JPopupMenu getTestStepPopUp() {
        return this.testStepPopUp;
    }

    protected void initTestStepPopUpActions() {
        this.testStepPopUp.add(this.openTestStepEditorAction);
        this.testStepPopUp.add(this.addSecurityScanAction);
    }

    protected JPopupMenu getSecurityScanPopUp() {
        return this.securityScanPopUp;
    }

    private JXToolBar initToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.initToolbarLeft(toolbar);
        JButton expandActionBtn = UISupport.createToolbarButton(new ExpandTreeAction());
        expandActionBtn.setText("Expanded");
        expandActionBtn.setPreferredSize(new Dimension(80, 21));
        JButton collapsActionBtn = UISupport.createToolbarButton(new CollapsTreeAction());
        collapsActionBtn.setText("Collapsed");
        collapsActionBtn.setPreferredSize(new Dimension(80, 21));
        toolbar.addGlue();
        toolbar.add(expandActionBtn);
        toolbar.add(collapsActionBtn);
        return toolbar;
    }

    protected void initToolbarLeft(JXToolBar toolbar) {
        this.addSecurityScanAction = new AddSecurityScanAction();
        this.configureSecurityScanAction = new ConfigureSecurityScanAction();
        this.removeSecurityScanAction = new RemoveSecurityScanAction();
        this.cloneParametersAction = new CloneParametersAction();
        this.openTestStepEditorAction = new OpenTestStepEditorAction();
        toolbar.addFixed(UISupport.createToolbarButton(this.addSecurityScanAction));
        toolbar.addFixed(UISupport.createToolbarButton(this.configureSecurityScanAction));
        toolbar.addFixed(UISupport.createToolbarButton(this.removeSecurityScanAction));
        toolbar.addFixed(UISupport.createToolbarButton(this.cloneParametersAction));
    }

    protected JComponent buildSecurityScanInspector() {
        JPanel p = new JPanel(new BorderLayout());
        return p;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.securityTest.getTestCase().getTestSuite().addTestSuiteListener(this.testSuiteListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.securityTest.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.enableActionsAfterRun();
    }

    protected void enableActionsAfterRun() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.securityTestTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node instanceof TestStepNode) {
            this.enableTestStepActions(node);
        } else if (node instanceof SecurityScanNode) {
            this.enableSecurityScanActions();
        }
    }

    protected void enableSecurityScanActions() {
        if (this.securityTest.isRunning()) {
            return;
        }
        this.securityTestLog.locateSecurityScan(((SecurityScanNode)this.securityTestTree.getLastSelectedPathComponent()).getSecurityScan());
        this.addSecurityScanAction.setEnabled(false);
        this.configureSecurityScanAction.setEnabled(true);
        this.removeSecurityScanAction.setEnabled(true);
        if (((SecurityScanNode)this.securityTestTree.getLastSelectedPathComponent()).getSecurityScan() instanceof AbstractSecurityScanWithProperties) {
            this.cloneParametersAction.setEnabled(true);
            this.cloneParametersAction.setSecurityScan((AbstractSecurityScanWithProperties)((SecurityScanNode)this.securityTestTree.getLastSelectedPathComponent()).getSecurityScan());
        }
    }

    protected void enableTestStepActions(DefaultMutableTreeNode node) {
        if (this.securityTest.isRunning()) {
            return;
        }
        if (node.getAllowsChildren()) {
            this.addSecurityScanAction.setEnabled(true);
        } else {
            this.addSecurityScanAction.setEnabled(false);
        }
        this.configureSecurityScanAction.setEnabled(false);
        this.removeSecurityScanAction.setEnabled(false);
        this.cloneParametersAction.setEnabled(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.securityTestTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if ((e.getModifiers() & 4) == 4) {
            return;
        }
        if (e.getClickCount() == 1) {
            if (this.securityTestTree.isExpanded(TreePathUtils.getPath(node)) && node instanceof TestStepNode && this.cellRender.isOn((TestStepNode)node, e.getX(), e.getY())) {
                this.securityTestTree.collapseRow(this.securityTestTree.getRowForLocation(e.getX(), e.getY()));
            } else {
                this.securityTestTree.expandRow(this.securityTestTree.getRowForLocation(e.getX(), e.getY()));
            }
            e.consume();
            return;
        }
        if (node instanceof SecurityScanNode) {
            if (this.securityTest.isRunning()) {
                return;
            }
            SecurityScan securityScan = ((SecurityScanNode)this.securityTestTree.getLastSelectedPathComponent()).getSecurityScan();
            if (securityScan.isConfigurable()) {
                SecurityScanConfig backupScanConfig = (SecurityScanConfig)securityScan.getConfig().copy();
                SecurityConfigurationDialog dialog = SoapUI.getSoapUICore().getSecurityScanRegistry().getUIBuilder().buildSecurityScanConfigurationDialog(securityScan);
                if (!dialog.configure()) {
                    securityScan.copyConfig(backupScanConfig);
                }
                dialog.release();
            }
        } else if (this.securityTestTree.isExpanded(TreePathUtils.getPath(node))) {
            UISupport.selectAndShow(((TestStepNode)node).getTestStep());
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Object node;
        if (this.securityTest.isRunning()) {
            return;
        }
        TreePath path = this.securityTestTree.getPathForLocation(e.getX(), e.getY());
        if ((e.getModifiers() & 4) == 4 && (this.securityTestTree.getSelectionRows().length <= 1 || this.multypopupvisible)) {
            this.securityTestTree.setSelectionPath(path);
            this.multypopupvisible = false;
        }
        if ((node = this.securityTestTree.getLastSelectedPathComponent()) == null) {
            return;
        }
        if ((e.getModifiers() & 4) == 4) {
            if (node instanceof SecurityScanNode) {
                if (this.securityTestTree.getSelectionRows().length == 1) {
                    SecurityScan scan = ((SecurityScanNode)node).getSecurityScan();
                    this.enableDisableSecurityScan.setText(scan.isDisabled());
                    if (scan instanceof AbstractSecurityScanWithProperties) {
                        this.securityScanWithPropertiesPopUp.show((Component)this.securityTestTree, e.getX(), e.getY());
                    } else {
                        this.securityScanPopUp.show((Component)this.securityTestTree, e.getX(), e.getY());
                    }
                } else if (this.securityTestTree.getSelectionRows().length > 1) {
                    this.populateMultySecurityScanPopup(true, true);
                    boolean hasEnabledScans = false;
                    boolean hasDisabledScans = false;
                    for (TreePath path2 : this.securityTestTree.getSelectionPaths()) {
                        if (!(path2.getLastPathComponent() instanceof SecurityScanNode)) continue;
                        if (((SecurityScanNode)path2.getLastPathComponent()).getSecurityScan().isDisabled()) {
                            hasDisabledScans = true;
                            continue;
                        }
                        hasEnabledScans = true;
                    }
                    if (hasEnabledScans && !hasDisabledScans) {
                        this.populateMultySecurityScanPopup(false, true);
                    } else if (!hasEnabledScans && hasDisabledScans) {
                        this.populateMultySecurityScanPopup(true, false);
                    }
                    this.multySecurityScanPopUp.show((Component)this.securityTestTree, e.getX(), e.getY());
                }
            } else if (((TestStepNode)node).getTestStep() instanceof Securable) {
                this.testStepPopUp.show((Component)this.securityTestTree, e.getX(), e.getY());
            }
        }
    }

    public void release() {
        this.cellRender.release();
        this.securityTest.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
        this.securityTest.removeSecurityTestListener(this);
        this.securityTest.removeSecurityTestRunListener(this.testRunListener);
        if (this.treeModel != null) {
            this.treeModel.release();
        }
    }

    @Override
    public void securityScanAdded(SecurityScan securityScan) {
        this.treeModel.addSecurityScanNode((JTree)this.securityTestTree, securityScan);
    }

    @Override
    public void securityScanRemoved(SecurityScan securityScan) {
        this.cellRender.remove(this.treeModel.getSecurityScanNode(securityScan));
        this.treeModel.removeSecurityScanNode(securityScan);
    }

    protected void disableAllActions() {
        this.addSecurityScanAction.setEnabled(false);
        this.configureSecurityScanAction.setEnabled(false);
        this.removeSecurityScanAction.setEnabled(false);
        this.cloneParametersAction.setEnabled(false);
    }

    public class CustomTreeUI
    extends BasicTreeUI {
        private final ComponentListener componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CustomTreeUI.this.treeState.invalidateSizes();
                CustomTreeUI.this.tree.repaint();
            }
        };

        public CustomTreeUI() {
            this.leftChildIndent = 0;
            this.rightChildIndent = 0;
            this.totalChildIndent = 0;
        }

        @Override
        public int getLeftChildIndent() {
            return 0;
        }

        @Override
        protected void installListeners() {
            super.installListeners();
            this.tree.addComponentListener(this.componentListener);
        }

        @Override
        protected void uninstallListeners() {
            this.tree.removeComponentListener(this.componentListener);
            super.uninstallListeners();
        }

        @Override
        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    Insets insets = CustomTreeUI.this.tree.getInsets();
                    dimensions.width = JSecurityTestTestStepList.this.scrollPane == null ? CustomTreeUI.this.tree.getWidth() - this.getRowX(row, depth) - insets.right : JSecurityTestTestStepList.this.scrollPane.getViewport().getWidth() - this.getRowX(row, depth) - insets.right;
                    return dimensions;
                }
            };
        }

        @Override
        protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            super.paintRow(g, clipBounds, insets, new Rectangle(0, bounds.y, bounds.width + bounds.x, bounds.height), path, row, isExpanded, hasBeenExpanded, isLeaf);
        }

        @Override
        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }
    }

    public class InternalSecurityTestRunListener
    extends SecurityTestRunListenerAdapter {
        @Override
        public void beforeSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScan securityScan) {
            JSecurityTestTestStepList.this.securityTestTree.setSelectionRow(JSecurityTestTestStepList.this.securityTestTree.getRowForPath(new TreePath(JSecurityTestTestStepList.this.treeModel.getSecurityScanNode(securityScan).getPath())));
        }

        @Override
        public void beforeRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
            JSecurityTestTestStepList.this.disableAllActions();
        }

        @Override
        public void afterRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
            JSecurityTestTestStepList.this.enableActionsAfterRun();
        }
    }

    public class CollapsTreeAction
    extends AbstractAction {
        public CollapsTreeAction() {
            super("Collaps Tree");
            this.putValue("ShortDescription", "Collaps Tree");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int row = JSecurityTestTestStepList.this.securityTestTree.getRowCount() - 1; row >= 0; --row) {
                JSecurityTestTestStepList.this.securityTestTree.collapseRow(row);
            }
        }
    }

    public class ExpandTreeAction
    extends AbstractAction {
        public ExpandTreeAction() {
            super("Expand Tree");
            this.putValue("ShortDescription", "Expand Tree");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int row = 0; row < JSecurityTestTestStepList.this.securityTestTree.getRowCount(); ++row) {
                JSecurityTestTestStepList.this.securityTestTree.expandRow(row);
            }
        }
    }

    public class DisableSecurityScans
    extends AbstractAction {
        public DisableSecurityScans() {
            super("Disable Scans");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (TreePath path : JSecurityTestTestStepList.this.securityTestTree.getSelectionPaths()) {
                if (!(path.getLastPathComponent() instanceof SecurityScanNode)) continue;
                ((SecurityScanNode)path.getLastPathComponent()).getSecurityScan().setDisabled(true);
            }
        }
    }

    public class EnableSecurityScans
    extends AbstractAction {
        EnableSecurityScans() {
            super("Enable Scans");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (TreePath path : JSecurityTestTestStepList.this.securityTestTree.getSelectionPaths()) {
                if (!(path.getLastPathComponent() instanceof SecurityScanNode)) continue;
                ((SecurityScanNode)path.getLastPathComponent()).getSecurityScan().setDisabled(false);
            }
        }
    }

    public class RemoveSecurityScanAction
    extends AbstractAction {
        public RemoveSecurityScanAction() {
            super("Remove SecurityScan");
            this.putValue("ShortDescription", "Removes the selected security scan");
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_security_scan.gif"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSecurityTestTestStepList.this.securityTest.isRunning()) {
                UISupport.showErrorMessage("Can not delete SecurityScan while the SecurityTest is running");
                return;
            }
            if (JSecurityTestTestStepList.this.securityTestTree.getSelectionCount() == 1) {
                SecurityScanNode node = (SecurityScanNode)JSecurityTestTestStepList.this.securityTestTree.getLastSelectedPathComponent();
                SecurityScan securityScan = node.getSecurityScan();
                TestStep testStep = ((TestStepNode)node.getParent()).getTestStep();
                if (UISupport.confirm("Remove security scan [" + securityScan.getName() + "]", "Remove SecurityScan")) {
                    JSecurityTestTestStepList.this.securityTest.removeSecurityScan(testStep, securityScan);
                }
            } else {
                SecurityScanNode node = (SecurityScanNode)JSecurityTestTestStepList.this.securityTestTree.getLastSelectedPathComponent();
                TestStep testStep = ((TestStepNode)node.getParent()).getTestStep();
                if (UISupport.confirm("Remove all selected security scans", "Remove SecurityScan")) {
                    for (TreePath path : JSecurityTestTestStepList.this.securityTestTree.getSelectionPaths()) {
                        if (!(path.getLastPathComponent() instanceof SecurityScanNode)) continue;
                        SecurityScan securityScan = ((SecurityScanNode)path.getLastPathComponent()).getSecurityScan();
                        JSecurityTestTestStepList.this.securityTest.removeSecurityScan(testStep, securityScan);
                    }
                }
            }
        }
    }

    public class ConfigureSecurityScanAction
    extends AbstractAction {
        ConfigureSecurityScanAction() {
            super("Configure");
            this.putValue("ShortDescription", "Configures selected security scan");
            this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityScanNode node = (SecurityScanNode)JSecurityTestTestStepList.this.securityTestTree.getLastSelectedPathComponent();
            SecurityScan securityScan = node.getSecurityScan();
            if (securityScan.isConfigurable()) {
                SecurityScanConfig backupScanConfig = (SecurityScanConfig)securityScan.getConfig().copy();
                SecurityConfigurationDialog dialog = SoapUI.getSoapUICore().getSecurityScanRegistry().getUIBuilder().buildSecurityScanConfigurationDialog(securityScan);
                if (!dialog.configure()) {
                    securityScan.copyConfig(backupScanConfig);
                }
                dialog.release();
            }
        }
    }

    public class EnableDisableSecurityScan
    extends AbstractAction {
        EnableDisableSecurityScan() {
            super("Enable Scan");
            this.putValue("ShortDescription", "Enables/Disables Security Scan");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SecurityScan securityScan;
            SecurityScanNode node = (SecurityScanNode)JSecurityTestTestStepList.this.securityTestTree.getLastSelectedPathComponent();
            securityScan.setDisabled(!(securityScan = node.getSecurityScan()).isDisabled());
        }

        public void setText(boolean disabled) {
            if (disabled) {
                this.putValue("Name", "Enable Security Scan");
            } else {
                this.putValue("Name", "Disable Security Scan");
            }
        }
    }

    public class AddSecurityScanAction
    extends AbstractAction {
        public AddSecurityScanAction() {
            super("Add SecurityScan");
            this.putValue("ShortDescription", "Adds a security scan to this item");
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_security_scan.gif"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TestStepNode node = (TestStepNode)JSecurityTestTestStepList.this.securityTestTree.getLastSelectedPathComponent();
            if (!node.getAllowsChildren()) {
                return;
            }
            TestStep testStep = node.getTestStep();
            String[] availableScanNames = SoapUI.getSoapUICore().getSecurityScanRegistry().getAvailableSecurityScansNames(testStep);
            availableScanNames = JSecurityTestTestStepList.this.securityTest.getAvailableSecurityScanNames(testStep, availableScanNames);
            if (availableScanNames == null || availableScanNames.length == 0) {
                UISupport.showErrorMessage("No security scans available for this test step");
                return;
            }
            String name = UISupport.prompt("Specify type of security scan", "Add SecurityScan", availableScanNames);
            if (name == null || name.trim().length() == 0) {
                return;
            }
            String type = SoapUI.getSoapUICore().getSecurityScanRegistry().getSecurityScanTypeForName(name);
            if (type == null || type.trim().length() == 0) {
                return;
            }
            SecurityScan securityScan = JSecurityTestTestStepList.this.securityTest.addNewSecurityScan(testStep, name);
            if (securityScan == null) {
                UISupport.showErrorMessage("Failed to add security scan");
                return;
            }
            securityScan.setRunOnlyOnce(true);
            JSecurityTestTestStepList.this.securityTestTree.setSelectionPath(new TreePath(node.getPath()));
            SecurityConfigurationDialog dialog = SoapUI.getSoapUICore().getSecurityScanRegistry().getUIBuilder().buildSecurityScanConfigurationDialog(securityScan);
            if (!dialog.configure()) {
                SecurityScanNode securityScanNode = (SecurityScanNode)node.getLastChild();
                JSecurityTestTestStepList.this.securityTest.removeSecurityScan(testStep, securityScan);
                JSecurityTestTestStepList.this.cellRender.remove(securityScanNode);
            }
            dialog.release();
        }
    }

    public class OpenTestStepEditorAction
    extends AbstractAction {
        public OpenTestStepEditorAction() {
            super("Open Editor");
            this.putValue("ShortDescription", "Opens the editor for this TestStep");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TestStepNode node = (TestStepNode)JSecurityTestTestStepList.this.securityTestTree.getLastSelectedPathComponent();
            UISupport.selectAndShow(node.getTestStep());
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        @Override
        public void testStepAdded(TestStep testStep, int index) {
            ((SecurityScanTree)JSecurityTestTestStepList.this.securityTestTree.getModel()).insertNodeInto(testStep);
        }

        @Override
        public void testStepRemoved(TestStep testStep, int index) {
            TestStepNode node = ((SecurityScanTree)JSecurityTestTestStepList.this.securityTestTree.getModel()).getTestStepNode(testStep);
            for (int cnt = 0; cnt < node.getChildCount(); ++cnt) {
                SecurityScanNode nodeCld = (SecurityScanNode)node.getChildAt(cnt);
                JSecurityTestTestStepList.this.cellRender.remove(nodeCld);
                JSecurityTestTestStepList.this.treeModel.removeNodeFromParent(nodeCld);
            }
            JSecurityTestTestStepList.this.cellRender.remove(node);
            JSecurityTestTestStepList.this.treeModel.removeNodeFromParent(node);
        }

        @Override
        public void testStepMoved(TestStep testStep, int index, int offset) {
            TreePath path = JSecurityTestTestStepList.this.treeModel.moveTestStepNode(testStep, index, offset);
            JSecurityTestTestStepList.this.securityTestTree.expandPath(path);
            JSecurityTestTestStepList.this.securityTestTree.setSelectionPath(path);
        }
    }
}

