/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.assertion;

import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.TestAssertion;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SecurityAssertionPanel
extends AssertionsPanel {
    public SecurityAssertionPanel(Assertable assertable) {
        super(assertable);
    }

    @Override
    protected void initListAndModel() {
        this.assertionListModel = new SecurityAssertionListModel();
        this.assertionList = new JList(this.assertionListModel);
        this.assertionList.setToolTipText("Assertions for this security scan.");
        this.assertionList.setCellRenderer(new SecurityAssertionCellRenderer());
    }

    @Override
    public String getHelpUrl() {
        return "http://www.soapui.org/Assertions/security-scan-assertion.html";
    }

    private class SecurityAssertionCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private SecurityAssertionCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            TestAssertion assertion = (TestAssertion)value;
            this.setText(assertion.getLabel());
            if (assertion.isDisabled() && this.isEnabled()) {
                this.setEnabled(false);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    protected class SecurityAssertionListModel
    extends AssertionsPanel.AssertionListModel {
        protected SecurityAssertionListModel() {
        }

        @Override
        protected void addAssertion(TestAssertion assertion) {
            assertion.addPropertyChangeListener(this);
            this.items.add(assertion);
        }
    }
}

