/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.actions;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.scan.AbstractSecurityScan;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.XFormMultiSelectList;
import com.eviware.x.impl.swing.JFormDialog;
import com.eviware.x.impl.swing.SwingXFormDialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

public class CloneParametersAction
extends AbstractAction {
    private XFormDialog dialog;
    protected DefaultActionList actionList;
    private AbstractSecurityScanWithProperties securityScan;

    public CloneParametersAction() {
        super("Clone SecurityScan Parameters");
        this.putValue("SmallIcon", UISupport.createImageIcon("/clone_parameters.gif"));
        this.putValue("ShortDescription", "Clones parameter");
        this.setEnabled(false);
    }

    public CloneParametersAction(AbstractSecurityScanWithProperties securityScan) {
        super("Clone SecurityScan Parameters");
        this.putValue("SmallIcon", UISupport.createImageIcon("/clone_parameters.gif"));
        this.putValue("ShortDescription", "Clones parameter");
        this.securityScan = securityScan;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XFormDialog dialog = this.createCloneParameterDialog();
        dialog.show();
    }

    public void setSecurityScan(AbstractSecurityScanWithProperties securityScan) {
        this.securityScan = securityScan;
    }

    private String[] getSecurableTestStepsNames(TestCase testCase) {
        List<TestStep> testStepList = testCase.getTestStepList();
        ArrayList<String> namesList = new ArrayList<String>();
        for (TestStep testStep : testStepList) {
            if (!AbstractSecurityScan.isSecurable(testStep)) continue;
            namesList.add(testStep.getName());
        }
        String[] names = new String[namesList.size()];
        for (int c = 0; c < namesList.size(); ++c) {
            names[c] = (String)namesList.get(c);
        }
        return names;
    }

    public List<ModelItem> performClone(boolean showErrorMessage) {
        ArrayList<ModelItem> items = new ArrayList<ModelItem>();
        String targetTestSuiteName = this.dialog.getValue("Target TestSuite");
        String targetTestCaseName = this.dialog.getValue("Target TestCase");
        String targetSecurityTestName = this.dialog.getValue("Target SecurityTest");
        String targetSecurityTestStepName = this.dialog.getValue("Target TestStep");
        String[] targetSecurityScans = StringUtils.toStringArray(((XFormMultiSelectList)this.dialog.getFormField("Target SecurityScans")).getSelectedOptions());
        if (targetSecurityScans.length == 0) {
            if (showErrorMessage) {
                UISupport.showErrorMessage("No SecurityScans selected..");
            }
            return items;
        }
        int[] indexes = ((XFormOptionsField)this.dialog.getFormField("Parameters")).getSelectedIndexes();
        if (indexes.length == 0) {
            if (showErrorMessage) {
                UISupport.showErrorMessage("No Parameters selected..");
            }
            return items;
        }
        Project project = this.securityScan.getTestStep().getTestCase().getTestSuite().getProject();
        TestSuite targetTestSuite = project.getTestSuiteByName(targetTestSuiteName);
        TestCase targetTestCase = targetTestSuite.getTestCaseByName(targetTestCaseName);
        SecurityTest targetSecurityTest = targetTestCase.getSecurityTestByName(targetSecurityTestName);
        TestStep targetTestStep = targetTestCase.getTestStepByName(targetSecurityTestStepName);
        boolean overwrite2 = this.dialog.getBooleanValue("Overwrite");
        for (String scanName : targetSecurityScans) {
            AbstractSecurityScanWithProperties targetSecurityScan = (AbstractSecurityScanWithProperties)targetSecurityTest.getTestStepSecurityScanByName(targetTestStep.getId(), scanName);
            for (int i : indexes) {
                SecurityCheckedParameter scanParameter = this.securityScan.getParameterAt(i);
                String newParameterLabel = scanParameter.getLabel();
                if (this.securityScan.getParameterByLabel(scanParameter.getLabel()) != null && this.securityScan.equals(targetSecurityScan)) {
                    newParameterLabel = "Copy of " + scanParameter.getLabel();
                }
                if (!targetSecurityScan.importParameter(scanParameter, overwrite2, newParameterLabel) || items.contains(targetSecurityScan)) continue;
                items.add(targetSecurityScan);
            }
        }
        return items;
    }

    protected XFormDialog createCloneParameterDialog() {
        this.actionList = new DefaultActionList();
        OkAction okAction = new OkAction();
        this.actionList.addAction(okAction, true);
        CancelAction cancelAction = new CancelAction();
        this.actionList.addAction(cancelAction);
        ApplyAction applyAction = new ApplyAction();
        this.actionList.addAction(applyAction);
        this.dialog = ADialogBuilder.buildDialog(CloneParameterDialog.class, (ActionList)this.actionList, false);
        okAction.setDialog(this.dialog);
        cancelAction.setDialog(this.dialog);
        applyAction.setDialog(this.dialog);
        TestCase testCase = this.securityScan.getTestStep().getTestCase();
        final Project project = testCase.getTestSuite().getProject();
        this.dialog.getFormField("Target TestSuite").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                TestSuite testSuite = project.getTestSuiteByName(newValue);
                Object[] testCaseNames = ModelSupport.getNames(testSuite.getTestCaseList());
                CloneParametersAction.this.dialog.setOptions("Target TestCase", testCaseNames);
                if (testCaseNames.length > 0) {
                    CloneParametersAction.this.dialog.setValue("Target TestCase", (String)testCaseNames[0]);
                    TestCase testCase = testSuite.getTestCaseByName((String)testCaseNames[0]);
                    Object[] testStepNames = new String[]{};
                    Object[] securityTestNames = ModelSupport.getNames(testCase.getSecurityTestList());
                    CloneParametersAction.this.dialog.setOptions("Target SecurityTest", securityTestNames);
                    if (securityTestNames.length > 0) {
                        testStepNames = CloneParametersAction.this.getSecurableTestStepsNames(testCase);
                    }
                    CloneParametersAction.this.dialog.setOptions("Target TestStep", testStepNames);
                    if (securityTestNames.length > 0) {
                        CloneParametersAction.this.dialog.setValue("Target SecurityTest", (String)securityTestNames[0]);
                        if (testStepNames.length > 0) {
                            CloneParametersAction.this.dialog.setValue("Target TestStep", (String)testStepNames[0]);
                        } else {
                            CloneParametersAction.this.dialog.setOptions("Target TestStep", new String[0]);
                        }
                        String securityTestName = CloneParametersAction.this.dialog.getValue("Target SecurityTest");
                        SecurityTest securityTest = testCase.getSecurityTestByName(securityTestName);
                        String testStepName = CloneParametersAction.this.dialog.getValue("Target TestStep");
                        TestStep testStep = testCase.getTestStepByName(testStepName);
                        Object[] securityScanNames = ModelSupport.getNames(securityTest.getTestStepSecurityScanByType(testStep.getId(), AbstractSecurityScanWithProperties.class));
                        CloneParametersAction.this.dialog.setOptions("Target SecurityScans", securityScanNames);
                    } else {
                        CloneParametersAction.this.dialog.setOptions("Target SecurityTest", new String[0]);
                        CloneParametersAction.this.dialog.setOptions("Target TestStep", new String[0]);
                        CloneParametersAction.this.dialog.setOptions("Target SecurityScans", new String[0]);
                    }
                } else {
                    CloneParametersAction.this.dialog.setOptions("Target SecurityTest", new String[0]);
                    CloneParametersAction.this.dialog.setOptions("Target TestStep", new String[0]);
                }
            }
        });
        this.dialog.getFormField("Target TestCase").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                String testSuiteName = CloneParametersAction.this.dialog.getValue("Target TestSuite");
                TestSuite testSuite = project.getTestSuiteByName(testSuiteName);
                TestCase testCase = testSuite.getTestCaseByName(newValue);
                Object[] testStepNames = new String[]{};
                Object[] securityTestNames = ModelSupport.getNames(testCase.getSecurityTestList());
                CloneParametersAction.this.dialog.setOptions("Target SecurityTest", securityTestNames);
                if (securityTestNames.length > 0) {
                    testStepNames = CloneParametersAction.this.getSecurableTestStepsNames(testCase);
                }
                CloneParametersAction.this.dialog.setOptions("Target TestStep", testStepNames);
                if (securityTestNames.length > 0) {
                    CloneParametersAction.this.dialog.setValue("Target SecurityTest", (String)securityTestNames[0]);
                    if (testStepNames.length > 0) {
                        CloneParametersAction.this.dialog.setValue("Target TestStep", (String)testStepNames[0]);
                    } else {
                        CloneParametersAction.this.dialog.setOptions("Target TestStep", new String[0]);
                    }
                    String securityTestName = CloneParametersAction.this.dialog.getValue("Target SecurityTest");
                    SecurityTest securityTest = testCase.getSecurityTestByName(securityTestName);
                    String testStepName = CloneParametersAction.this.dialog.getValue("Target TestStep");
                    TestStep testStep = testCase.getTestStepByName(testStepName);
                    Object[] securityScanNames = ModelSupport.getNames(securityTest.getTestStepSecurityScanByType(testStep.getId(), AbstractSecurityScanWithProperties.class));
                    CloneParametersAction.this.dialog.setOptions("Target SecurityScans", securityScanNames);
                } else {
                    CloneParametersAction.this.dialog.setOptions("Target SecurityTest", new String[0]);
                    CloneParametersAction.this.dialog.setOptions("Target TestStep", new String[0]);
                    CloneParametersAction.this.dialog.setOptions("Target SecurityScans", new String[0]);
                }
            }
        });
        this.dialog.getFormField("Target TestStep").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                String testSuiteName = CloneParametersAction.this.dialog.getValue("Target TestSuite");
                TestSuite testSuite = project.getTestSuiteByName(testSuiteName);
                String testCaseName = CloneParametersAction.this.dialog.getValue("Target TestCase");
                TestCase testCase = testSuite.getTestCaseByName(testCaseName);
                String securityTestName = CloneParametersAction.this.dialog.getValue("Target SecurityTest");
                SecurityTest securityTest = testCase.getSecurityTestByName(securityTestName);
                TestStep testStep = testCase.getTestStepByName(newValue);
                Object[] securityScanNames = ModelSupport.getNames(securityTest.getTestStepSecurityScanByType(testStep.getId(), AbstractSecurityScanWithProperties.class));
                CloneParametersAction.this.dialog.setOptions("Target SecurityScans", securityScanNames);
            }
        });
        this.dialog.getFormField("Target SecurityTest").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                String testSuiteName = CloneParametersAction.this.dialog.getValue("Target TestSuite");
                TestSuite testSuite = project.getTestSuiteByName(testSuiteName);
                String testCaseName = CloneParametersAction.this.dialog.getValue("Target TestCase");
                TestCase testCase = testSuite.getTestCaseByName(testCaseName);
                SecurityTest securityTest = testCase.getSecurityTestByName(newValue);
                String testStepName = CloneParametersAction.this.dialog.getValue("Target TestStep");
                TestStep testStep = testCase.getTestStepByName(testStepName);
                Object[] securityScanNames = ModelSupport.getNames(securityTest.getTestStepSecurityScanByType(testStep.getId(), AbstractSecurityScanWithProperties.class));
                CloneParametersAction.this.dialog.setOptions("Target SecurityScans", securityScanNames);
            }
        });
        WsdlTestCase wsdlTestCase = (WsdlTestCase)this.securityScan.getTestStep().getTestCase();
        this.dialog.setOptions("Target TestSuite", ModelSupport.getNames(wsdlTestCase.getTestSuite().getProject().getTestSuiteList()));
        this.dialog.setValue("Target TestSuite", wsdlTestCase.getTestSuite().getName());
        List<TestCase> wsdlTestCaseList = wsdlTestCase.getTestSuite().getTestCaseList();
        this.dialog.setOptions("Target TestCase", ModelSupport.getNames(wsdlTestCaseList));
        this.dialog.setValue("Target TestCase", wsdlTestCase.getName());
        this.dialog.setOptions("Target TestStep", this.getSecurableTestStepsNames(wsdlTestCase));
        this.dialog.setOptions("Target SecurityTest", ModelSupport.getNames(wsdlTestCase.getSecurityTestList()));
        String securityTestName = this.dialog.getValue("Target SecurityTest");
        SecurityTest securityTest = wsdlTestCase.getSecurityTestByName(securityTestName);
        String testStepName = this.dialog.getValue("Target TestStep");
        WsdlTestStep testStep = wsdlTestCase.getTestStepByName(testStepName);
        Object[] securityScanNames = ModelSupport.getNames(securityTest.getTestStepSecurityScanByType(testStep.getId(), AbstractSecurityScanWithProperties.class));
        this.dialog.setOptions("Target SecurityScans", securityScanNames);
        this.dialog.setOptions("Parameters", this.securityScan.getParameterHolder().getParameterLabels());
        ((JFormDialog)this.dialog).getDialog().setResizable(false);
        return this.dialog;
    }

    @AForm(description="Specify target TestSuite/TestCase/Security Test(s)/Security Scan(s) and select Parameters to clone", name="Clone Parameters", icon="/applications-system.png", helpUrl="http://www.soapui.org/Security/security-scans-overview.html")
    private static interface CloneParameterDialog {
        @AField(name="Parameters", description="The Parameters to clone", type=AField.AFieldType.MULTILIST)
        public static final String PARAMETERS = "Parameters";
        @AField(name="Target TestSuite", description="The target TestSuite for the cloned Parameter(s)", type=AField.AFieldType.ENUMERATION)
        public static final String TARGET_TESTSUITE = "Target TestSuite";
        @AField(name="Target TestCase", description="The target TestCase for the cloned Parameter(s)", type=AField.AFieldType.ENUMERATION)
        public static final String TARGET_TESTCASE = "Target TestCase";
        @AField(name="Target SecurityTest", description="The target SecurityTest for the cloned Parameter(s)", type=AField.AFieldType.ENUMERATION)
        public static final String TARGET_SECURITYTEST = "Target SecurityTest";
        @AField(name="Target TestStep", description="The target TestStep for the cloned Parameter(s)", type=AField.AFieldType.ENUMERATION)
        public static final String TARGET_TESTSTEP = "Target TestStep";
        @AField(name="Target SecurityScans", description="The SecurityScans to clone to", type=AField.AFieldType.MULTILIST)
        public static final String TARGET_SECURITYSCAN = "Target SecurityScans";
        @AField(name="Overwrite", description="Overwrite existing parameters", type=AField.AFieldType.BOOLEAN)
        public static final String OVERWRITE = "Overwrite";
    }

    private class ApplyAction
    extends AbstractAction {
        private XFormDialog dialog;

        public ApplyAction() {
            super("Apply");
        }

        public void setDialog(XFormDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.dialog != null) {
                List<ModelItem> items = CloneParametersAction.this.performClone(true);
                UISupport.showInfoMessage("Updated " + items.size() + " scans");
                if (items.size() > 0) {
                    ((XFormMultiSelectList)this.dialog.getFormField("Target SecurityScans")).setSelectedOptions(new String[0]);
                    ((XFormMultiSelectList)this.dialog.getFormField("Parameters")).setSelectedOptions(new String[0]);
                }
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private XFormDialog dialog;

        public CancelAction() {
            super("Cancel");
        }

        public void setDialog(XFormDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.dialog != null) {
                ((SwingXFormDialog)this.dialog).setReturnValue(2);
                this.dialog.setVisible(false);
            }
        }
    }

    private class OkAction
    extends AbstractAction {
        private XFormDialog dialog;

        public OkAction() {
            super("OK");
        }

        public void setDialog(XFormDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.dialog != null) {
                ((SwingXFormDialog)this.dialog).setReturnValue(1);
                List<ModelItem> items = CloneParametersAction.this.performClone(true);
                UISupport.showInfoMessage("Updated " + items.size() + " scans");
                this.dialog.setVisible(false);
            }
        }
    }
}

