/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.support.Tools;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SoapUITreeNodeRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Project project;
        ModelItem modelItem = ((SoapUITreeNode)value).getModelItem();
        if (modelItem instanceof Project && !(project = (Project)modelItem).isOpen() && !project.isDisabled()) {
            leaf = false;
            expanded = false;
        }
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ImageIcon icon = modelItem.getIcon();
        this.setIcon(icon);
        if (modelItem instanceof TestStep && ((TestStep)modelItem).isDisabled()) {
            this.setEnabled(false);
        } else if (modelItem instanceof TestCase && ((TestCase)modelItem).isDisabled()) {
            this.setEnabled(false);
        } else if (modelItem instanceof TestSuite && ((TestSuite)modelItem).isDisabled()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        String toolTipText = tree.getToolTipText();
        if (toolTipText == null) {
            String description = modelItem.getDescription();
            if (description == null || description.trim().length() == 0) {
                description = modelItem.getName();
            }
            if (description != null && description.trim().indexOf(10) > 0) {
                description = Tools.convertToHtml(description);
            }
            this.setToolTipText(description);
        } else {
            this.setToolTipText(toolTipText.length() > 0 ? toolTipText : null);
        }
        return this;
    }
}

