/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUIExtensionClassLoader;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.propertyexpansion.resolvers.ContextPropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.DynamicPropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.EvalPropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.GlobalPropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.MockRunPropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.ModelItemPropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.PropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.PropertyResolverFactory;
import com.eviware.soapui.model.propertyexpansion.resolvers.SubmitPropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.TestRunPropertyResolver;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.settings.GlobalPropertySettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistryListener;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyExpander
implements SoapUIFactoryRegistryListener {
    private List<PropertyResolver> propertyResolvers = new ArrayList<PropertyResolver>();
    private static List<PropertyResolver> defaultResolvers = new ArrayList<PropertyResolver>();
    private static PropertyExpander defaultExpander;
    private static boolean debuggingMode;
    private static Map<String, StringToStringMap> debuggingExpandedProperties;
    private Map<PropertyResolverFactory, PropertyResolver> resolverFactories = new HashMap<PropertyResolverFactory, PropertyResolver>();

    public PropertyExpander(boolean addDefaultResolvers) {
        if (addDefaultResolvers) {
            this.propertyResolvers.addAll(defaultResolvers);
            SoapUI.getFactoryRegistry().addFactoryRegistryListener(this);
        }
    }

    public static PropertyExpander getDefaultExpander() {
        return defaultExpander;
    }

    @Deprecated
    public static void addDefaultResolver(PropertyResolver resolver) {
        defaultResolvers.add(resolver);
        defaultExpander.addResolver(resolver);
    }

    public void addResolver(PropertyResolver propertyResolver) {
        this.propertyResolvers.add(propertyResolver);
    }

    public void addResolverFactory(PropertyResolverFactory factory) {
        PropertyResolver resolver = factory.createPropertyResolver();
        this.addResolver(resolver);
        this.resolverFactories.put(factory, resolver);
    }

    public void removeResolverFactory(PropertyResolverFactory factory) {
        if (this.resolverFactories.containsKey(factory)) {
            this.removeResolver(this.resolverFactories.get(factory));
            this.resolverFactories.remove(factory);
        }
    }

    private void removeResolver(PropertyResolver propertyResolver) {
        this.propertyResolvers.remove(propertyResolver);
    }

    public static String expandProperties(String content) {
        return defaultExpander.expand(content);
    }

    public static String expandProperties(PropertyExpansionContext context, String content) {
        return defaultExpander.expand(context, content, false);
    }

    public static String expandProperties(PropertyExpansionContext context, String content, boolean entitize) {
        return defaultExpander.expand(context, content, entitize);
    }

    public String expand(String content) {
        return this.expand(new PropertyExpansionUtils.GlobalPropertyExpansionContext(), content, false);
    }

    public String expand(PropertyExpansionContext context, String content) {
        return this.expand(context, content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String expand(PropertyExpansionContext context, String content, boolean entitize) {
        SoapUIExtensionClassLoader.SoapUIClassLoaderState clState = SoapUIExtensionClassLoader.ensure();
        try {
            if (StringUtils.isNullOrEmpty(content)) {
                String string = content;
                return string;
            }
            int ix = content.indexOf("${");
            if (ix == -1) {
                String string = content;
                return string;
            }
            StringBuffer buf = new StringBuffer();
            int lastIx = 0;
            while (ix != -1) {
                int ix2;
                if (ix > lastIx && content.charAt(ix - 1) == '$') {
                    buf.append(content.substring(lastIx, ix - 1));
                    lastIx = ix;
                    ix = content.indexOf("${", lastIx + 1);
                    continue;
                }
                if (ix > lastIx) {
                    buf.append(content.substring(lastIx, ix));
                }
                if ((ix2 = content.indexOf(125, ix + 2)) == -1) break;
                int ix3 = content.lastIndexOf("${", ix2);
                if (ix3 != ix) {
                    content = content.substring(0, ix3) + this.expand(context, content.substring(ix3, ix2 + 1)) + content.substring(ix2 + 1);
                    lastIx = ix;
                    continue;
                }
                String propertyName = content.substring(ix + 2, ix2);
                String propertyValue = null;
                if (StringUtils.hasContent(propertyName)) {
                    boolean globalOverrideEnabled = SoapUI.getSettings().getBoolean(GlobalPropertySettings.ENABLE_OVERRIDE);
                    for (int c = 0; c < this.propertyResolvers.size() && propertyValue == null; ++c) {
                        propertyValue = this.propertyResolvers.get(c).resolveProperty(context, propertyName, globalOverrideEnabled);
                    }
                }
                if (propertyValue != null) {
                    if (!content.equals(propertyValue)) {
                        propertyValue = this.expand(context, propertyValue);
                    }
                    if (entitize) {
                        propertyValue = XmlUtils.entitize(propertyValue);
                    }
                    TestCase testCase = ModelSupport.getModelItemTestCase(context.getModelItem());
                    if (debuggingMode && testCase != null) {
                        StringToStringMap props = debuggingExpandedProperties.get(testCase.getId());
                        if (props == null) {
                            props = new StringToStringMap();
                        }
                        props.put(propertyName, propertyValue);
                        debuggingExpandedProperties.put(testCase.getId(), props);
                    }
                    buf.append(propertyValue);
                }
                lastIx = ix2 + 1;
                ix = content.indexOf("${", lastIx);
            }
            if (lastIx < content.length()) {
                buf.append(content.substring(lastIx));
            }
            String string = buf.toString();
            return string;
        }
        finally {
            clState.restore();
        }
    }

    public String expand(ModelItem contextModelItem, String content) {
        return this.expand(new DefaultPropertyExpansionContext(contextModelItem), content);
    }

    public static String expandProperties(ModelItem contextModelItem, String content) {
        return defaultExpander.expand(contextModelItem, content);
    }

    public static void setDebuggingMode(String testCaseId, boolean debug) {
        debuggingMode = debug;
        if (debug) {
            if (debuggingExpandedProperties.get(testCaseId) == null) {
                debuggingExpandedProperties.put(testCaseId, new StringToStringMap());
            }
        } else if (debuggingExpandedProperties.get(testCaseId) != null) {
            debuggingExpandedProperties.remove(testCaseId);
        }
    }

    public static StringToStringMap getDebuggingExpandedProperties(String testCaseId) {
        return debuggingExpandedProperties.get(testCaseId);
    }

    public static void clearDebuggingExpandedProperties(String testCaseId) {
        debuggingExpandedProperties.remove(testCaseId);
    }

    @Override
    public void factoryAdded(Class<?> factoryType, Object factory) {
        if (factory instanceof PropertyResolverFactory) {
            this.addResolverFactory((PropertyResolverFactory)factory);
        }
    }

    @Override
    public void factoryRemoved(Class<?> factoryType, Object factory) {
        if (factory instanceof PropertyResolverFactory) {
            this.removeResolverFactory((PropertyResolverFactory)factory);
        }
    }

    static {
        defaultResolvers.add(new ModelItemPropertyResolver());
        defaultResolvers.add(new TestRunPropertyResolver());
        defaultResolvers.add(new MockRunPropertyResolver());
        defaultResolvers.add(new SubmitPropertyResolver());
        defaultResolvers.add(new ContextPropertyResolver());
        defaultResolvers.add(new DynamicPropertyResolver());
        defaultResolvers.add(new GlobalPropertyResolver());
        defaultResolvers.add(new EvalPropertyResolver());
        defaultExpander = new PropertyExpander(true);
        for (PropertyResolverFactory factory : SoapUI.getFactoryRegistry().getFactories(PropertyResolverFactory.class)) {
            defaultExpander.addResolverFactory(factory);
        }
        ProxyUtils.setGlobalProxy(SoapUI.getSettings());
        debuggingExpandedProperties = new HashMap<String, StringToStringMap>();
    }
}

