/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.XPathReference;
import com.eviware.soapui.model.support.XPathReferenceContainer;
import com.eviware.soapui.model.support.XPathReferenceImpl;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import junit.framework.ComparisonFailure;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XQueryContainsAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion,
XPathReferenceContainer {
    private static final Logger log = Logger.getLogger(XQueryContainsAssertion.class);
    private String expectedContent;
    private String path;
    private JDialog configurationDialog;
    private JTextArea pathArea;
    private JTextArea contentArea;
    private boolean configureResult;
    private boolean allowWildcards;
    public static final String ID = "XQuery Match";
    public static final String LABEL = "XQuery Match";
    public static final String DESCRIPTION = "Uses an XQuery expression to select content from the target property and compares the result to an expected value. Applicable to any property containing XML.";
    private JCheckBox allowWildcardsCheckBox;

    public XQueryContainsAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, true, true, true, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.path = reader.readString("path", null);
        this.expectedContent = reader.readString("content", null);
        this.allowWildcards = reader.readBoolean("allowWildcards", false);
    }

    public String getExpectedContent() {
        return this.expectedContent;
    }

    public void setExpectedContent(String expectedContent) {
        this.expectedContent = expectedContent;
        this.setConfiguration(this.createConfiguration());
    }

    public void setContent(String content) {
        this.setExpectedContent(content);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isAllowWildcards() {
        return this.allowWildcards;
    }

    public void setAllowWildcards(boolean allowWildcards) {
        this.allowWildcards = allowWildcards;
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasResponse()) {
            return "Missing Response";
        }
        return this.assertContent(messageExchange.getResponseContentAsXml(), context, "Response");
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!XmlUtils.seemsToBeXml(source.getPropertyValue(propertyName))) {
            throw new AssertionException(new AssertionError("Property '" + propertyName + "' has value which is not xml!"));
        }
        return this.assertContent(source.getPropertyValue(propertyName), context, propertyName);
    }

    public String assertContent(String response, SubmitContext context, String type) throws AssertionException {
        try {
            if (this.path == null) {
                return "Missing path for XQuery Assertion";
            }
            if (this.expectedContent == null) {
                return "Missing content for XQuery Assertion";
            }
            XmlObject xml = XmlUtils.createXmlObject(response);
            String expandedPath = PropertyExpander.expandProperties(context, this.path);
            XmlObject[] items = xml.execQuery(expandedPath);
            XmlObject contentObj = null;
            String expandedContent = PropertyExpander.expandProperties(context, this.expectedContent);
            try {
                contentObj = XmlUtils.createXmlObject(expandedContent);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (items.length == 0) {
                throw new Exception("Missing content for xquery [" + this.path + "] in " + type);
            }
            XmlOptions options = new XmlOptions();
            options.setSavePrettyPrint();
            options.setSaveOuter();
            for (int c = 0; c < items.length; ++c) {
                try {
                    if (contentObj == null) {
                        if (items[c] instanceof XmlAnySimpleType) {
                            String value = ((XmlAnySimpleType)items[c]).getStringValue();
                            String expandedValue = PropertyExpander.expandProperties(context, value);
                            XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                        } else {
                            Node domNode = items[c].getDomNode();
                            switch (domNode.getNodeType()) {
                                case 1: {
                                    String expandedValue = PropertyExpander.expandProperties(context, XmlUtils.getElementText((Element)domNode));
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                case 9: {
                                    String expandedValue = PropertyExpander.expandProperties(context, XmlUtils.getElementText(((Document)domNode).getDocumentElement()));
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                case 2: {
                                    String expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                default: {
                                    String expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                            }
                        }
                    } else {
                        this.compareValues(contentObj.xmlText(options), items[c].xmlText(options));
                    }
                    break;
                }
                catch (Throwable e) {
                    if (c != items.length - 1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            String msg = "XQuery Match Assertion failed for path [" + this.path + "] : " + e.getClass().getSimpleName() + ":" + e.getMessage();
            throw new AssertionException(new AssertionError(msg));
        }
        return type + " matches content for [" + this.path + "]";
    }

    private void compareValues(String expandedContent, String expandedValue) throws Exception {
        Diff diff = new Diff(expandedContent, expandedValue);
        diff.overrideDifferenceListener(new DifferenceListener(){

            public int differenceFound(Difference diff) {
                if (XQueryContainsAssertion.this.allowWildcards && (diff.getId() == DifferenceEngine.TEXT_VALUE.getId() || diff.getId() == DifferenceEngine.ATTR_VALUE.getId())) {
                    try {
                        Tools.assertSimilar(diff.getControlNodeDetail().getValue(), diff.getTestNodeDetail().getValue(), '*');
                    }
                    catch (ComparisonFailure e) {
                        return 0;
                    }
                }
                return 0;
            }

            public void skippedComparison(Node arg0, Node arg1) {
            }
        });
        if (!diff.identical()) {
            throw new Exception(diff.toString());
        }
    }

    @Override
    public boolean configure() {
        if (this.configurationDialog == null) {
            this.buildConfigurationDialog();
        }
        this.pathArea.setText(this.path);
        this.contentArea.setText(this.expectedContent);
        this.allowWildcardsCheckBox.setSelected(this.allowWildcards);
        UISupport.showDialog(this.configurationDialog);
        return this.configureResult;
    }

    protected void buildConfigurationDialog() {
        this.configurationDialog = new JDialog(UISupport.getMainFrame());
        this.configurationDialog.setTitle("XQuery Match configuration");
        this.configurationDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XQueryContainsAssertion.this.pathArea.requestFocusInWindow();
                    }
                });
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)UISupport.buildDescription("Specify XQuery expression and expected result", "declare namespaces with <code>declare namespace &lt;prefix&gt;='&lt;namespace&gt;';</code>", null), "North");
        JSplitPane splitPane = UISupport.createVerticalSplit();
        JPanel pathPanel = new JPanel(new BorderLayout());
        JXToolBar pathToolbar = UISupport.createToolbar();
        this.addPathEditorActions(pathToolbar);
        this.pathArea = new JUndoableTextArea();
        this.pathArea.setToolTipText("Specifies the XQuery expression to select from the message for validation");
        pathPanel.add((Component)pathToolbar, "North");
        pathPanel.add((Component)new JScrollPane(this.pathArea), "Center");
        splitPane.setTopComponent(UISupport.addTitledBorder(pathPanel, "XQuery Expression"));
        JPanel matchPanel = new JPanel(new BorderLayout());
        JXToolBar contentToolbar = UISupport.createToolbar();
        this.addMatchEditorActions(contentToolbar);
        this.contentArea = new JUndoableTextArea();
        this.contentArea.setToolTipText("Specifies the expected result of the XQuery expression");
        matchPanel.add((Component)contentToolbar, "North");
        matchPanel.add((Component)new JScrollPane(this.contentArea), "Center");
        splitPane.setBottomComponent(UISupport.addTitledBorder(matchPanel, "Expected Result"));
        splitPane.setDividerLocation(150);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        contentPanel.add((Component)splitPane, "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        ShowOnlineHelpAction showOnlineHelpAction = new ShowOnlineHelpAction("http://www.soapui.org/Assertions/xquery-match-assertion.html");
        builder.addFixed((JComponent)UISupport.createToolbarButton(showOnlineHelpAction));
        builder.addGlue();
        JButton okButton = new JButton(new OkAction());
        builder.addFixed((JComponent)okButton);
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new CancelAction()));
        builder.setBorder(BorderFactory.createEmptyBorder(1, 5, 5, 5));
        contentPanel.add((Component)builder.getPanel(), "South");
        this.configurationDialog.setContentPane(contentPanel);
        this.configurationDialog.setSize(600, 500);
        this.configurationDialog.setModal(true);
        UISupport.initDialogActions(this.configurationDialog, showOnlineHelpAction, okButton);
    }

    protected void addPathEditorActions(JXToolBar toolbar) {
        toolbar.addFixed(new JButton(new DeclareNamespacesFromCurrentAction()));
    }

    protected void addMatchEditorActions(JXToolBar toolbar) {
        toolbar.addFixed(new JButton(new SelectFromCurrentAction()));
        toolbar.addRelatedGap();
        toolbar.addFixed(new JButton(new TestPathAction()));
        this.allowWildcardsCheckBox = new JCheckBox("Allow Wildcards");
        Dimension dim = new Dimension(100, 20);
        this.allowWildcardsCheckBox.setSize(dim);
        this.allowWildcardsCheckBox.setPreferredSize(dim);
        this.allowWildcardsCheckBox.setOpaque(false);
        toolbar.addRelatedGap();
        toolbar.addFixed(this.allowWildcardsCheckBox);
    }

    public XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("path", this.path);
        builder.add("content", this.expectedContent);
        builder.add("allowWildcards", this.allowWildcards);
        return builder.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFromCurrent() {
        block10: {
            try {
                Element elm;
                XmlObject[] paths;
                String txt;
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setSaveAggressiveNamespaces();
                String assertableContent = this.getAssertable().getAssertableContentAsXml();
                if (assertableContent == null || assertableContent.trim().length() == 0) {
                    UISupport.showErrorMessage("Missing content to select from");
                    return;
                }
                XmlObject xml = XmlUtils.createXmlObject(assertableContent);
                String string = txt = this.pathArea == null || !this.pathArea.isVisible() ? this.getPath() : this.pathArea.getSelectedText();
                if (txt == null) {
                    txt = this.pathArea == null ? "" : this.pathArea.getText();
                }
                WsdlTestRunContext context = new WsdlTestRunContext(this.getAssertable().getTestStep());
                String expandedPath = PropertyExpander.expandProperties(context, txt.trim());
                if (this.contentArea != null && this.contentArea.isVisible()) {
                    this.contentArea.setText("");
                }
                if ((paths = xml.execQuery(expandedPath)).length == 0) {
                    UISupport.showErrorMessage("No match in current response");
                    break block10;
                }
                if (paths.length > 1) {
                    UISupport.showErrorMessage("More than one match in current response");
                    break block10;
                }
                Node domNode = paths[0].getDomNode();
                String stringValue = null;
                stringValue = domNode.getNodeType() == 2 || domNode.getNodeType() == 3 ? domNode.getNodeValue() : (domNode.getNodeType() == 1 ? ((elm = (Element)domNode).getChildNodes().getLength() == 1 && elm.getAttributes().getLength() == 0 ? XmlUtils.getElementText(elm) : paths[0].xmlText(options)) : paths[0].xmlText(options));
                if (this.contentArea != null && this.contentArea.isVisible()) {
                    this.contentArea.setText(stringValue);
                    break block10;
                }
                this.setContent(stringValue);
            }
            catch (Throwable e) {
                UISupport.showErrorMessage("Invalid XQuery expression.");
                SoapUI.logError(e);
            }
        }
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasRequest(true)) {
            return "Missing Request";
        }
        return this.assertContent(messageExchange.getRequestContent(), context, "Request");
    }

    public JTextArea getContentArea() {
        return this.contentArea;
    }

    public JTextArea getPathArea() {
        return this.pathArea;
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "expectedContent"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "path"));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public XPathReference[] getXPathReferences() {
        ArrayList<XPathReferenceImpl> result = new ArrayList<XPathReferenceImpl>();
        if (StringUtils.hasContent(this.getPath())) {
            TestStep testStep = this.getAssertable().getTestStep();
            TestProperty property = testStep instanceof WsdlTestRequestStep ? testStep.getProperty("Response") : testStep.getProperty("Request");
            result.add(new XPathReferenceImpl("XQuery for " + this.getName() + " XQueryContainsAssertion in " + testStep.getName(), property, this, "path"));
        }
        return result.toArray(new XPathReference[result.size()]);
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("XQuery Match", "XQuery Match", XQueryContainsAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Property Content";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return XQueryContainsAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("XQuery Match", "XQuery Match", XQueryContainsAssertion.DESCRIPTION);
        }

        @Override
        public boolean canAssert(TestPropertyHolder modelItem, String property) {
            if (!modelItem.getProperty(property).getSchemaType().isPrimitiveType()) {
                return true;
            }
            String content = modelItem.getPropertyValue(property);
            return XmlUtils.seemsToBeXml(content);
        }
    }

    public class SelectFromCurrentAction
    extends AbstractAction {
        public SelectFromCurrentAction() {
            super("Select from current");
            this.putValue("ShortDescription", "Selects the XQuery expression from the current message into the Expected Content field");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XQueryContainsAssertion.this.selectFromCurrent();
        }
    }

    public class TestPathAction
    extends AbstractAction {
        public TestPathAction() {
            super("Test");
            this.putValue("ShortDescription", "Tests the XQuery expression for the current message against the Expected Content field");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String oldPath = XQueryContainsAssertion.this.getPath();
            String oldContent = XQueryContainsAssertion.this.getExpectedContent();
            boolean oldAllowWildcards = XQueryContainsAssertion.this.isAllowWildcards();
            XQueryContainsAssertion.this.setPath(XQueryContainsAssertion.this.pathArea.getText().trim());
            XQueryContainsAssertion.this.setContent(XQueryContainsAssertion.this.contentArea.getText());
            XQueryContainsAssertion.this.setAllowWildcards(XQueryContainsAssertion.this.allowWildcardsCheckBox.isSelected());
            try {
                String msg = XQueryContainsAssertion.this.assertContent(XQueryContainsAssertion.this.getAssertable().getAssertableContentAsXml(), new WsdlTestRunContext(XQueryContainsAssertion.this.getAssertable().getTestStep()), "Response");
                UISupport.showInfoMessage(msg, "Success");
            }
            catch (AssertionException e) {
                UISupport.showErrorMessage(e.getMessage());
            }
            XQueryContainsAssertion.this.setPath(oldPath);
            XQueryContainsAssertion.this.setContent(oldContent);
            XQueryContainsAssertion.this.setAllowWildcards(oldAllowWildcards);
        }
    }

    public class DeclareNamespacesFromCurrentAction
    extends AbstractAction {
        public DeclareNamespacesFromCurrentAction() {
            super("Declare");
            this.putValue("ShortDescription", "Add namespace declaration from current message to XQuery expression");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                String content = XQueryContainsAssertion.this.getAssertable().getAssertableContentAsXml();
                if (content != null && content.trim().length() > 0) {
                    XQueryContainsAssertion.this.pathArea.setText(XmlUtils.declareXPathNamespaces(content) + XQueryContainsAssertion.this.pathArea.getText());
                } else if (UISupport.confirm("Declare namespaces from schema instead?", "Missing Response")) {
                    XQueryContainsAssertion.this.pathArea.setText(XmlUtils.declareXPathNamespaces((WsdlInterface)XQueryContainsAssertion.this.getAssertable().getInterface()) + XQueryContainsAssertion.this.pathArea.getText());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XQueryContainsAssertion.this.configureResult = false;
            XQueryContainsAssertion.this.configurationDialog.setVisible(false);
        }
    }

    public class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XQueryContainsAssertion.this.setPath(XQueryContainsAssertion.this.pathArea.getText().trim());
            XQueryContainsAssertion.this.setContent(XQueryContainsAssertion.this.contentArea.getText());
            XQueryContainsAssertion.this.setAllowWildcards(XQueryContainsAssertion.this.allowWildcardsCheckBox.isSelected());
            XQueryContainsAssertion.this.setConfiguration(XQueryContainsAssertion.this.createConfiguration());
            XQueryContainsAssertion.this.configureResult = true;
            XQueryContainsAssertion.this.configurationDialog.setVisible(false);
        }
    }
}

