/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.config.TimeUnitConfig;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.OAuth2ProfileContainer;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2ClientFacade;
import com.eviware.soapui.impl.rest.actions.oauth.OltuOAuth2ClientFacade;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.TimeUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;

public class OAuth2RequestFilter
extends AbstractRequestFilter {
    private static final int ACCESS_TOKEN_RETRIEVAL_TIMEOUT = 5000;
    private static Logger log = Logger.getLogger(OAuth2RequestFilter.class);

    static void setLog(Logger newLog) {
        log = newLog;
    }

    static Logger getLog() {
        return log;
    }

    @Override
    public void filterRestRequest(SubmitContext context, RestRequestInterface request) {
        HttpRequestBase httpMethod = (HttpRequestBase)context.getProperty("httpMethod");
        OAuth2ProfileContainer profileContainer = request.getResource().getService().getProject().getOAuth2ProfileContainer();
        if (CredentialsConfig.AuthType.O_AUTH_2_0.toString().equals(request.getAuthType())) {
            OAuth2Profile profile = profileContainer.getProfileByName(((AbstractHttpRequest)((Object)request)).getSelectedAuthProfile());
            if (profile == null || StringUtils.isNullOrEmpty(profile.getAccessToken())) {
                return;
            }
            OAuth2ClientFacade oAuth2Client = this.getOAuth2ClientFacade();
            if (this.accessTokenIsExpired(profile)) {
                if (profile.shouldReloadAccessTokenAutomatically()) {
                    this.reloadAccessToken(profile, oAuth2Client);
                } else {
                    profile.setAccessTokenStatus(OAuth2Profile.AccessTokenStatus.EXPIRED);
                }
            }
            oAuth2Client.applyAccessToken(profile, httpMethod, request.getRequestContent());
        }
    }

    protected OAuth2ClientFacade getOAuth2ClientFacade() {
        return new OltuOAuth2ClientFacade();
    }

    private boolean accessTokenIsExpired(OAuth2Profile profile) {
        long expirationTime;
        long currentTime = TimeUtils.getCurrentTimeInSeconds();
        long issuedTime = profile.getAccessTokenIssuedTime();
        if (profile.useManualAccessTokenExpirationTime()) {
            String expirationTimeString = profile.getManualAccessTokenExpirationTime() == null ? "" : profile.getManualAccessTokenExpirationTime();
            String expandedValue = PropertyExpander.expandProperties(profile.getContainer().getProject(), expirationTimeString);
            expirationTime = this.convertExpirationTimeToSeconds(expandedValue, profile.getManualAccessTokenExpirationTimeUnit());
        } else {
            expirationTime = profile.getAccessTokenExpirationTime();
        }
        return issuedTime > 0L && expirationTime > 0L && expirationTime < currentTime + 10L - issuedTime;
    }

    private long convertExpirationTimeToSeconds(String expirationTimeString, TimeUnitConfig.Enum timeUnit) throws IllegalArgumentException {
        long expirationTime;
        try {
            expirationTime = Long.valueOf(expirationTimeString.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Manual expiration time cannot be parsed due to invalid characters.Please review it and make sure it is set correctly.", e);
        }
        if (((Object)((Object)timeUnit)).equals((Object)TimeUnitConfig.HOURS)) {
            return expirationTime * 3600L;
        }
        if (((Object)((Object)timeUnit)).equals((Object)TimeUnitConfig.MINUTES)) {
            return expirationTime * 60L;
        }
        return expirationTime;
    }

    private void reloadAccessToken(OAuth2Profile profile, OAuth2ClientFacade oAuth2Client) {
        block5: {
            try {
                if (profile.getRefreshToken() != null) {
                    log.info((Object)"The access token has expired, trying to refresh it.");
                    oAuth2Client.refreshAccessToken(profile);
                    log.info((Object)"The access token has been refreshed successfully.");
                    break block5;
                }
                if (profile.hasAutomationJavaScripts()) {
                    log.info((Object)"The access token has expired, trying to retrieve a new one with JavaScript automation.");
                    oAuth2Client.requestAccessToken(profile);
                    profile.waitForAccessTokenStatus(OAuth2Profile.AccessTokenStatus.RETRIEVED_FROM_SERVER, 5000);
                    if (profile.getAccessTokenStatus() == OAuth2Profile.AccessTokenStatus.RETRIEVED_FROM_SERVER) {
                        log.info((Object)"A new access token has been retrieved successfully.");
                        break block5;
                    }
                    log.warn((Object)"OAuth2 access token retrieval timed out after 5000 ms");
                    throw new RuntimeException("OAuth2 access token retrieval timed out after 5000 ms");
                }
                log.warn((Object)"No automation JavaScripts added to OAuth2 profile \u2013 cannot retrieve new access token");
                throw new RuntimeException("No automation JavaScripts added to OAuth2 profile \u2013 cannot retrieve new access token");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to refresh expired access token.", e);
            }
        }
    }
}

