/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.project;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.panels.support.ProgressBarTestSuiteAdapter;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropHandler;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropable;
import com.eviware.soapui.support.swing.AutoscrollSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragSource;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JProjectTestSuiteList
extends JPanel {
    private Map<TestSuite, TestSuiteListPanel> panels = new HashMap<TestSuite, TestSuiteListPanel>();
    private final WsdlProject project;
    private final InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private TestSuiteListPanel selectedTestSuite;

    public JProjectTestSuiteList(WsdlProject testSuite) {
        this.project = testSuite;
        this.setLayout(new BoxLayout(this, 1));
        for (int c = 0; c < testSuite.getTestSuiteCount(); ++c) {
            TestSuiteListPanel testSuiteListPanel = this.createTestSuiteListPanel(testSuite.getTestSuiteAt(c));
            this.panels.put(testSuite.getTestSuiteAt(c), testSuiteListPanel);
            this.add(testSuiteListPanel);
        }
        this.add(Box.createVerticalGlue());
        this.setBackground(Color.WHITE);
        testSuite.addProjectListener(this.testSuiteListener);
        ActionList actions = ActionListBuilder.buildActions(testSuite);
        actions.removeAction(0);
        actions.removeAction(0);
        this.setComponentPopupMenu(ActionSupport.buildPopup(actions));
        DragSource dragSource = DragSource.getDefaultDragSource();
        SoapUIDragAndDropHandler dragAndDropHandler = new SoapUIDragAndDropHandler(new TestSuiteListDragAndDropable(this), 2);
        dragSource.createDefaultDragGestureRecognizer(this, 3, dragAndDropHandler);
    }

    public void reset() {
        for (TestSuiteListPanel testSuitePanel : this.panels.values()) {
            testSuitePanel.reset();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.project.addProjectListener(this.testSuiteListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.project.removeProjectListener(this.testSuiteListener);
    }

    protected int getIndexOf(TestSuiteListPanel panel) {
        return Arrays.asList(this.getComponents()).indexOf(panel);
    }

    protected TestSuiteListPanel createTestSuiteListPanel(TestSuite testSuite) {
        TestSuiteListPanel testSuiteListPanel = new TestSuiteListPanel((WsdlTestSuite)testSuite);
        DragSource dragSource = DragSource.getDefaultDragSource();
        SoapUIDragAndDropHandler dragAndDropHandler = new SoapUIDragAndDropHandler(new TestSuiteListPanelDragAndDropable(testSuiteListPanel), 3);
        dragSource.createDefaultDragGestureRecognizer(testSuiteListPanel, 3, dragAndDropHandler);
        return testSuiteListPanel;
    }

    private static class TestSuiteListPanelDragAndDropable
    implements SoapUIDragAndDropable<ModelItem> {
        private final TestSuiteListPanel testSuitePanel;

        public TestSuiteListPanelDragAndDropable(TestSuiteListPanel testSuitePanel) {
            this.testSuitePanel = testSuitePanel;
        }

        @Override
        public JComponent getComponent() {
            return this.testSuitePanel;
        }

        @Override
        public void setDragInfo(String dropInfo) {
            this.testSuitePanel.setToolTipText(dropInfo.length() == 0 ? null : dropInfo);
        }

        @Override
        public Rectangle getModelItemBounds(ModelItem path) {
            return new Rectangle(this.testSuitePanel.getSize());
        }

        @Override
        public ModelItem getModelItemForLocation(int x, int y) {
            return this.testSuitePanel.getModelItem();
        }

        @Override
        public Component getRenderer(ModelItem path) {
            return null;
        }

        @Override
        public void selectModelItem(ModelItem path) {
            this.testSuitePanel.setSelected(!this.testSuitePanel.isSelected());
        }

        @Override
        public void toggleExpansion(ModelItem last) {
        }
    }

    private class TestSuiteListDragAndDropable
    implements SoapUIDragAndDropable<ModelItem> {
        private final JProjectTestSuiteList list;

        public TestSuiteListDragAndDropable(JProjectTestSuiteList list) {
            this.list = list;
        }

        @Override
        public JComponent getComponent() {
            return this.list;
        }

        @Override
        public Rectangle getModelItemBounds(ModelItem modelItem) {
            return this.list.getBounds();
        }

        @Override
        public ModelItem getModelItemForLocation(int x, int y) {
            int testSuiteCount = JProjectTestSuiteList.this.project.getTestSuiteCount();
            return testSuiteCount == 0 ? JProjectTestSuiteList.this.project : JProjectTestSuiteList.this.project.getTestSuiteAt(testSuiteCount - 1);
        }

        @Override
        public Component getRenderer(ModelItem modelItem) {
            return null;
        }

        @Override
        public void selectModelItem(ModelItem modelItem) {
        }

        @Override
        public void setDragInfo(String dropInfo) {
            this.list.setToolTipText(dropInfo);
        }

        @Override
        public void toggleExpansion(ModelItem modelItem) {
        }
    }

    public final class TestSuiteListPanel
    extends JPanel
    implements Autoscroll {
        private final WsdlTestSuite testSuite;
        private JProgressBar progressBar;
        private JLabel label;
        private ProgressBarTestSuiteAdapter progressBarAdapter;
        private TestSuitePropertyChangeListener testSuitePropertyChangeListener;
        private AutoscrollSupport autoscrollSupport;

        public TestSuiteListPanel(WsdlTestSuite testSuite) {
            super(new BorderLayout());
            this.setFocusable(true);
            this.testSuite = testSuite;
            this.autoscrollSupport = new AutoscrollSupport(this);
            this.progressBar = new JProgressBar(0, 100){

                @Override
                protected void processMouseEvent(MouseEvent e) {
                    if (e.getID() == 501 || e.getID() == 502) {
                        TestSuiteListPanel.this.processMouseEvent(this.translateMouseEvent(e));
                    }
                }

                @Override
                protected void processMouseMotionEvent(MouseEvent e) {
                    TestSuiteListPanel.this.processMouseMotionEvent(this.translateMouseEvent(e));
                }

                private MouseEvent translateMouseEvent(MouseEvent e) {
                    return new MouseEvent(TestSuiteListPanel.this, e.getID(), e.getWhen(), e.getModifiers(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                }
            };
            JPanel progressPanel = UISupport.createProgressBarPanel(this.progressBar, 5, false);
            this.progressBar.setMinimumSize(new Dimension(0, 10));
            this.progressBar.setBackground(Color.WHITE);
            this.progressBar.setInheritsPopupMenu(true);
            this.label = new JLabel(testSuite.getLabel());
            this.label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.label.setInheritsPopupMenu(true);
            this.label.setEnabled(!testSuite.isDisabled());
            if (UISupport.isMac()) {
                Font oldFont = this.label.getFont();
                Font newFont = new Font(oldFont.getName(), 1, oldFont.getSize());
                this.label.setFont(newFont);
            }
            this.add((Component)progressPanel, "Center");
            this.add((Component)this.label, "North");
            this.testSuitePropertyChangeListener = new TestSuitePropertyChangeListener();
            this.initPopup(testSuite);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TestSuiteListPanel.this.requestFocus();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() < 2) {
                        if (JProjectTestSuiteList.this.selectedTestSuite != null) {
                            JProjectTestSuiteList.this.selectedTestSuite.setSelected(false);
                        }
                        TestSuiteListPanel.this.setSelected(true);
                        JProjectTestSuiteList.this.selectedTestSuite = TestSuiteListPanel.this;
                        return;
                    }
                    UISupport.selectAndShow(TestSuiteListPanel.this.testSuite);
                }
            });
            this.addKeyListener(new TestSuiteListPanelKeyHandler());
            this.setSelected(false);
        }

        public void reset() {
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        }

        private void initPopup(WsdlTestSuite testSuite) {
            ActionList actions = ActionListBuilder.buildActions(testSuite);
            actions.insertAction(SwingActionDelegate.createDelegate("AddNewTestSuiteAction", JProjectTestSuiteList.this.project, null, null), 0);
            actions.insertAction(ActionSupport.SEPARATOR_ACTION, 1);
            this.setComponentPopupMenu(ActionSupport.buildPopup(actions));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.testSuite.addPropertyChangeListener(this.testSuitePropertyChangeListener);
            this.progressBarAdapter = new ProgressBarTestSuiteAdapter(this.progressBar, this.testSuite);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this.progressBarAdapter != null) {
                this.testSuite.removePropertyChangeListener(this.testSuitePropertyChangeListener);
                this.progressBarAdapter.release();
                this.progressBarAdapter = null;
            }
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension size = super.getMaximumSize();
            size.height = 50;
            return size;
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            } else {
                this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            }
        }

        public boolean isSelected() {
            return JProjectTestSuiteList.this.selectedTestSuite != null && JProjectTestSuiteList.this.selectedTestSuite.getTestSuite() == this.testSuite;
        }

        protected WsdlTestSuite getTestSuite() {
            return this.testSuite;
        }

        public ModelItem getModelItem() {
            return this.testSuite;
        }

        @Override
        public void autoscroll(Point pt) {
            int ix = JProjectTestSuiteList.this.getIndexOf(this);
            if (pt.getY() < 12.0 && ix > 0) {
                Rectangle bounds = JProjectTestSuiteList.this.getComponent(ix - 1).getBounds();
                JProjectTestSuiteList.this.scrollRectToVisible(bounds);
            } else if (pt.getY() > (double)(this.getHeight() - 12) && ix < JProjectTestSuiteList.this.project.getTestSuiteCount() - 1) {
                Rectangle bounds = JProjectTestSuiteList.this.getComponent(ix + 1).getBounds();
                JProjectTestSuiteList.this.scrollRectToVisible(bounds);
            }
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.autoscrollSupport.getAutoscrollInsets();
        }

        private final class TestSuiteListPanelKeyHandler
        extends KeyAdapter {
            private TestSuiteListPanelKeyHandler() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    UISupport.selectAndShow(TestSuiteListPanel.this.testSuite);
                    e.consume();
                } else {
                    ActionList actions = ActionListBuilder.buildActions(TestSuiteListPanel.this.testSuite);
                    if (actions != null) {
                        actions.dispatchKeyEvent(e);
                    }
                }
            }
        }

        private final class TestSuitePropertyChangeListener
        implements PropertyChangeListener {
            private TestSuitePropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(TestSuite.LABEL_PROPERTY)) {
                    TestSuiteListPanel.this.label.setEnabled(!TestSuiteListPanel.this.testSuite.isDisabled());
                    TestSuiteListPanel.this.label.setText(TestSuiteListPanel.this.testSuite.getLabel());
                } else if (evt.getPropertyName().equals(TestSuite.DISABLED_PROPERTY)) {
                    TestSuiteListPanel.this.initPopup(TestSuiteListPanel.this.testSuite);
                }
            }
        }
    }

    private final class InternalTestSuiteListener
    extends ProjectListenerAdapter {
        private InternalTestSuiteListener() {
        }

        @Override
        public void testSuiteAdded(TestSuite testSuite) {
            TestSuiteListPanel testSuiteListPanel = JProjectTestSuiteList.this.createTestSuiteListPanel(testSuite);
            JProjectTestSuiteList.this.panels.put(testSuite, testSuiteListPanel);
            JProjectTestSuiteList.this.add((Component)testSuiteListPanel, testSuite.getProject().getIndexOfTestSuite(testSuite));
            JProjectTestSuiteList.this.revalidate();
            JProjectTestSuiteList.this.repaint();
        }

        @Override
        public void testSuiteRemoved(TestSuite testSuite) {
            TestSuiteListPanel testSuiteListPanel = (TestSuiteListPanel)JProjectTestSuiteList.this.panels.get(testSuite);
            if (testSuiteListPanel != null) {
                JProjectTestSuiteList.this.remove(testSuiteListPanel);
                JProjectTestSuiteList.this.panels.remove(testSuite);
                JProjectTestSuiteList.this.revalidate();
                JProjectTestSuiteList.this.repaint();
            }
        }

        @Override
        public void testSuiteMoved(TestSuite testSuite, int index, int offset) {
            TestSuiteListPanel testSuiteListPanel = (TestSuiteListPanel)JProjectTestSuiteList.this.panels.get(testSuite);
            if (testSuiteListPanel != null) {
                boolean hadFocus = testSuiteListPanel.hasFocus();
                JProjectTestSuiteList.this.remove(testSuiteListPanel);
                JProjectTestSuiteList.this.add((Component)testSuiteListPanel, index + offset);
                JProjectTestSuiteList.this.revalidate();
                JProjectTestSuiteList.this.repaint();
                if (hadFocus) {
                    testSuiteListPanel.requestFocus();
                }
            }
        }
    }
}

