/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.model.mock.MockDispatcher;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunListener;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WsdlMockRunner
implements MockRunner {
    private final WsdlMockRunContext mockContext;
    private boolean running;
    private MockDispatcher dispatcher;

    public WsdlMockRunner(MockService mockService, WsdlTestRunContext context) throws Exception {
        HashSet<WsdlInterface> interfaces = new HashSet<WsdlInterface>();
        if (mockService instanceof WsdlMockService) {
            WsdlMockService wsdlMockService = (WsdlMockService)mockService;
            for (int i = 0; i < mockService.getMockOperationCount(); ++i) {
                WsdlOperation operation = ((WsdlMockOperation)wsdlMockService.getMockOperationAt(i)).getOperation();
                if (operation == null) continue;
                interfaces.add(operation.getInterface());
            }
        }
        for (WsdlInterface iface : interfaces) {
            iface.getWsdlContext().loadIfNecessary();
        }
        this.mockContext = new WsdlMockRunContext(mockService, context);
        this.dispatcher = mockService.createDispatcher(this.mockContext);
        this.start();
    }

    @Override
    public WsdlMockRunContext getMockContext() {
        return this.mockContext;
    }

    private MockService getMockService() {
        return this.getMockContext().getMockService();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void stop() {
        MockRunListener[] mockRunListeners;
        if (!this.isRunning()) {
            return;
        }
        SoapUI.getMockEngine().stopMockService(this);
        for (MockRunListener listener : mockRunListeners = this.getMockService().getMockRunListeners()) {
            listener.onMockRunnerStop(this);
        }
        try {
            this.getMockService().runStopScript(this.mockContext, this);
            this.running = false;
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    @Override
    public void release() {
        this.mockContext.clear();
        this.dispatcher = null;
    }

    @Override
    public int getMockResultCount() {
        return this.dispatcher.getMockResultCount();
    }

    @Override
    public MockResult getMockResultAt(int index) {
        return this.dispatcher.getMockResultAt(index);
    }

    @Override
    public MockResult dispatchRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        for (MockRunListener listener : this.getMockService().getMockRunListeners()) {
            MockResult result = listener.onMockRequest(this, request, response);
            if (!(result instanceof MockResult)) continue;
            return result;
        }
        String qs = request.getQueryString();
        if (qs != null && qs.startsWith("cmd=")) {
            try {
                this.dispatchCommand(request.getParameter("cmd"), request, response);
            }
            catch (IOException e) {
                throw new DispatchException(e);
            }
        }
        return this.dispatcher.dispatchRequest(request, response);
    }

    private void dispatchCommand(String cmd, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("stop".equals(cmd)) {
            response.setStatus(200);
            response.flushBuffer();
            SoapUI.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    WsdlMockRunner.this.stop();
                }
            });
        } else if ("restart".equals(cmd)) {
            response.setStatus(200);
            response.flushBuffer();
            SoapUI.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    WsdlMockRunner.this.stop();
                    try {
                        WsdlMockRunner.this.getMockService().start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public String getOverviewUrl() {
        return this.getMockService().getPath() + "?WSDL";
    }

    @Override
    public void start() throws Exception {
        MockRunListener[] mockRunListeners;
        if (this.running) {
            return;
        }
        this.mockContext.reset();
        this.getMockService().runStartScript(this.mockContext, this);
        SoapUI.getMockEngine().startMockService(this);
        this.running = true;
        for (MockRunListener listener : mockRunListeners = this.getMockService().getMockRunListeners()) {
            listener.onMockRunnerStart(this);
        }
        Analytics.trackAction((String)("Start Mock Service, ID: " + this.getMockService().getStringID()));
    }

    @Override
    public void setLogEnabled(boolean logEnabled) {
        this.dispatcher.setLogEnabled(logEnabled);
    }

    @Override
    public void clearResults() {
        this.dispatcher.clearResults();
    }

    @Override
    public void setMaxResults(long maxNumberOfResults) {
        this.dispatcher.setMaxResults(maxNumberOfResults);
    }
}

