/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.data.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogEntry;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.AbstractAction;
import org.jdesktop.swingx.JXTable;

public class ExportLoadTestLogAction
extends AbstractAction {
    private final LoadTestLog loadTestLog;
    private final JXTable logTable;

    public ExportLoadTestLogAction(LoadTestLog loadTestLog, JXTable logTable) {
        this.loadTestLog = loadTestLog;
        this.logTable = logTable;
        this.putValue("SmallIcon", UISupport.createImageIcon("/export.gif"));
        this.putValue("ShortDescription", "Export current loadtest log to a file");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.loadTestLog.getSize() == 0 || this.logTable != null && this.logTable.getRowCount() == 0) {
                UISupport.showErrorMessage("No data to export!");
                return;
            }
            File file = UISupport.getFileDialogs().saveAs(this, "Select file for log export");
            if (file == null) {
                return;
            }
            int cnt = this.exportToFile(file);
            UISupport.showInfoMessage("Saved " + cnt + " log entries to file [" + file.getName() + "]");
        }
        catch (IOException e1) {
            SoapUI.logError(e1);
        }
    }

    public int exportToFile(File file) throws IOException {
        PrintWriter writer = new PrintWriter(file);
        this.writeHeader(writer);
        int cnt = this.writeLog(writer);
        writer.flush();
        writer.close();
        return cnt;
    }

    private int writeLog(PrintWriter writer) {
        int cnt = 0;
        for (int c = 0; c < this.loadTestLog.getSize(); ++c) {
            int index;
            if (this.logTable != null && (index = this.logTable.getFilters().convertRowIndexToView(c)) == -1) continue;
            LoadTestLogEntry logEntry = (LoadTestLogEntry)this.loadTestLog.getElementAt(c);
            writer.write(DateUtil.formatFull(new Date(logEntry.getTimeStamp())));
            writer.write(44);
            writer.write(logEntry.getType());
            writer.write(44);
            String targetStepName = logEntry.getTargetStepName();
            writer.write(targetStepName == null ? "" : targetStepName);
            writer.write(",\"");
            writer.write(logEntry.getMessage());
            writer.write(34);
            writer.println();
            ++cnt;
        }
        return cnt;
    }

    private void writeHeader(PrintWriter writer) {
        writer.println("time,type,step,message");
    }
}

